angular
    .module('kamhpp')
    .controller('CimModelEditorCtrl', function ($scope, $http, $modal, clientSettings, notificationService, guid, $upload, language) {
    $scope.changes = [];
    $scope.isChanges = false;
    $scope.tree = {};
    $scope.columns = [{ header: language.getElementValue('cimModelClassesHdr') }];
    $scope.plugins = ['types', 'wholerow', 'grid', 'contextmenu'];
    $scope.startingData = {
        id: 'none',
        text: language.getElementValue('cimModelNeedAddClassHdr'),
        type: 'none',
    };
    $scope.contextMenu = {
        items: function (node) {
            var items = {
                Create: {
                    label: language.getElementValue('cimModelAddHdr'),
                    action: function () {
                        $scope.addNode(node, $scope.treeData);
                    },
                },
            };
            if (node.id != 'none') {
                items.CreateIn = {
                    label: language.getElementValue('cimModelAddInsideHdr'),
                    action: function () {
                        $scope.addChildNode(node, $scope.treeData);
                    },
                };
                items.Rename = {
                    label: language.getElementValue('cimModelRenameHdr'),
                    action: function () {
                        $scope.renameNode(node, $scope.treeData);
                    },
                };
                items.Delete = {
                    label: language.getElementValue('cimModelDeleteHdr'),
                    action: function () {
                        $scope.deleteNode(node);
                    },
                };
            }
            return items;
        },
    };
    $scope.addNode = function () {
        var parent = $scope.selectedNode != null ? $scope.selectedNode.ParentClassUniqueCode : '#';
        var classNames = _.map($scope.treeData, function (e) {
            return e.ClassName;
        });
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelClassWindow.html',
            controller: editCimModelClassCtrl,
            backdrop: 'static',
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelAddClassModalHdr'),
                        classNames: classNames,
                    };
                },
            },
        })
            .result.then(function (name) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/CreateClass', {
                name: name,
                baseClassUniqueCode: parent == '#' ? null : parent,
            })
                .then(function (response) {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = response.uniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        }, function () { });
    };
    $scope.addChildNode = function (node, treeData) {
        var classNames = _.map(treeData, function (e) { return e.ClassName; });
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelClassWindow.html',
            controller: editCimModelClassCtrl,
            backdrop: 'static',
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelAddingInsideClassHdr'),
                        classNames: classNames,
                    };
                },
            },
        })
            .result.then(function (name) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/CreateClass', {
                name: name,
                baseClassUniqueCode: node.id,
            })
                .then(function (response) {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = response.uniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        }, function () { });
    };
    $scope.renameNode = function (node, treeData) {
        var classNames = _.map(treeData, function (e) { return e.ClassName; });
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelClassWindow.html',
            controller: editCimModelClassCtrl,
            backdrop: 'static',
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelEditClassHdr'),
                        name: node.text,
                        classNames: classNames,
                    };
                },
            },
        })
            .result.then(function (name) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/UpdateClass', {
                uniqueCode: node.id,
                name: name,
            })
                .then(function () {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = node.id;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        }, function () { });
    };
    $scope.deleteNode = function (node) {
        $http.post(clientSettings.getServerInstance() + '/CimModel/DeleteClass', { uniqueCode: node.id }).then(function () {
            notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
            $scope.activeNode = node.parent;
            loadAndDraw();
        }, function () {
            notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
        });
    };
    $scope.treeData = [];
    $scope.attributeDataTypes = [];
    $scope.linkTypes = [];
    $scope.linkCapacities = [];
    $scope.selectedNode = null;
    $scope.loadData = function () {
        $http.get(clientSettings.getServerInstance() + '/CimModel/GetClassFlatTree').then(function (response) {
            $scope.treeData = response.data.Nodes;
            $scope.attributeDataTypes = response.data.AttributeDataTypes;
            $scope.linkTypes = response.data.LinkTypes;
            $scope.linkCapacities = response.data.LinkCapacities;
            if ($scope.treeData.length != 0)
                drawTree();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.$watch('tree.selectedElements', function () {
        if ($scope.tree.selectedElements === undefined || $scope.tree.selectedElements == '')
            return;
        var node = _.find($scope.treeData, function (arg) { return arg.ClassUniqueCode == $scope.tree.selectedElements; });
        if (node === undefined)
            return;
        $scope.selectedNode = node;
        $scope.linksTableSelected = undefined;
        $scope.attrTableSelected = undefined;
    });
    var loadAndDraw = function () {
        $scope.loadData();
        drawTree();
    };
    var drawTree = function () {
        $scope.treeNodes = _.map($scope.treeData, function (arg) { return ({
            id: arg.ClassUniqueCode,
            parent: arg.ParentClassUniqueCode,
            text: arg.ClassName,
            type: 'folder',
        }); });
        $scope.tree.element.jstree().settings.core.data =
            $scope.treeNodes.length == 0 ? $scope.startingData : $scope.treeNodes;
        $scope.tree.element.jstree().refresh();
    };
    $scope.attrTableClick = function (attribute) {
        $scope.attrTableSelected = attribute;
    };
    $scope.linkTableClick = function (link) {
        $scope.linksTableSelected = link;
    };
    $scope.addAttribute = function () {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelAttributeWindow.html',
            controller: editCimModelAttributeCtrl,
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelAddingAttributeHdr'),
                        types: $scope.attributeDataTypes,
                        names: _.map($scope.selectedNode.Attributes, function (attribute) { return attribute.Name; }),
                    };
                },
            },
        })
            .result.then(function (data) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/CreateAttribute', {
                name: data.name,
                classUniqueCode: $scope.selectedNode.ClassUniqueCode,
                type: data.type,
            })
                .then(function () {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        });
    };
    $scope.editAttribute = function () {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelAttributeWindow.html',
            controller: editCimModelAttributeCtrl,
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelEditAttributeHdr'),
                        types: $scope.attributeDataTypes,
                        names: _.map($scope.selectedNode.Attributes, function (attribute) { return attribute.Name; }),
                        name: $scope.attrTableSelected.Name,
                        type: $scope.attrTableSelected.DataType,
                    };
                },
            },
        })
            .result.then(function (data) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/UpdateAttribute', {
                uniqueCode: $scope.attrTableSelected.UniqueCode,
                name: data.name,
                type: data.type,
            })
                .then(function () {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        });
    };
    $scope.removeAttribute = function () {
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/DeleteAttribute', {
            uniqueCode: $scope.attrTableSelected.UniqueCode,
        })
            .then(function () {
            notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
            $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
            loadAndDraw();
        }, function () {
            notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
        });
    };
    $scope.addLink = function () {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelLinkWindow.html',
            controller: editCimModelLinkCtrl,
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelAddingLinkHdr'),
                        source: $scope.selectedNode.ClassName,
                        types: $scope.linkTypes,
                        capacities: $scope.linkCapacities,
                        tree: $scope.treeNodes,
                    };
                },
            },
            windowClass: 'link-modal-window',
        })
            .result.then(function (data) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/CreateLink', {
                name: data.name,
                source: $scope.tree.selectedElements[0],
                target: data.target,
                type: data.type,
                capacity: data.capacity,
            })
                .then(function () {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        });
    };
    $scope.editLink = function () {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/EditCimModelLinkWindow.html',
            controller: editCimModelLinkCtrl,
            resolve: {
                data: function () {
                    return {
                        action: language.getElementValue('cimModelEditLinkHdr'),
                        source: $scope.selectedNode.ClassName,
                        name: $scope.linksTableSelected.Name,
                        types: $scope.linkTypes,
                        type: $scope.linksTableSelected.LinkType,
                        capacities: $scope.linkCapacities,
                        capacity: $scope.linksTableSelected.LinkCapacity,
                        tree: $scope.treeNodes,
                        target: $scope.linksTableSelected.TargetClassUniqueCode,
                    };
                },
            },
            windowClass: 'link-modal-window',
        })
            .result.then(function (data) {
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/UpdateLink', {
                uniqueCode: $scope.linksTableSelected.LinkUniqueCode,
                name: data.name,
                target: data.target,
                type: data.type,
                capacity: data.capacity,
            })
                .then(function () {
                notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
                $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
                loadAndDraw();
            }, function () {
                notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
            });
        });
    };
    $scope.removeLink = function () {
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/DeleteLink', {
            uniqueCode: $scope.linksTableSelected.LinkUniqueCode,
        })
            .then(function () {
            notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
            $scope.activeNode = $scope.selectedNode.ClassUniqueCode;
            loadAndDraw();
        }, function () {
            notificationService.errorMessage(language.getElementValue('failedSaveChangesMsg'));
        });
    };
    var unregistrationJstreeRefreshOnFunc = $scope.$on('jstreeRefresh', function (event, data) {
        if ($scope.tree.element.attr('id') == data)
            $scope.tree.element.jstree().select_node($scope.activeNode);
    });
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId)
            $scope.loadData();
    });
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        $scope.tree.element.jstree().destroy();
        unregistrationJstreeRefreshOnFunc();
        unregistrationJstreeReadyOnFunc();
        unregistrationDestroyFunc();
    });
    $('#classEditorTreeContainer').css('max-height', window.innerHeight - 150 + 'px');
});
var editCimModelClassCtrl = function ($scope, $modalInstance, data, notificationService, language) {
    $scope.data = data;
    $scope.isClosingAsCancel = false;
    $scope.ok = function () {
        if ($scope.isClosingAsCancel)
            return;
        var u = _.find($scope.data.classNames, function (name) { return name.toLowerCase() == $scope.data.name.toLowerCase(); });
        if (u != undefined) {
            notificationService.warnMessage(language.getElementValue('cimModelNeedUniqClassNameMsg'));
        }
        else {
            $modalInstance.close($scope.data.name);
        }
    };
    $scope.cancel = function () {
        $scope.isClosingAsCancel = true;
        $modalInstance.dismiss('cancel');
    };
};
var editCimModelAttributeCtrl = function ($scope, $modalInstance, data, notificationService, language) {
    $scope.prevName = data.name;
    $scope.data = data;
    $scope.data.types.selected = _.find($scope.data.types, function (type) { return type.Name == $scope.data.type; });
    $scope.isClosingAsCancel = false;
    $scope.ok = function () {
        if ($scope.isClosingAsCancel)
            return;
        var u = _.find($scope.data.names, function (name) {
            return name.toLowerCase() == $scope.data.name.toLowerCase() &&
                name.toLowerCase() != $scope.prevName.toLowerCase();
        });
        if (u != undefined) {
            notificationService.warnMessage(language.getElementValue('cimModelNeedUniqAttributeNameMsg'));
        }
        else {
            $modalInstance.close({
                name: $scope.data.name,
                type: $scope.data.types.selected.Id,
            });
        }
    };
    $scope.cancel = function () {
        $scope.isClosingAsCancel = true;
        $modalInstance.dismiss('cancel');
    };
};
var editCimModelLinkCtrl = function ($scope, $modal, $modalInstance, data, notificationService, language) {
    $scope.data = data;
    if ($scope.data.target == undefined) {
        $scope.data.target = { text: language.getElementValue('cimModelUnselectClassHdr') };
    }
    else {
        $scope.data.target = _.find($scope.data.tree, function (node) { return node.id == $scope.data.target; });
    }
    $scope.data.types.selected = _.find($scope.data.types, function (type) { return type.Name == $scope.data.type; });
    $scope.data.capacities.selected = _.find($scope.data.capacities, function (capacity) { return capacity.Name == $scope.data.capacity; });
    $scope.isClosingAsCancel = false;
    $scope.ok = function () {
        if ($scope.isClosingAsCancel) {
            $scope.isClosingAsCancel = false;
            return;
        }
        if (_.isUndefined($scope.data.name) ||
            _.isUndefined($scope.data.types.selected) ||
            _.isUndefined($scope.data.capacities.selected) ||
            _.isUndefined($scope.data.target)) {
            notificationService.warnMessage(language.getElementValue('cimModelOneFieldNoValueMsg'));
            return;
        }
        $modalInstance.close({
            name: $scope.data.name,
            type: $scope.data.types.selected.Id,
            capacity: $scope.data.capacities.selected.Id,
            target: $scope.data.target.id,
        });
    };
    $scope.selectClass = function () {
        $scope.isClosingAsCancel = true;
        $('.link-modal-window').css('z-index', function (index, value) { return parseInt(value) - 10; });
        $modal
            .open({
            templateUrl: 'ng1/dist/src/CimModel/ClassEditor/CimSelectTargetClassWindow.html',
            controller: selectTargetClassCtrl,
            resolve: {
                data: function () {
                    return {
                        tree: $scope.data.tree,
                        activeNode: $scope.data.target,
                    };
                },
            },
            windowClass: 'target-modal-window',
        })
            .result.then(function (selectedElement) {
            $('.link-modal-window').css('z-index', function (index, value) { return parseInt(value) + 10; });
            var node = _.find($scope.data.tree, function (node) { return node.id == selectedElement; });
            $scope.data.target = node;
            if (_.isUndefined($scope.data.name)) {
                $scope.data.name = $scope.data.source + ' к ' + $scope.data.target.text;
            }
        });
    };
    $scope.getCapacityDescription = function (capacity) {
        if (capacity == language.getElementValue('cimModelOneToOneHdr')) {
            return String.Format(language.getElementValue('cimModelOneToOneCheckHdr'), $scope.data.source, $scope.data.target.text == language.getElementValue('cimModelUnselectClassHdr')
                ? ' '
                : $scope.data.target.text);
        }
        else {
            return String.Format(language.getElementValue('cimModelOneToMoreCheckHdr'), $scope.data.source, $scope.data.target.text == language.getElementValue('cimModelUnselectClassHdr')
                ? ' '
                : $scope.data.target.text);
        }
    };
    $scope.cancel = function () {
        $scope.isClosingAsCancel = true;
        $modalInstance.dismiss('cancel');
    };
};
var selectTargetClassCtrl = function ($scope, $modalInstance, data, language) {
    $scope.tree = {};
    $scope.data = data;
    $scope.columns = [{ header: language.getElementValue('cimModelClassesHdr') }];
    $scope.plugins = ['types', 'wholerow', 'grid'];
    $scope.ok = function () {
        $scope.$broadcast('$destroy');
        $modalInstance.close($scope.tree.selectedElements[0]);
    };
    var unregistrationJstreeRefreshOnFunc = $scope.$on('jstreeRefresh', function (event, data) {
        if ($scope.tree.element.attr('id') == data && $scope.data.activeNode.id != undefined)
            $scope.tree.element.jstree().select_node($scope.data.activeNode.id);
    });
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            $scope.tree.element.jstree().settings.core.data = $scope.data.tree;
            $scope.tree.element.jstree().refresh();
        }
    });
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        $scope.tree.element.jstree().destroy();
        unregistrationJstreeRefreshOnFunc();
        unregistrationJstreeReadyOnFunc();
        unregistrationDestroyFunc();
    });
};
