var DatabaseDiagnosticCtrl = (function () {
    function DatabaseDiagnosticCtrl(language, appDiagnosticProvider) {
        this.language = language;
        this.appDiagnosticProvider = appDiagnosticProvider;
        this.isShowReplicationInfo = false;
        this.dateFormat = Date.masks.fullDateTime;
        this.databaseInfos = [];
        this.loadDatabaseInfo();
    }
    DatabaseDiagnosticCtrl.prototype.getDatabaseTypeName = function (databaseConnection) {
        switch (databaseConnection.type) {
            case 2:
                return 'Microsoft SQL Server';
            case 0:
                return 'PostgreSQL';
            case 1:
                return 'SQLite';
            case 3:
                return 'MariaDB';
            default:
                return '';
        }
    };
    DatabaseDiagnosticCtrl.prototype.getDatabaseRole = function (databaseInfo) {
        switch (databaseInfo.role) {
            case 0:
                return this.language.getElementValue('diagnosticDataBaseRolePrimaryHdr');
            case 1:
                return this.language.getElementValue('diagnosticDataBaseRoleStandbyHdr');
            default:
                return '';
        }
    };
    DatabaseDiagnosticCtrl.prototype.getDbRole = function (databaseInfo) {
        switch (databaseInfo.role) {
            case 0:
                return this.language.getElementValue('diagnosticDataBaseRolePrimaryDbHdr');
            case 1:
                return this.language.getElementValue('diagnosticDataBaseRoleStandbyDbHdr');
            default:
                return '';
        }
    };
    DatabaseDiagnosticCtrl.prototype.loadDatabaseInfo = function () {
        var _this = this;
        this.appDiagnosticProvider.getDatabasesInfo().then(function (databaseInfos) {
            _this.databaseInfos = databaseInfos;
            _this.isShowReplicationInfo = _.every(databaseInfos, function (info) { return (info === null || info === void 0 ? void 0 : info.type) === 3; });
            _this.onRefresh();
        });
    };
    DatabaseDiagnosticCtrl.prototype.localizeStatus = function (status) {
        if (this.language.language === 'ru') {
            return status ? 'Да' : 'Нет';
        }
        return status ? 'Yes' : 'No';
    };
    DatabaseDiagnosticCtrl.$inject = ['language', 'appDiagnosticProvider'];
    return DatabaseDiagnosticCtrl;
}());
angular.module('kamhpp').controller('DatabaseDiagnosticCtrl', DatabaseDiagnosticCtrl);
