// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с деревом тегов

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)
#uses "Technodoc/Common/technodocDatapoint"


//--------------------------------------------------------------------------------
// Variables and Constants


//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Вернуть список узлов службы общих имен
  @return Список узлов службы общих имен
*/
dyn_dyn_string getCnsNodes(string filter)
{
  bool hasNodes = false;
  dyn_dyn_string result;

  dyn_string systemNames;
  dyn_uint systemIds;

  getSystemNames(systemNames, systemIds);

  for (int i = 1; i <= dynlen(systemNames); i++)
  {
    langString cnsSystemNames;
    cnsGetSystemNames(systemNames[i], cnsSystemNames);

    string cnsSystemName = cnsSystemNames.text() != ""
      ? cnsSystemNames.text()
      : systemNames[i];

    // Добавляем узел системы
    dynAppend(result, makeDynString(systemNames[i], "", cnsSystemName, "1", ""));

    dyn_string viewPaths;
    cnsGetViews(systemNames[i], viewPaths);

    for (int j = 1; j <= dynlen(viewPaths); j++)
    {
      langString cnsViewNames;
      cnsGetViewDisplayNames(viewPaths[j], cnsViewNames);

      string cnsViewName = cnsViewNames.text() != ""
        ? cnsViewNames.text()
        : viewPaths[j];

      // Добавляем узел представления
      dynAppend(result, makeDynString(viewPaths[j], systemNames[i], cnsViewName, "1", ""));

      dyn_string nodePathIds = getCnsNodesByFilter(filter, systemNames[i], viewPaths[j]);

      if (!hasNodes) {
        hasNodes = dynlen(nodePathIds) != 0;
      }

      for (int k = 1; k <= dynlen(nodePathIds); k++)
      {
        string pathId =  nodePathIds[k];

        // Получаем тип и адрес узла
        string address = "";
        int type = 0;
        cnsGetId(pathId, address, type);

        // Получаем отображаемый путь узла (полное название)
        langString name = "";
        cnsGetDisplayPath(pathId, name);

        // Получаем путь к родительскому элементу
        string parentPathId = viewPaths[j];
        cnsGetParent(pathId, parentPathId);

        dynAppend(result, makeDynString(pathId, parentPathId, name[0], (string)type, address));
      }
    }
  }

  // Если задан фильтр и не был найден ни один узел, то возвращаем пустой массив строк
  return filter != "" && !hasNodes
    ? makeDynString()
    : result;
}

dyn_string getCnsNodesByFilter(string filter, string systemName, string viewPath)
{
  dyn_string nodePathIds;

  if (filter == "")
  {
    cnsGetNodesByName("*",
      viewPath,
      CNS_SEARCH_NAME | CNS_SEARCH_CASE_INSENSITIVE,
      CNS_SEARCH_ALL_LANGUAGES,
      CNS_DATATYPE_ALL_TYPES,
      nodePathIds);

    return nodePathIds;
  }

  string pattern = filter.contains("*") || filter.contains("?")
    ? filter
    : "*" + filter + "*";

  cnsGetNodesByName(
    pattern,
    viewPath,
    CNS_SEARCH_DISPLAY_NAME | CNS_SEARCH_CASE_INSENSITIVE,
    CNS_SEARCH_ALL_LANGUAGES,
    CNS_DATATYPE_DATAPOINT,
    nodePathIds);

  dyn_string resultPathIds = makeDynString();

  for (int i = 1; i <= dynlen(nodePathIds); i++)
  {
    string parentPathId;
    string currentPathId = nodePathIds[i];

    do
    {
      cnsGetParent(currentPathId, parentPathId);

      if (resultPathIds.contains(parentPathId))
      {
        break;
      }

      resultPathIds.append(parentPathId);
      currentPathId = parentPathId;
    }
    while (parentPathId != systemName + '.' + viewPath);
  }

  for (int i = 1; i <= dynlen(nodePathIds); i++)
  {
    resultPathIds.append(nodePathIds[i]);
  }

  return resultPathIds;
}

/** Вернуть дерево тегов
  @return Дерево тегов
*/
dyn_dyn_mixed getTagTree()
{
  string internalPointPrefix = "_";

  dyn_dyn_mixed structure;

  //Получить все системы
  dyn_string sysNames;
  dyn_uint sysIds;

  getSystemNames(sysNames, sysIds);

  int sysCount = dynlen(sysNames);

  // Для каждой системы
  for (int i = 1; i <= sysCount; i++)
  {

    string sysName = sysNames[i];
    uint sysId = sysIds[i];

    dyn_dyn_mixed sysArr;

    // получить типы тегов для системы
    dyn_string dpTypeNames=dpTypes("*", sysId);

    int dpTypeCount = dynlen(dpTypeNames);

    for (int k = 1; k <= dpTypeCount; k++)
    {
       string typeName = dpTypeNames[k];

       // Отфильтровать Internal datapoints
       if(strpos(typeName, internalPointPrefix) == 0) continue;

       // Получить точки первого уровня
       dyn_dyn_mixed points = processTag(sysName + ":", typeName, 0);

       //DebugTN(typeName, dynlen(points));

       dynAppend(sysArr, dynlen(points) > 0
                 ? makeDynMixed(typeName, points)
                 : makeDynMixed(typeName));
    }

    dynAppend(structure, makeDynMixed(sysName, sysArr));

  }
  return structure;

}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

/** Вернуть список точек для уровня
  @param dpPattern Паттерн для поиска точек данных
  @param typeName Тип точек данных
  @param level Уровень для поиска точек данных
  @return Список точек данных для текущего уровня с вложенными точками данных
*/
private dyn_dyn_mixed processTag(string dpPattern, string typeName, int level)
{
  string masterPointPrefix = dpPattern+"_mp_";
  level++;

  dyn_dyn_mixed pointsData;

  // Получить точки текущего уровня
  dyn_string points = dpNames(dpPattern +"*", typeName);
  int pointCount = dynlen(points);

  // Для каждой точки
  for (int j = 1; j <= pointCount; j++)
  {
     string point = points[j];

     // Отфильтровать  masterpoints если на уровне тега
     if(level == 1 && strpos(point, masterPointPrefix) == 0) continue;

     // Получить тип данных точки
     int typeValue = (level == 1) ? dpElementType(point + ".") : dpElementType(point);

     // Получить вложенные точки для типа
     dyn_mixed internalProperties = processTag(point + ".", typeName,level);

     // Получить Description
     string description = (level == 1)? getNodeDescription(point + ".") : getDatapointDescription(point, -1);

     // Получить имя точки
     dyn_string pointNames = (level == 1) ? strsplit(point, ":") : strsplit(point, ".");
     string pointName = pointNames[dynlen(pointNames)];

     dyn_dyn_mixed pointData;
     dynAppend(pointData, dynlen(internalProperties) > 0
                           ? makeDynMixed(pointName, description, typeValue, internalProperties)
                           : makeDynMixed(pointName, description, typeValue));

     dynAppend(pointsData, pointData);
  }
  return pointsData;
}

/** Вернуть описание точки данных
  @param address Адрес точки данных
  @return Описание точки данных
*/
private string getNodeDescription(string address)
{
  return (string)dpGetDescription(address, -1);
}

