﻿CREATE TABLE CimAttributeDataTypes (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Name TEXT NOT NULL,
    CONSTRAINT PK_CimAttributeDataTypes PRIMARY KEY(Id)
);

CREATE TABLE CimAttributeInstances (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    AttributeUniqueCode TEXT,
    ClassIstanceUniqueCode TEXT,
    Value TEXT,
    CONSTRAINT PK_CimAttributeInstances PRIMARY KEY(Id)
);

CREATE TABLE CimClasses (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    Name TEXT NOT NULL,
    BaseClassUniqueCode TEXT,
    CONSTRAINT PK_CimClasses PRIMARY KEY(Id)
);

CREATE TABLE CimClassInstances (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    Name TEXT NOT NULL,
    ClassUniqueCode TEXT NOT NULL,
    CONSTRAINT PK_CimClassInstances PRIMARY KEY(Id)
);

CREATE TABLE CimDictionaryProfileSets (
    Id CHAR(36) NOT NULL,
    Name TEXT,
    CONSTRAINT PK_CimDictionaryProfileSets PRIMARY KEY(Id)
);

CREATE TABLE CimLinkCapacities (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Name TEXT NOT NULL,
    CONSTRAINT PK_CimLinkCapacities PRIMARY KEY(Id)
);

CREATE TABLE CimLinkInstances (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    LinkUniqueCode TEXT,
    SourceClassInstanceUniqueCode TEXT NOT NULL,
    TargetClassInstanceUniqueCode TEXT NOT NULL,
    CONSTRAINT PK_CimLinkInstances PRIMARY KEY(Id)
);

CREATE TABLE CimLinkTypes (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Name TEXT NOT NULL,
    CONSTRAINT PK_CimLinkTypes PRIMARY KEY(Id)
);

CREATE TABLE CimAttributes (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    Name TEXT NOT NULL,
    ClassUniqueCode TEXT NOT NULL,
    DataTypeId INTEGER NOT NULL,
    CONSTRAINT PK_CimAttributes PRIMARY KEY(Id),
    CONSTRAINT FK_CimAttributes_CimAttributeDataTypes_DataTypeId FOREIGN KEY(DataTypeId) REFERENCES CimAttributeDataTypes(Id) ON DELETE CASCADE
);

CREATE TABLE CimLinks (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueCode TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME,
    Name TEXT NOT NULL,
    SourceClassUniqueCode TEXT NOT NULL,
    TargetClassUniqueCode TEXT NOT NULL,
    TypeId INTEGER NOT NULL,
    CapacityId INTEGER NOT NULL,
    CONSTRAINT PK_CimLinks PRIMARY KEY(Id),
    CONSTRAINT FK_CimLinks_CimLinkCapacities_CapacityId FOREIGN KEY(CapacityId) REFERENCES CimLinkCapacities(Id) ON DELETE CASCADE,
    CONSTRAINT FK_CimLinks_CimLinkTypes_TypeId FOREIGN KEY(TypeId) REFERENCES CimLinkTypes(Id) ON DELETE CASCADE
);

CREATE TABLE ExternalConnectionSettings (
    Id CHAR(36) NOT NULL,
    Name TEXT NOT NULL,
    Type INTEGER NOT NULL,
    Json LONGTEXT NOT NULL,
    RetryCount INTEGER DEFAULT 1 NOT NULL,
    RetryInterval	INTEGER DEFAULT 0 NOT NULL,
    CONSTRAINT PK_ExternalConnectionSettings PRIMARY KEY(Id)
);

CREATE TABLE ReportTemplates (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UniqueGuid CHAR(36) NOT NULL,
    Version INTEGER NOT NULL,
    Name TEXT NOT NULL,
    Chapter TEXT NOT NULL,
    Parameters LONGTEXT NOT NULL,
    Html LONGTEXT,
    Rules LONGTEXT NOT NULL,
    ContentVersion INTEGER NOT NULL,
    HasStep BOOLEAN NOT NULL,
    IsHide BOOLEAN NOT NULL,
    PeriodStep TEXT,
    Priority INTEGER NOT NULL,
    ReportType INTEGER NOT NULL,
    ReportViewMode INTEGER NOT NULL,
    CONSTRAINT PK_ReportTemplates PRIMARY KEY(Id)
);

CREATE TABLE Reports (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Name TEXT NOT NULL,
    StartDate DATETIME NOT NULL,
    EndDate DATETIME NOT NULL,
    "Values" LONGBLOB,
    RecalculationState INTEGER NOT NULL,
    CalculationResult INTEGER NOT NULL,
    IsCompleted BOOLEAN NOT NULL,
    HasIncompletedRules BOOLEAN NOT NULL,
    ReportTemplateUniqueGuid CHAR(36) NOT NULL,
    PredefinedValuesHashCode INTEGER NOT NULL,
    UpdatedDate DATETIME NOT NULL,
    ReportTemplateId INTEGER NOT NULL,
    ContentVersion INTEGER NOT NULL,
    Changes LONGTEXT,
    CreatedDate DATETIME NOT NULL,
    CreatedUserName TEXT,
    DependentReports LONGTEXT,
    LockDate DATETIME,
    PredefinedValues LONGTEXT NOT NULL,
    Rules LONGTEXT,
    CONSTRAINT PK_Reports PRIMARY KEY(Id),
    CONSTRAINT FK_Reports_ReportTemplates_ReportTemplateId FOREIGN KEY(ReportTemplateId) REFERENCES ReportTemplates(Id) ON DELETE CASCADE
);

CREATE TABLE ServerSettings (
    Name VARCHAR(191) NOT NULL,
    Value LONGTEXT,
    CONSTRAINT PK_ServerSettings PRIMARY KEY(Name)
);

CREATE TABLE SysLogs (
    Id CHAR(36) NOT NULL,
    ActionTime TIMESTAMP NOT NULL,
    User TEXT NOT NULL,
    Description LONGTEXT NOT NULL,
    TagValues TEXT NOT NULL,
    CONSTRAINT PK_SysLogs PRIMARY KEY(Id)
);

CREATE TABLE OTParameters (
    Id CHAR(36) NOT NULL,
    Name VARCHAR(191) NOT NULL,
    Algorithm TEXT NOT NULL,
    CONSTRAINT PK_OTParameters PRIMARY KEY(Id)
);

CREATE TABLE OTAlgorithmConstants (
    Id CHAR(36) NOT NULL,
    Name TEXT NOT NULL,
    ParameterId CHAR(36) NOT NULL,
    CONSTRAINT PK_OTAlgorithmConstants PRIMARY KEY(Id),
    CONSTRAINT FK_OTAlgorithmConstants_OTParameters_ParameterId FOREIGN KEY(ParameterId) REFERENCES OTParameters(Id) ON DELETE CASCADE
);

CREATE TABLE OTAlgorithmParameters (
    Id CHAR(36) NOT NULL,
    Name TEXT NOT NULL,
    ParameterId CHAR(36) NOT NULL,
    CONSTRAINT PK_OTAlgorithmParameters PRIMARY KEY(Id),
    CONSTRAINT FK_OTAlgorithmParameters_OTParameters_ParameterId FOREIGN KEY(ParameterId) REFERENCES OTParameters(Id) ON DELETE CASCADE
);

CREATE TABLE OTDevices (
    Id CHAR(36) NOT NULL,
    Name TEXT NOT NULL,
    ParameterId CHAR(36) NOT NULL,
    CONSTRAINT PK_OTDevices PRIMARY KEY(Id),
    CONSTRAINT FK_OTDevices_OTParameters_ParameterId FOREIGN KEY(ParameterId) REFERENCES OTParameters(Id) ON DELETE CASCADE
);

CREATE TABLE OTParameterStates (
    Id CHAR(36) NOT NULL,
    Name TEXT NOT NULL,
    ParameterId CHAR(36) NOT NULL,
    Value INTEGER NOT NULL,
    LineType INTEGER NOT NULL,
    BackgroundColor INTEGER NOT NULL,
    CONSTRAINT PK_OTParameterStates PRIMARY KEY(Id),
    CONSTRAINT FK_OTParameterStates_OTParameters_ParameterId FOREIGN KEY(ParameterId) REFERENCES OTParameters(Id) ON DELETE CASCADE
);

CREATE TABLE OTAlgorithmConstantCrosses (
    Id CHAR(36) NOT NULL,
    AlgorithmConstantId CHAR(36) NOT NULL,
    DeviceId CHAR(36) NOT NULL,
    Value DOUBLE NOT NULL,
    CONSTRAINT PK_OTAlgorithmConstantCrosses PRIMARY KEY(Id),
    CONSTRAINT FK_OTAlgConstCrosses_OTAlgConst_AlgConsttId FOREIGN KEY(AlgorithmConstantId) REFERENCES OTAlgorithmConstants(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTAlgorithmConstantCrosses_OTDevices_DeviceId FOREIGN KEY(DeviceId) REFERENCES OTDevices(Id) ON DELETE CASCADE
);

CREATE TABLE OTAlgorithmParameterCrosses (
    Id CHAR(36) NOT NULL,
    AlgorithmParameterId CHAR(36) NOT NULL,
    DeviceId CHAR(36) NOT NULL,
    Address TEXT,
    CONSTRAINT PK_OTAlgorithmParameterCrosses PRIMARY KEY(Id),
    CONSTRAINT FK_OTAlgorithmParameterCrosses_OTDevices_DeviceId FOREIGN KEY(DeviceId) REFERENCES OTDevices(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTAlgParamCrosses_OTAlgParam_AlgoParamId FOREIGN KEY(AlgorithmParameterId) REFERENCES OTAlgorithmParameters(Id) ON DELETE CASCADE
);

CREATE TABLE Mails (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    CreationDate timestamp NOT NULL,
    SendingDate timestamp,
    SenderAdress TEXT NOT NULL,
    RecipientsAddresses TEXT NOT NULL,
    Subject TEXT NOT NULL,
    Body TEXT,
    IsSent boolean NOT NULL,
    CONSTRAINT PK_Mail PRIMARY KEY(Id)
);

CREATE TABLE MailAttachments (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    MailId INTEGER NOT NULL,
    Name TEXT NOT NULL,
    ContentMediaType TEXT NOT NULL,
    ContentStream LONGBLOB NOT NULL,
    CONSTRAINT PK_MailAttachments PRIMARY KEY(Id),
    CONSTRAINT FK_MailAttachments_Mails_MailId FOREIGN KEY(MailId) REFERENCES Mails(Id) ON DELETE CASCADE
);

CREATE TABLE SFTemplates (
    Id INTEGER AUTO_INCREMENT,
    Name VARCHAR(191) NOT NULL UNIQUE,
    HeaderHtml LONGTEXT,
    FooterHtml LONGTEXT,
    IsTypical boolean NOT NULL,
    CreationDate DATETIME,
    CreatedUserName TEXT NOT NULL,
    ParentTemplateId INTEGER,
    Description TEXT,
    ChapterName TEXT,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFTemplates_SFTemplates_ParentTemplateId FOREIGN KEY(ParentTemplateId) REFERENCES SFTemplates(Id) ON DELETE SET NULL
);

CREATE TABLE SFOperations (
    Id INTEGER AUTO_INCREMENT,
    Description TEXT NOT NULL,
    Type INTEGER NOT NULL,
    IsTypical BOOLEAN NOT NULL,
    CONSTRAINT PK_SFOperations PRIMARY KEY (Id)
);

CREATE TABLE SFConditions (
    Id INTEGER AUTO_INCREMENT,
    Description TEXT NOT NULL,
    Type INTEGER NOT NULL,
    IsTypical BOOLEAN NOT NULL,
    CONSTRAINT PK_SFConditions PRIMARY KEY(Id)
);

CREATE TABLE SFTemplateOperation (
    Id INTEGER AUTO_INCREMENT,
    SwitchoverFormTemplateId INTEGER NOT NULL,
    SwitchoverFormCommonOperationId INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    IsOrderNumberHidden INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFTemplateOp_SFOperations_SwitchoverFormCommonOpId FOREIGN KEY(SwitchoverFormCommonOperationId) REFERENCES SFOperations(Id) ON DELETE RESTRICT,
    CONSTRAINT FK_SFTemplateOp_SFTemplates_SwitchoverFormTemplateId FOREIGN KEY(SwitchoverFormTemplateId) REFERENCES SFTemplates(Id) ON DELETE CASCADE
);

CREATE TABLE SFTemplateCondition (
    Id INTEGER AUTO_INCREMENT,
    SwitchoverFormTemplateId INTEGER NOT NULL,
    SwitchoverFormCommonConditionId INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    IsOrderNumberHidden INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFTemplateCond_SFConditions_SwitchoverFormCommonCondId FOREIGN KEY(SwitchoverFormCommonConditionId) REFERENCES SFConditions(Id) ON DELETE RESTRICT,
    CONSTRAINT FK_SFTemplateCondition_SFTemplates_SwitchoverFormTemplateId FOREIGN KEY(SwitchoverFormTemplateId) REFERENCES SFTemplates(Id) ON DELETE CASCADE
);

CREATE TABLE SFOperationCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Type INTEGER NOT NULL,
    Source INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormCommonOperationId INTEGER NOT NULL,
    DelayAfterExecutionMsec INTEGER,
    DelayBeforeExecutionMsec INTEGER,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFOpCommands_SFOperations_SwitchoverFormCommonOpId FOREIGN KEY(SwitchoverFormCommonOperationId) REFERENCES SFOperations(Id) ON DELETE CASCADE
);

CREATE TABLE SFConditionCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Type INTEGER NOT NULL,
    Source INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormCommonConditionId INTEGER NOT NULL,
    DelayAfterExecutionMsec INTEGER,
    DelayBeforeExecutionMsec INTEGER,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFConditionCommands_SFConditions_SwitchoverFormConditionId FOREIGN KEY(SwitchoverFormCommonConditionId) REFERENCES SFConditions(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormCommonAlarms (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT NOT NULL,
    PRIMARY KEY(Id)
);

CREATE TABLE SFFormTemplateAlarms (
    SwitchoverFormTemplateId INTEGER NOT NULL,
    SwitchoverFormCommonAlarmId INTEGER NOT NULL,
    CONSTRAINT PK_SFFormAlarms PRIMARY KEY(SwitchoverFormTemplateId,SwitchoverFormCommonAlarmId),
    CONSTRAINT FK_SFFormTemplateAlarms_SFTemplates_SwitchoverFormTemplateId FOREIGN KEY(SwitchoverFormTemplateId) REFERENCES SFTemplates(Id) ON DELETE CASCADE,
    CONSTRAINT FK_SFFormTemplateAlarms_SFFormComAlarms_SwitchoverFormComAlarmId FOREIGN KEY(SwitchoverFormCommonAlarmId) REFERENCES SFFormCommonAlarms(Id) ON DELETE RESTRICT
);

CREATE TABLE SFFormCommonAlarmCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Source INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormCommonAlarmId INTEGER NOT NULL,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormCommonAlarmCommands_SFCommonAlarms_SFCommonAlarmId FOREIGN KEY(SwitchoverFormCommonAlarmId) REFERENCES SFFormCommonAlarms(Id) ON DELETE CASCADE
);

CREATE TABLE CimDictionaryProfiles (
    Id CHAR(36) NOT NULL,
    SourceUniqueCode TEXT,
    TargetUniqueCode TEXT,
    LinkUniqueCode TEXT,
    Name TEXT,
    IsBackLink INTEGER NOT NULL,
    CreateGroupNode INTEGER NOT NULL,
    ShowRecursiveSelfLinks INTEGER NOT NULL,
    ParentId TEXT,
    CimDictionaryProfileSetId CHAR(36) NOT NULL,
    CONSTRAINT PK_CimDictionaryProfiles PRIMARY KEY(Id),
    CONSTRAINT FK_CimDictProfiles_CimDictProfileSets_CimDictProfileSetId FOREIGN KEY(CimDictionaryProfileSetId) REFERENCES CimDictionaryProfileSets(Id) ON DELETE CASCADE
);

CREATE TABLE Timezones (
    Ident VARCHAR(191) NOT NULL,
    TimezoneOffsetMinutes INTEGER NOT NULL,
    CONSTRAINT PK_Timezones PRIMARY KEY(Ident)
);

CREATE TABLE WinCCOATreeElements (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    Name TEXT NOT NULL,
    Description TEXT NOT NULL,
    FullName TEXT,
    ParentId INTEGER,
    ElementType INTEGER NOT NULL,
    HasChildren INTEGER NOT NULL,
    ConnectionIdent CHAR(36) NOT NULL,
    CONSTRAINT PK_WinCCOATreeElements PRIMARY KEY(Id),
    CONSTRAINT FK_WinCCOATreeElements_WinCCOATreeElements_ParentId FOREIGN KEY(ParentId) REFERENCES WinCCOATreeElements(Id) ON DELETE CASCADE,
    CONSTRAINT FK_WinCCOATreeElements_ExternalConnection_ConnectionIdent FOREIGN KEY(ConnectionIdent) REFERENCES ExternalConnectionSettings(Id) ON DELETE CASCADE
);

CREATE TABLE SFForms (
    Id INTEGER AUTO_INCREMENT,
    TemplateId INTEGER,
    Name TEXT NOT NULL,
    SerialNumber INTEGER NOT NULL CHECK(SerialNumber > 0),
    HeaderHtml LONGTEXT,
    FooterHtml LONGTEXT,
    Status INTEGER NOT NULL,
    CreationDate TEXT NOT NULL,
    CloseDate TEXT,
    StopDate TEXT,
    StopReason TEXT,
    StopUserFullName TEXT,
    Description TEXT,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFForms_SFTemplates_TemplateId FOREIGN KEY(TemplateId) REFERENCES SFTemplates(Id) ON DELETE SET NULL
);

CREATE TABLE SFFormAlarms (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT NOT NULL,
    SwitchoverFormId INTEGER NOT NULL,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormAlarms_SFForms_SwitchoverFormId FOREIGN KEY(SwitchoverFormId) REFERENCES SFForms(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormAlarmCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Source INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormAlarmId INTEGER NOT NULL,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormAlarmCommands_SFFormAlarms_SwitchoverFormAlarmId FOREIGN KEY(SwitchoverFormAlarmId) REFERENCES SFFormAlarms(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormConditions (
    Id INTEGER AUTO_INCREMENT,
    Description TEXT NOT NULL,
    Type INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    Status INTEGER NOT NULL,
    ExecutionDate TEXT,
    RemoteControlKeyPosition INTEGER NOT NULL,
    SwitchoverFormId INTEGER NOT NULL,
    IsOrderNumberHidden INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormConditions_SFForms_SwitchoverFormId FOREIGN KEY(SwitchoverFormId) REFERENCES SFForms(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormConditionCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Type INTEGER NOT NULL,
    Source INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormConditionId INTEGER NOT NULL,
    DelayAfterExecutionMsec INTEGER,
    DelayBeforeExecutionMsec INTEGER,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormCondCommands_SFFormConds_SwitchoverFormCondId FOREIGN KEY(SwitchoverFormConditionId) REFERENCES SFFormConditions(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormOperations (
    Id INTEGER AUTO_INCREMENT,
    Description TEXT NOT NULL,
    Type INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    Status INTEGER NOT NULL,
    ExecutionDate TEXT,
    RemoteControlKeyPosition INTEGER NOT NULL,
    SwitchoverFormId INTEGER NOT NULL,
    IsOrderNumberHidden boolean NOT NULL DEFAULT false,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormOperations_SFForms_SwitchoverFormId FOREIGN KEY(SwitchoverFormId) REFERENCES SFForms(Id) ON DELETE CASCADE
);

CREATE TABLE SFFormOperationCommands (
    Id INTEGER AUTO_INCREMENT,
    Name TEXT,
    Type INTEGER NOT NULL,
    Source INTEGER NOT NULL,
    OrderNumber INTEGER NOT NULL,
    TagAddress TEXT NOT NULL,
    Value TEXT NOT NULL,
    SwitchoverFormOperationId INTEGER NOT NULL,
    DelayAfterExecutionMsec INTEGER,
    DelayBeforeExecutionMsec INTEGER,
    PRIMARY KEY(Id),
    CONSTRAINT FK_SFFormOpCommands_SFFormOps_SwitchoverFormOpId FOREIGN KEY(SwitchoverFormOperationId) REFERENCES SFFormOperations(Id) ON DELETE CASCADE
);

CREATE TABLE SFTemplateAttachments (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    SwitchoverFormTemplateId INTEGER NOT NULL,
    Name TEXT NOT NULL,
    ContentMediaType TEXT NOT NULL,
    ContentStream LONGBLOB NOT NULL,
    CONSTRAINT PK_SFTemplateAttachments PRIMARY KEY(Id),
    CONSTRAINT FK_SFTemplateAttachments_SFTemplates_SwitchoverFormTemplateId FOREIGN KEY(SwitchoverFormTemplateId) REFERENCES SFTemplates(Id) ON DELETE CASCADE
);

CREATE TABLE Users (
    Id CHAR(36) NOT NULL,
    Login VARCHAR(191) NOT NULL,
    Name TEXT NOT NULL,
    Password TEXT NOT NULL,
    IsActive boolean NOT NULL,
    Position TEXT NULL,
    Signature LONGBLOB null,
    SigningAuthority TEXT null,
    AuthenticationType INTEGER DEFAULT 0,
    CONSTRAINT USERS_PK PRIMARY KEY(Id)
);

CREATE TABLE Roles (
    Id CHAR(36),
    Name VARCHAR(191),
    PermissionIdents LONGTEXT,
    IsDomainUserGroup boolean NOT NULL,
    CONSTRAINT ROLES_PK PRIMARY KEY(Id)
);

CREATE TABLE OTChanges (
    Id INTEGER NOT NULL AUTO_INCREMENT,
    UserId CHAR(36) NOT NULL,
    ChangeTime DATETIME NOT NULL,
    OldTimestamp DATETIME,
    NewTimestamp DATETIME,
    OldParameterStateId CHAR(36),
    NewParameterStateId CHAR(36),
    DeviceId CHAR(36) NOT NULL,
    CONSTRAINT PK_OTChanges PRIMARY KEY(Id),
    CONSTRAINT FK_OTChanges_OTParameterStates_NewParameterStateId FOREIGN KEY(NewParameterStateId) REFERENCES OTParameterStates(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTChanges_OTParameterStates_OldParameterStateId FOREIGN KEY(OldParameterStateId) REFERENCES OTParameterStates(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTChanges_OTDevices_DeviceId FOREIGN KEY(DeviceId) REFERENCES OTDevices(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTChanges_Users_UserId FOREIGN KEY(UserId) REFERENCES Users(Id) ON DELETE CASCADE
);

CREATE TABLE OTRecords (
    Id CHAR(36) NOT NULL,
    StateId CHAR(36) NOT NULL,
    DeviceId CHAR(36) NOT NULL,
    CreatedTimeStamp DATETIME NOT NULL,
    CreatedUserId CHAR(36) NOT NULL,
    TimeStamp DATETIME NOT NULL,
    CONSTRAINT PK_OTRecords PRIMARY KEY(Id),
    CONSTRAINT FK_OTRecords_OTParameterStates_StateId FOREIGN KEY(StateId) REFERENCES OTParameterStates(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTRecords_Users_CreatedUserId FOREIGN KEY(CreatedUserId) REFERENCES Users(Id) ON DELETE CASCADE,
    CONSTRAINT FK_OTRecords_OTDevices_DeviceId FOREIGN KEY(DeviceId) REFERENCES OTDevices(Id) ON DELETE CASCADE
);

CREATE TABLE UserRoles (
    UserId CHAR(36) NOT NULL,
    RoleId CHAR(36) NOT NULL,
    CONSTRAINT PK_UserRoles PRIMARY KEY(UserId,RoleId),
    CONSTRAINT FK_UserRoles_Users_UserId FOREIGN KEY(UserId) REFERENCES Users(Id) ON DELETE CASCADE,
    CONSTRAINT FK_UserRoles_Roles_RoleId FOREIGN KEY(RoleId) REFERENCES Roles(Id) ON DELETE CASCADE
);

CREATE INDEX IX_CimAttributes_DataTypeId ON CimAttributes (
    DataTypeId
);

CREATE INDEX IX_CimLinks_CapacityId ON CimLinks (
    CapacityId
);

CREATE INDEX IX_CimLinks_TypeId ON CimLinks (
    TypeId
);

CREATE INDEX IX_Reports_ReportTemplateId ON Reports (
    ReportTemplateId
);

CREATE UNIQUE INDEX IX_Reports_ReportTemplateId_StartDate_EndDate ON Reports (
    ReportTemplateId,
    StartDate,
    EndDate,
    PredefinedValuesHashCode
);

CREATE UNIQUE INDEX IX_Reports_ReportTemplateUniqueGuid_StartDate_EndDate ON Reports (
    ReportTemplateUniqueGuid,
    StartDate,
    EndDate,
    PredefinedValuesHashCode
);

CREATE INDEX IX_UserRoles_RoleId ON UserRoles (
    RoleId
);

CREATE INDEX IX_UserRoles_UserId ON UserRoles (
    UserId
);

CREATE INDEX IX_OTAlgorithmConstantCrosses_AlgorithmConstantId ON OTAlgorithmConstantCrosses (
    AlgorithmConstantId
);

CREATE INDEX IX_OTAlgorithmConstantCrosses_DeviceId ON OTAlgorithmConstantCrosses (
    DeviceId
);

CREATE INDEX IX_OTAlgorithmConstants_ParameterId ON OTAlgorithmConstants (
    ParameterId
);

CREATE INDEX IX_OTAlgorithmParameterCrosses_AlgorithmParameterId ON OTAlgorithmParameterCrosses (
    AlgorithmParameterId
);

CREATE INDEX IX_OTAlgorithmParameterCrosses_DeviceId ON OTAlgorithmParameterCrosses (
    DeviceId
);

CREATE INDEX IX_OTAlgorithmParameters_ParameterId ON OTAlgorithmParameters (
    ParameterId
);

CREATE INDEX IX_OTChanges_DeviceId ON OTChanges (
    DeviceId
);

CREATE INDEX IX_OTChanges_NewParameterStateId ON OTChanges (
    NewParameterStateId
);

CREATE INDEX IX_OTChanges_OldParameterStateId ON OTChanges (
    OldParameterStateId
);

CREATE INDEX IX_OTChanges_UserId ON OTChanges (
    UserId
);

CREATE INDEX IX_OTDevices_ParameterId ON OTDevices (
    ParameterId
);

CREATE UNIQUE INDEX IX_OTParameters_Name ON OTParameters (
    Name
);

CREATE INDEX IX_OTParameterStates_ParameterId ON OTParameterStates (
    ParameterId
);

CREATE INDEX IX_OTRecords_CreatedUserId ON OTRecords (
    CreatedUserId
);

CREATE UNIQUE INDEX IX_OTRecords_DeviceId_TimeStamp ON OTRecords (
    DeviceId,
    TimeStamp
);

CREATE INDEX IX_OTRecords_StateId ON OTRecords (
    StateId
);

CREATE INDEX IX_MailAttachments_MailId ON MailAttachments (
    MailId
);

CREATE INDEX IX_SFFormOperations_SwitchoverFormId ON SFFormOperations (
    SwitchoverFormId
);

CREATE INDEX IX_SFFormConditions_SwitchoverFormId ON SFFormConditions (
    SwitchoverFormId
);

CREATE INDEX IX_SFFormOperationCommands_SwitchoverFormOperationId ON SFFormOperationCommands (
    SwitchoverFormOperationId
);

CREATE INDEX IX_SFFormConditionCommands_SwitchoverFormConditionId ON SFFormConditionCommands (
    SwitchoverFormConditionId
);

CREATE INDEX IX_SFTemplates_ParentTemplateId ON SFTemplates (
    ParentTemplateId
);

CREATE INDEX IX_SFTemplateOperation_SwitchoverFormTemplateId ON SFTemplateOperation (
    SwitchoverFormTemplateId
);

CREATE INDEX IX_SFTemplateOperation_SwitchoverFormCommonOperationId ON SFTemplateOperation (
    SwitchoverFormCommonOperationId
);

CREATE INDEX IX_SFTemplateCondition_SwitchoverFormTemplateId ON SFTemplateCondition (
    SwitchoverFormTemplateId
);

CREATE INDEX IX_SFTemplateCondition_SwitchoverFormCommonConditionId ON SFTemplateCondition (
    SwitchoverFormCommonConditionId
);

CREATE INDEX IX_SFOperationCommands_SwitchoverFormCommonOperationId ON SFOperationCommands (
    SwitchoverFormCommonOperationId
);

CREATE INDEX IX_SFConditionCommands_SwitchoverFormCommonConditionId ON SFConditionCommands (
    SwitchoverFormCommonConditionId
);

CREATE INDEX IX_SFFormAlarms_SwitchoverFormId ON SFFormAlarms (
    SwitchoverFormId
);

CREATE INDEX IX_SFFormAlarmCommands_SwitchoverFormAlarmId ON SFFormAlarmCommands (
    SwitchoverFormAlarmId
);

CREATE INDEX IX_SFFormCommonAlarmCommands_SwitchoverFormCommonAlarmId ON SFFormCommonAlarmCommands (
    SwitchoverFormCommonAlarmId
);

CREATE INDEX IX_CimDictionaryProfiles_CimDictionaryProfileSetId ON CimDictionaryProfiles (
    CimDictionaryProfileSetId
);

CREATE INDEX IX_WinCCOATreeElements_ParentId ON WinCCOATreeElements (
    ParentId
);

CREATE INDEX IX_SFTemplateAttachments_SwitchoverFormTemplateId ON SFTemplateAttachments (
    SwitchoverFormTemplateId
);