var PermissionMissingInterceptor = (function () {
    function PermissionMissingInterceptor($rootScope, $injector, $q) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.$injector = $injector;
        this.$q = $q;
        this.responseError = function (response) {
            if (response.status !== 403) {
                return _this.$q.reject(response);
            }
            var forbiddenReason = response.data[dto.reasonProblemResponseFieldName];
            if (!forbiddenReason || forbiddenReason !== dto.permissionMissingReason) {
                return _this.$q.reject(response);
            }
            if (!_this.$rootScope.isAccessDeniedModalOpened) {
                _this.$rootScope.isAccessDeniedModalOpened = true;
                var modal = _this.$injector.get('$modal');
                modal.open({
                    templateUrl: 'ng1/dist/src/ErrorPages/AccessDenied/AccessDeniedView.html',
                    controller: 'accessDeniedViewCtrl',
                    windowClass: 'full-screen-diagnostic-modal',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        message: function () { return response.data.detail; }
                    },
                })
                    .result.finally(function () {
                    _this.$rootScope.isAccessDeniedModalOpened = false;
                });
            }
            return _this.$q.reject(response);
        };
    }
    PermissionMissingInterceptor.Factory = function ($rootScope, $injector, $q) {
        return new PermissionMissingInterceptor($rootScope, $injector, $q);
    };
    PermissionMissingInterceptor.$inject = ['$rootScope', '$injector', '$q'];
    return PermissionMissingInterceptor;
}());
