angular
    .module('smsValidatorService', [])
    .service('validSvc', function ($q) {
    this.shouldBeNotEmpty = function (obj) {
        var d = $q.defer();
        var errorMsg = obj.getTitle != null
            ? 'Поле "' + obj.getTitle(obj.col) + '" не должно быть пустым'
            : 'Поле не должно быть пустым';
        if (obj.value instanceof Array) {
            if (obj.value == undefined || !_.some(obj.value)) {
                d.reject(errorMsg);
            }
            else {
                d.resolve(obj);
            }
        }
        else if (typeof obj.value === 'string') {
            if (obj.value != null && obj.value.length === 0) {
                d.reject(errorMsg);
            }
            else {
                d.resolve(obj);
            }
        }
        else {
            if (obj.value == undefined) {
                d.reject(errorMsg);
            }
            else {
                d.resolve(obj);
            }
        }
        return d.promise;
    };
    this.shouldBeUnique = function (obj) {
        var d = $q.defer();
        for (var i = 0; i < obj.values.length; i++) {
            if (i != obj.row && obj.values[i] == obj.value) {
                if (obj.getTitle != null) {
                    d.reject('Поле "' + obj.getTitle(obj.col) + '" должно быть уникальным');
                }
                else {
                    d.reject('Поле должно быть уникальным');
                }
                return d.promise;
            }
        }
        d.resolve(obj);
        return d.promise;
    };
    this.shouldContainOnlyLatinCharactersAndNumber = function (obj) {
        var d = $q.defer();
        var pattern = /^[.a-z.A-Z.0-9]+$/;
        if (!pattern.exec(obj.value)) {
            if (obj.getTitle != null) {
                d.reject('Поле "' + obj.getTitle(obj.col) + '" может состоять только из латинских символов и цифр');
            }
            else {
                d.reject('Поле может состоять только из латинских символов и цифр');
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldContainOnlyCharactersAndNumber = function (obj) {
        var d = $q.defer();
        var pattern = /^[.а-я.А-Я.a-z.A-Z.0-9]+$/;
        if (!pattern.exec(obj.value)) {
            if (obj.getTitle != null) {
                d.reject('Поле "' + obj.getTitle(obj.col) + '" может состоять только из символов и цифр');
            }
            else {
                d.reject('Поле может состоять только из символов и цифр');
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldContainOnlyNumber = function (obj) {
        var d = $q.defer();
        var pattern = /^[.0-9]+$/;
        if (!pattern.exec(obj.value)) {
            if (obj.getTitle != null) {
                d.reject('Поле "' + obj.getTitle(obj.col) + '" может состоять только из цифр');
            }
            else {
                d.reject('Поле может состоять только из цифр');
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldBeNotLongerMaxLength = function (obj) {
        var d = $q.defer();
        if (obj.value != null &&
            (obj.maxLength != undefined || obj.maxLength != null) &&
            obj.value.length > obj.maxLength) {
            if (obj.getTitle != null) {
                d.reject('Поле "' + obj.getTitle(obj.col) + '" не должно быть длиннее ' + obj.maxLength + ' символов');
            }
            else {
                d.reject('Поле не должно быть длиннее ' + obj.maxLength + ' символов');
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldBeNotLongerMaxValue = function (obj) {
        var d = $q.defer();
        if (obj.value != null && (obj.maxValue != undefined || obj.maxValue != null) && obj.value > obj.maxValue) {
            if (obj.getTitle != null) {
                d.reject('Поле "' + obj.getTitle(obj.col) + '" должно иметь значение не превышающее ' + obj.maxValue);
            }
            else {
                d.reject('Поле должно иметь значение не превышающее ' + obj.maxValue);
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldBeNotLongerMaxLengthAfterPoint = function (obj) {
        var d = $q.defer();
        var pattern = /\.[0-9]+$/;
        if (pattern.exec(obj.value) != null &&
            pattern.exec(obj.value)[0].length > obj.maxLengthAfterPoint + 1) {
            if (obj.getTitle != null) {
                d.reject('Поле "' +
                    obj.getTitle(obj.col) +
                    '" должно иметь не более ' +
                    obj.maxLengthAfterPoint +
                    ' знаков после запятой');
            }
            else {
                d.reject('Поле должно иметь не более ' + obj.maxLengthAfterPoint + ' знаков после запятой');
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
    this.shouldContainOnlyIntegerNumberOrNull = function (obj) {
        var d = $q.defer();
        var pattern = /^[0-9]+$/;
        if (!pattern.exec(obj.value)) {
            if (obj.value.length != 0) {
                if (obj.getTitle != null) {
                    d.reject('Поле "' + obj.getTitle(obj.col) + '" может быть только целым числом, либо пустым');
                }
                else {
                    d.reject('Поле может быть только целым числом, либо пустым');
                }
            }
            else {
                d.resolve(obj);
            }
        }
        else {
            d.resolve(obj);
        }
        return d.promise;
    };
});
