var LanguageService = (function () {
    function LanguageService(translate, clientSettings) {
        this.translate = translate;
        var request = new XMLHttpRequest();
        request.open('GET', clientSettings.getServerInstance() + '/CoreConfiguration/GetLanguage', false);
        request.send();
        if (request.status === 200) {
            this.setLanguage(Number(request.response));
        }
        else {
            this.setLanguage(0);
        }
    }
    LanguageService.prototype.setLanguage = function (language) {
        var _this = this;
        this.language = language === 1 ? 'en' : 'ru';
        this.dictionary = this.translate.getTranslationTable(this.language);
        this.translate.use(this.language).catch(function () {
            _this.dictionary = null;
        });
    };
    LanguageService.prototype.getElementValue = function (key) {
        if (!this.dictionary) {
            return '';
        }
        return this.dictionary[key];
    };
    LanguageService.$inject = ['$translate', 'clientSettings'];
    return LanguageService;
}());
angular.module('kamhpp').service('language', LanguageService);
