app.directive('smsCustomContextMenu', [
    'authentication',
    'notificationService',
    function (authentication, notificationService) {
        var renderContextMenu = function ($scope, event, options, acceptedEvent) {
            var hasPermissions = _.some(options, function (item) {
                if (item === null)
                    return false;
                if (angular.isUndefined(item.permissions))
                    return true;
                return authentication.hasPermissions(item.permissions);
            });
            if (!hasPermissions)
                return;
            if (!$) {
                var $_1 = angular.element;
            }
            $(event.target).addClass('context');
            var $contextMenu = $('<div>');
            $contextMenu.addClass('dropdown clearfix');
            var $ul = $('<ul>');
            $ul.addClass('dropdown-menu');
            $ul.attr({ role: 'menu' });
            $ul.css({
                display: 'block',
                position: 'absolute',
                left: event.clientX + 'px',
                top: event.clientY + 'px',
            });
            angular.forEach(options, function (item, i) {
                var hasPermissionsForItem = item == null || angular.isUndefined(item.permissions) || authentication.hasPermissions(item.permissions);
                if (!hasPermissionsForItem)
                    return;
                var $li = $('<li style="cursor: pointer;">');
                if (item === null) {
                    $li.addClass('divider');
                }
                else {
                    var $a = $('<a>');
                    $a.attr({ tabindex: '-1' });
                    $a.text(item.name);
                    $li.append($a);
                    $li.on('click', function () {
                        $scope.$apply(function () {
                            item.action.call($scope, $scope);
                        });
                    });
                    if (item.disabled) {
                        $li.addClass('disabled');
                    }
                }
                $ul.append($li);
            });
            $contextMenu.append($ul);
            $contextMenu.css({
                width: '100%',
                height: '100%',
                position: 'fixed',
                top: 0,
                left: 0,
                zIndex: 9999,
            });
            $(document).find('body').append($contextMenu);
            $('html').click(function () {
                $(event.target).removeClass('context');
                $contextMenu.remove();
            });
            $contextMenu
                .on('click', function (e) {
                $(event.target).removeClass('context');
                $contextMenu.remove();
            })
                .on(acceptedEvent, function (event) {
                $(event.target).removeClass('context');
                event.preventDefault();
                $contextMenu.remove();
            });
        };
        return function ($scope, element, attrs) {
            element.on(attrs.smsCustomContextMenuAcceptedEvent, function (event) {
                $scope.$apply(function () {
                    event.preventDefault();
                    var enabled = $scope.$eval(attrs.smsCustomContextMenuEnabled);
                    if (enabled != false) {
                        var options = $scope.$eval(attrs.smsCustomContextMenu);
                        if (options instanceof Array) {
                            renderContextMenu($scope, event, options, attrs.smsCustomContextMenuAcceptedEvent);
                        }
                        else {
                            throw '"' + attrs.smsCustomContextMenu + '" not an array';
                        }
                    }
                    else {
                        var disableMessage = attrs.smsCustomContextMenuDisableMessage;
                        if (disableMessage != undefined) {
                            notificationService.warnMessage(disableMessage);
                        }
                    }
                });
            });
        };
    },
]);
