app.directive('smsCheckBasket', [
    '$rootScope',
    '$parse',
    '$compile',
    function ($rootScope, $parse, $compile) {
        function contains(items, item) {
            if (angular.isArray(items)) {
                for (var i = 0; i < items.length; i++) {
                    if (angular.equals(items[i], item)) {
                        return true;
                    }
                }
            }
            return false;
        }
        function add(items, item) {
            items = angular.isArray(items) ? items : [];
            for (var i = 0; i < items.length; i++) {
                if (angular.equals(items[i], item)) {
                    return items;
                }
            }
            items.push(item);
            return items;
        }
        function remove(items, item) {
            var newItems = [];
            if (angular.isArray(items)) {
                for (var i = 0; i < items.length; i++) {
                    if (!angular.equals(items[i], item)) {
                        newItems.push(items[i]);
                    }
                }
            }
            return newItems;
        }
        return {
            restrict: 'A',
            priority: 1000,
            terminal: true,
            scope: true,
            compile: function (element, attrs) {
                if (element[0].tagName !== 'INPUT' || !element.attr('type', 'checkbox') || !attrs.checkGroup) {
                    throw 'Тэг `sms-check-basket` должен применяться к `input[type="checkbox"]` и исполняется в паре с `check-group`.';
                }
                element.removeAttr('sms-check-basket');
                element.attr('ng-model', 'checked');
                return function ($scope, $element, $attrs) {
                    $compile($element)($scope);
                    var value = $parse($attrs.checkGroup)($scope.$parent);
                    var getFunc = $parse($attrs.smsCheckBasket);
                    var setFunc = getFunc.assign;
                    var deregistrationCheckedWatchFunc = null;
                    var registrationCheckedWatchFunc = function () {
                        deregistrationCheckedWatchFunc = $scope.$watch('checked', function (after, before) {
                            if (after === before) {
                                return;
                            }
                            var current = getFunc($scope.$parent);
                            if (after === true) {
                                setFunc($scope.$parent, add(current, value));
                            }
                            else {
                                setFunc($scope.$parent, remove(current, value));
                            }
                            $rootScope.$broadcast($attrs.smsCheckBasket + '.Changed', { after: current });
                        });
                    };
                    registrationCheckedWatchFunc();
                    $scope.$parent.$watch($attrs.smsCheckBasket, function (after) {
                        deregistrationCheckedWatchFunc();
                        $scope.checked = contains(after, value);
                        registrationCheckedWatchFunc();
                    }, true);
                };
            },
        };
    },
]);
