var ReportRecalcStatus;
(function (ReportRecalcStatus) {
    ReportRecalcStatus[ReportRecalcStatus["Ready"] = 1] = "Ready";
    ReportRecalcStatus[ReportRecalcStatus["Busy"] = 2] = "Busy";
    ReportRecalcStatus[ReportRecalcStatus["Done"] = 3] = "Done";
    ReportRecalcStatus[ReportRecalcStatus["Stopping"] = 4] = "Stopping";
})(ReportRecalcStatus || (ReportRecalcStatus = {}));
var ReportRecalcOptions = (function () {
    function ReportRecalcOptions() {
        this.keepChanges = true;
        this.toLastTemplateVersion = false;
        this.reloadValuesFromExternalSources = false;
        this.forPeriod = false;
        this.period = {
            start: new Date(),
            stop: new Date(),
            minDate: Date.getNow(),
        };
    }
    return ReportRecalcOptions;
}());
var ReportRecalcModalController = (function () {
    function ReportRecalcModalController($scope, $modalInstance, $q, $http, clientSettings, language, notificationService, report, reports, templateGuid) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.$q = $q;
        this.$http = $http;
        this.clientSettings = clientSettings;
        this.language = language;
        this.notificationService = notificationService;
        this.report = report;
        this.reports = reports;
        this.templateGuid = templateGuid;
        this.options = new ReportRecalcOptions();
        this.progress = 0;
        this.status = ReportRecalcStatus.Ready;
        this.result = [];
        this.done = function (result) {
            _this.status = ReportRecalcStatus.Done;
            _this.result = result;
            _this.close();
        };
        this.getTextForProgressBar = function () {
            return _this.status !== ReportRecalcStatus.Stopping
                ? _this.options.forPeriod
                    ? _this.progress.toString() + '%'
                    : _this.language.getElementValue('loadingHdr')
                : _this.language.getElementValue('reportStopingRecalcBtn');
        };
        $scope.ctrl = this;
    }
    ReportRecalcModalController.prototype.recalc = function (reports) {
        var _this = this;
        var deferred = this.$q.defer();
        var result = [];
        var stepsCount = reports.length;
        var takeStep = function (step) {
            if (_this.status === ReportRecalcStatus.Stopping) {
                _this.status = ReportRecalcStatus.Done;
                _this.progress = 0;
                _this.options.period.start = reports[step].timestamp;
                _this.options.period.stop = reports[reports.length - 1].endTimestamp;
                _this.result = result;
                return;
            }
            _this.$http
                .post(_this.clientSettings.getServerInstance() + '/Report/RecreateReport', {
                reportId: reports[step].id,
                keepChanges: _this.options.keepChanges,
                reloadValuesFromExternalSources: _this.options.reloadValuesFromExternalSources,
                toLastTemplateVersion: _this.options.toLastTemplateVersion,
                templateGuid: _this.templateGuid,
            }).then(function (arg) {
                result.push(new ReportOperationInfo.Result(reports[step], true, arg.data));
                var nextStep = step + 1;
                _this.progress = Math.round(nextStep / (stepsCount / 100));
                if (nextStep === stepsCount) {
                    deferred.resolve(result);
                    return;
                }
                takeStep(nextStep);
            }, function (error) {
                result.push(new ReportOperationInfo.Result(reports[step], false, error.data));
                deferred.reject(result);
                return;
            });
        };
        takeStep(0);
        return deferred.promise;
    };
    ReportRecalcModalController.prototype.ok = function () {
        var _this = this;
        if (this.options.period.start > this.options.period.stop) {
            this.notificationService.warnMessage(this.language.getElementValue('reportIncorrectSelectedIntervalMsg'));
            return;
        }
        if (this.options.period.start > this.options.period.minDate) {
            this.notificationService.warnMessage(this.language.getElementValue('reportIncorrectSelectedStartDateMsg'));
            return;
        }
        if (this.options.period.stop > this.options.period.minDate) {
            this.notificationService.warnMessage(this.language.getElementValue('reportIncorrectSelectedEndDateMsg'));
            return;
        }
        var recalculationReports = this.options.forPeriod
            ? _.select(this.reports, function (item) {
                return (item.timestamp >= _this.options.period.start && item.timestamp <= _this.options.period.stop);
            })
            : [this.report];
        if (!_.any(recalculationReports)) {
            this.done([]);
            this.notificationService.infoMessage(this.language.getElementValue('reportNoReportsFoundForSpecifiedIntervalMsg'));
            return;
        }
        this.status = ReportRecalcStatus.Busy;
        this.progress = this.options.forPeriod ? 0 : 100;
        this.recalc(recalculationReports).then(this.done, this.done);
    };
    ReportRecalcModalController.prototype.close = function () {
        this.$modalInstance.close(this.result);
    };
    ReportRecalcModalController.prototype.stop = function () {
        this.status = ReportRecalcStatus.Stopping;
    };
    ReportRecalcModalController.prototype.isRecalcDisabled = function () {
        return this.status === ReportRecalcStatus.Busy || this.status === ReportRecalcStatus.Stopping;
    };
    ReportRecalcModalController.$inject = [
        '$scope',
        '$modalInstance',
        '$q',
        '$http',
        'clientSettings',
        'language',
        'notificationService',
        'report',
        'reports',
        'templateGuid'
    ];
    return ReportRecalcModalController;
}());
app.controller('ReportRecalcModalController', ReportRecalcModalController);
