var ReportFormulaSelectModalCtrl = (function () {
    function ReportFormulaSelectModalCtrl($scope, $modalInstance, notificationService, language, reportFormulasProvider, resultTypes, currentFormulaName) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.resultTypes = resultTypes;
        this.sort = {
            columnName: 'sendingDate',
            descending: true
        };
        this.$scope.ctrl = this;
        reportFormulasProvider.getAll()
            .then(function (formulas) { return _this.formulas = _.isNull(currentFormulaName)
            ? formulas
            : _.filter(formulas, function (formula) { return formula.name !== currentFormulaName; }); }, function (error) { return notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), error); });
    }
    ReportFormulaSelectModalCtrl.prototype.selectFormula = function (formula) {
        this.selectedFormula = formula;
    };
    ReportFormulaSelectModalCtrl.prototype.getFormulaSignature = function (formula) {
        var _this = this;
        var parameters = _.map(formula.parameters, function (p) {
            var parameter = _.find(_this.resultTypes, function (t) { return t.ident == p.type; });
            return _.isDefined(parameter)
                ? "".concat(p.name, ": ").concat(parameter.name)
                : "".concat(p.name, ": ").concat(p.type);
        }).join(', ');
        var type = _.find(this.resultTypes, function (t) { return t.ident == formula.returnType; });
        var returnType = _.isDefined(type)
            ? type.name
            : formula.returnType;
        return "".concat(formula.name, "(").concat(parameters, "): ").concat(returnType);
    };
    ReportFormulaSelectModalCtrl.prototype.ok = function (formula) {
        this.$modalInstance.close(formula !== null && formula !== void 0 ? formula : this.selectedFormula);
    };
    ReportFormulaSelectModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    ReportFormulaSelectModalCtrl.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    ReportFormulaSelectModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'language',
        'notificationService',
        'reportFormulasProvider',
        'resultTypes',
        'currentFormulaName'
    ];
    return ReportFormulaSelectModalCtrl;
}());
angular.module('kamhpp').controller('reportFormulaSelectModalCtrl', ReportFormulaSelectModalCtrl);
