var ReportRule = (function () {
    function ReportRule(scope, language, reportTemplateProvider, notification, modal, owner, source, mailValidationService, userPreferencesService, printProvider) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.timeTrigger = null;
        this.parameterConditionTrigger = null;
        this.selfReportEventTrigger = null;
        this.anotherReportEventTrigger = null;
        this.creationAction = null;
        this.fileExportAction = null;
        this.lockAction = null;
        this.recalcAction = null;
        this.sendingEmailAction = null;
        this.printAction = null;
        this.deleteAction = null;
        this.watchFunctions = [];
        if (source) {
            this.timeTrigger = source.timeTrigger ? new TimeTrigger(source.timeTrigger) : null;
            this.parameterConditionTrigger = source.parameterConditionTrigger
                ? new ParameterConditionTrigger(scope, owner.Parameters, language, source.parameterConditionTrigger)
                : null;
            this.selfReportEventTrigger = source.selfReportEventTrigger
                ? new SelfReportEventTrigger(scope, language, source.selfReportEventTrigger)
                : null;
            this.anotherReportEventTrigger = source.anotherReportEventTrigger
                ? new AnotherReportEventTrigger(scope, language, reportTemplateProvider, notification, owner, source.anotherReportEventTrigger)
                : null;
            this.creationAction = source.creationAction
                ? new CreationAction(scope, owner, source.creationAction)
                : null;
            this.fileExportAction = source.fileExportAction
                ? new FileExportAction(scope, source.fileExportAction)
                : null;
            this.lockAction = source.lockAction
                ? new LockAction(scope, language, source.lockAction)
                : null;
            this.sendingEmailAction = source.sendingEmailAction
                ? new SendingEmailAction(scope, reportTemplateProvider, notification, language, modal, owner.UniqueGuid, source.sendingEmailAction, mailValidationService, userPreferencesService)
                : null;
            this.recalcAction = source.recalcAction
                ? new RecalcAction(0, source.recalcAction)
                : null;
            this.printAction = source.printAction
                ? new PrintAction(language, notification, printProvider, source.printAction)
                : null;
            this.deleteAction = source.deleteAction
                ? new DeleteAction(source.deleteAction.reportStoreDuration)
                : null;
            this.isEnabled = source.isEnabled;
            this.watchFunctions.push(scope.$watch(function () {
                return _this;
            }, function (after, before) {
                if (_.isUndefined(after) || ReportRule.isEqual(after, before)) {
                    return;
                }
                if (_this.action.type !== 5) {
                    return;
                }
                _this.trigger.state = 0;
            }, true));
        }
        else {
            this.timeTrigger = new TimeTrigger();
            this.parameterConditionTrigger = null;
            this.selfReportEventTrigger = null;
            this.anotherReportEventTrigger = null;
            this.creationAction = new CreationAction(scope, owner);
            this.fileExportAction = null;
            this.lockAction = null;
            this.recalcAction = null;
            this.sendingEmailAction = null;
            this.printAction = null;
            this.isEnabled = true;
        }
    }
    Object.defineProperty(ReportRule.prototype, "trigger", {
        get: function () {
            return (this.timeTrigger ||
                this.parameterConditionTrigger ||
                this.selfReportEventTrigger ||
                this.anotherReportEventTrigger);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ReportRule.prototype, "action", {
        get: function () {
            return (this.creationAction ||
                this.fileExportAction ||
                this.lockAction ||
                this.recalcAction ||
                this.sendingEmailAction ||
                this.printAction ||
                this.deleteAction);
        },
        enumerable: false,
        configurable: true
    });
    ReportRule.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (ParameterConditionTrigger.isEqual(obj.parameterConditionTrigger, other.parameterConditionTrigger) &&
            TimeTrigger.isEqual(obj.timeTrigger, other.timeTrigger) &&
            AnotherReportEventTrigger.isEqual(obj.anotherReportEventTrigger, other.anotherReportEventTrigger) &&
            SelfReportEventTrigger.isEqual(obj.selfReportEventTrigger, other.selfReportEventTrigger) &&
            SendingEmailAction.isEqual(obj.sendingEmailAction, other.sendingEmailAction) &&
            FileExportAction.isEqual(obj.fileExportAction, other.fileExportAction) &&
            LockAction.isEqual(obj.lockAction, other.lockAction) &&
            CreationAction.isEqual(obj.creationAction, other.creationAction) &&
            RecalcAction.isEqual(obj.recalcAction, other.recalcAction) &&
            PrintAction.isEqual(obj.printAction, other.printAction) &&
            DeleteAction.isEqual(obj.deleteAction, other.deleteAction) &&
            obj.isEnabled === other.isEnabled);
    };
    ReportRule.prototype.destroy = function () {
        this.watchFunctions.filter(function (func) { return !_.isUndefined(func); }).forEach(function (func) { return func(); });
    };
    return ReportRule;
}());
