var TemplateEditorConfiguration = (function () {
    function TemplateEditorConfiguration($rootScope, $modal, $http, $q, $compile, $timeout, clientSettings, language, templateParameterService) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.$modal = $modal;
        this.$http = $http;
        this.$q = $q;
        this.$compile = $compile;
        this.$timeout = $timeout;
        this.clientSettings = clientSettings;
        this.language = language;
        this.templateParameterService = templateParameterService;
        this.parameterTimestamps = [
            { text: this.language.getElementValue('reportTimestampsStartDateHdr'), value: 0 },
            { text: this.language.getElementValue('reportTimestampsEndDateHdr'), value: 1 },
            { text: this.language.getElementValue('reportTimestampsStepStartHdr'), value: 2 },
            { text: this.language.getElementValue('reportTimestampsStepEndHdr'), value: 3 },
        ];
        this.timestampIdents = [
            'ts',
            'step_start',
            'step_end',
            'date',
            'creation_date',
            'report_start',
            'report_stop',
            'update_date',
            'start',
            'end'
        ];
        this.commands = [];
        this.buttons = [];
        this.contextCommandGroups = [];
        this.tristateButtons = [];
        this.reportRowClassName = 'report-row';
        this.reportColumnClassName = 'report-column';
        this.minColumnWidth = 3;
        this.highlightCommandState = CKEDITOR.TRISTATE_ON;
        this.showStructureCommandState = CKEDITOR.TRISTATE_ON;
        this.cursorListeners = [];
        this.startResizeListeners = [];
        var parameterCommand = {
            name: 'parameter',
            canUndo: true,
            execute: function (editor) {
                var _a;
                var element = (_a = _this.selectedElement) !== null && _a !== void 0 ? _a : _this.getSelectedElement(editor);
                var parameter = _this.getParameter(element, _this.template.Parameters);
                if (_.isDefined(parameter)) {
                    parameterEditCommand.execute(editor);
                }
                else {
                    parameterCreateCommand.execute(editor);
                }
            }
        };
        var parameterCreateCommand = {
            name: 'parameterCreate',
            canUndo: true,
            execute: function (editor) {
                _this.templateParameterService
                    .createParameter(_this.template)
                    .then(function (parameter) {
                    editor.insertHtml(_this.getReportParameterTag(parameter, _this.isHighlightEnabled(editor)));
                });
            }
        };
        var parameterInsertCommand = {
            name: 'parameterInsert',
            canUndo: true,
            execute: function (editor) {
                var modalInstance = _this.$modal.open({
                    templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterSelectModal.html',
                    controller: 'parameterSelectModalCtrl',
                    backdrop: 'static',
                    windowClass: 'app-modal-window parameter-select-modal-window',
                    resolve: {
                        parameters: function () {
                            return _this.template.Parameters;
                        }
                    }
                });
                modalInstance.result.then(function (parameter) {
                    editor.insertHtml(_this.getReportParameterTag(parameter, _this.isHighlightEnabled(editor)));
                });
            }
        };
        var parameterEditCommand = {
            name: 'parameterEdit',
            canUndo: true,
            execute: function (editor) {
                var _a;
                var element = (_a = _this.selectedElement) !== null && _a !== void 0 ? _a : _this.getSelectedElement(editor);
                var parameter = _this.getParameter(element, _this.template.Parameters);
                if (_.isUndefined(parameter)) {
                    return;
                }
                var oldIdent = parameter.Ident;
                var oldTimestamp = parameter.Timestamp;
                _this.templateParameterService.editParameter(_this.template, parameter).then(function (parameter) {
                    if (_.isUndefined(parameter) || (parameter.Ident === oldIdent && parameter.Timestamp === oldTimestamp)) {
                        return;
                    }
                    var html = editor.getData();
                    html = html.replace(new RegExp('%' + oldIdent.escapeRegExp() + '%', 'g'), '%' + parameter.Ident + '%');
                    _this.setData(editor, html);
                }, function () { });
            }
        };
        var parameterDeleteCommand = {
            name: 'parameterDelete',
            canUndo: true,
            execute: function (editor) {
                var _a;
                var element = (_a = _this.selectedElement) !== null && _a !== void 0 ? _a : _this.getSelectedElement(editor);
                var parameter = _this.getParameter(element, _this.template.Parameters);
                if (_.isUndefined(parameter)) {
                    return;
                }
                _this.templateParameterService.deleteParameter(_this.template, parameter).then(function () {
                    var html = editor.getData();
                    html = html.replace(new RegExp('%' + parameter.Ident.escapeRegExp() + '%', 'g'), '');
                    _this.setData(editor, html);
                });
            }
        };
        var timestampCreateCommand = {
            name: 'timestamp',
            canUndo: true,
            execute: function (editor) {
                timestampInsertCommand.execute(editor);
            }
        };
        var timestampInsertCommand = {
            name: 'timestampInsert',
            canUndo: true,
            execute: function (editor) {
                var createParameterPromise = _this.templateParameterService.createParameter(_this.template, 'specificDate');
                createParameterPromise.then(function (parameter) {
                    editor.insertHtml(_this.getReportParameterTag(parameter, _this.isHighlightEnabled(editor)));
                });
            }
        };
        var highlightCommand = {
            name: 'highlight',
            canUndo: false,
            readOnly: false,
            preserveState: true,
            state: this.highlightCommandState,
            execute: function (editor) {
                var _a, _b;
                var command = editor.getCommand('highlight');
                (_a = editor.undoManager) === null || _a === void 0 ? void 0 : _a.lock();
                if (command.state === CKEDITOR.TRISTATE_OFF) {
                    _this.addHighlight(editor);
                    command === null || command === void 0 ? void 0 : command.setState(CKEDITOR.TRISTATE_ON);
                    _this.highlightCommandState = CKEDITOR.TRISTATE_ON;
                }
                else {
                    _this.removeHighlight(editor);
                    command === null || command === void 0 ? void 0 : command.setState(CKEDITOR.TRISTATE_OFF);
                    _this.highlightCommandState = CKEDITOR.TRISTATE_OFF;
                }
                (_b = editor.undoManager) === null || _b === void 0 ? void 0 : _b.unlock();
            },
        };
        var showStructureCommand = {
            name: 'showStructure',
            readOnly: false,
            canUndo: false,
            preserveState: true,
            state: CKEDITOR.TRISTATE_ON,
            execute: function (editor) {
                var command = editor.getCommand('showStructure');
                var ckEditorBodyElement = editor.editable();
                if (command.state === CKEDITOR.TRISTATE_OFF) {
                    ckEditorBodyElement.addClass('cke_show_structure');
                    command.setState(CKEDITOR.TRISTATE_ON);
                    _this.showStructureCommandState = CKEDITOR.TRISTATE_ON;
                    _this.updateStructuralBlocksJsBehavior(editor);
                }
                else {
                    ckEditorBodyElement.removeClass('cke_show_structure');
                    command.setState(CKEDITOR.TRISTATE_OFF);
                    _this.showStructureCommandState = CKEDITOR.TRISTATE_OFF;
                    _this.removeResizableBehavior();
                }
            },
        };
        var addRowCommand = {
            name: 'addRow',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                _this.addRow(editor);
            }
        };
        var addColumnCommand = {
            name: 'addColumn',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                var element = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(element)) {
                    element = _this.getSelectedElement(editor);
                    if (_.isUndefined(element)) {
                        return;
                    }
                    var oldHtml = element.getHtml();
                    if (_.isUndefined(element.getParent())) {
                        return;
                    }
                    while (_.isUndefined(element.getParent().getAttribute('data-report-page'))) {
                        element = element.getParent();
                        if (_.isUndefined(element.getParent())) {
                            return;
                        }
                        oldHtml = element.getOuterHtml();
                    }
                    var wrapper = document.createElement('div');
                    wrapper.classList.add(_this.reportRowClassName);
                    wrapper.innerHTML = "<div class=\"".concat(_this.reportColumnClassName, "\" style=\"width: 100%\">").concat(oldHtml, "</div>");
                    element.$.replaceWith(wrapper);
                    _this.onSelectionChange(editor);
                }
                else {
                    var newWidth = _this.getWidthPercent(element.$) / 2;
                    element.setStyle('width', "".concat(newWidth, "%"));
                    var newElement = new CKEDITOR.dom.element('div');
                    newElement.addClass(_this.reportColumnClassName);
                    newElement.setHtml("&nbsp;");
                    newElement.setStyle('width', "".concat(newWidth, "%"));
                    newElement.insertAfter(element);
                    _this.selectElement(editor, newElement);
                }
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var deleteColumnCommand = {
            name: 'deleteColumn',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleColumn(editor)) {
                    return;
                }
                var element = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(element)) {
                    return;
                }
                var parent = element.getParent();
                var width = _this.getWidthPercent(element.$);
                var children = _.map(parent.$.children, function (child) { return child; });
                if (children.length === 1) {
                    _this.deleteSelectedRow(editor, parent);
                    return;
                }
                var closestElementIndex;
                for (var index = 0; index < children.length; index++) {
                    if (element.$ === children[index]) {
                        closestElementIndex = index === children.length - 1
                            ? index - 1
                            : index + 1;
                        break;
                    }
                }
                var closestElement = parent.getChild(closestElementIndex);
                var mergedContent = "".concat(element.getHtml()).concat(closestElement.getHtml());
                if (mergedContent.endsWith('<br><br>')) {
                    mergedContent = mergedContent.substring(0, mergedContent.length - 4);
                }
                closestElement.setHtml(_.isEmpty(mergedContent) ? '<br>' : mergedContent);
                element.remove();
                closestElement.setStyle("width", "".concat(_this.getWidthPercent(closestElement.$) + width, "%"));
                _this.selectElement(editor, closestElement);
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var deleteRowCommand = {
            name: 'deleteRow',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleRow(editor)) {
                    return;
                }
                var element = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(element)) {
                    return;
                }
                _this.deleteSelectedRow(editor, element.getParent());
            }
        };
        var swapLeftColumnCommand = {
            name: 'swapLeftColumn',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleColumn(editor)) {
                    return;
                }
                var column = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(column)) {
                    return;
                }
                var swapElement = column.getPrevious();
                if (_.isUndefined(swapElement)) {
                    return;
                }
                while (!swapElement.hasClass(_this.reportColumnClassName)) {
                    if (!swapElement.hasNext()) {
                        return;
                    }
                    swapElement = swapElement.getPrevious();
                }
                _this.swapColumns(editor, column, swapElement);
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var swapRightColumnCommand = {
            name: 'swapRightColumn',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleColumn(editor)) {
                    return;
                }
                var column = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(column)) {
                    return;
                }
                var swapElement = column.getNext();
                if (_.isUndefined(swapElement)) {
                    return;
                }
                while (!swapElement.hasClass(_this.reportColumnClassName)) {
                    if (!swapElement.hasNext()) {
                        return;
                    }
                    swapElement = swapElement.getNext();
                }
                _this.swapColumns(editor, column, swapElement);
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var swapUpRowCommand = {
            name: 'swapUpRow',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleRow(editor)) {
                    return;
                }
                var element = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(element)) {
                    return;
                }
                var row = element.getParent();
                var swapElement = row.getPrevious();
                if (_.isUndefined(swapElement)) {
                    return;
                }
                while (!swapElement.hasClass(_this.reportRowClassName)) {
                    if (!swapElement.hasPrevious()) {
                        return;
                    }
                    swapElement = swapElement.getPrevious();
                }
                _this.swapRows(editor, row, swapElement);
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var swapDownRowCommand = {
            name: 'swapDownRow',
            canUndo: true,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                if (_this.isSingleRow(editor)) {
                    return;
                }
                var element = _this.findSelectedColumnElement(editor);
                if (_.isUndefined(element)) {
                    return;
                }
                var row = element.getParent();
                var swapElement = row.getNext();
                if (_.isUndefined(swapElement)) {
                    return;
                }
                while (!swapElement.hasClass(_this.reportRowClassName)) {
                    if (!swapElement.hasNext()) {
                        return;
                    }
                    swapElement = swapElement.getNext();
                }
                _this.swapRows(editor, row, swapElement);
                _this.updateStructuralBlocksJsBehavior(editor);
            }
        };
        var rotateTextCommand = {
            name: 'rotateText',
            canUndo: true,
            execute: function (editor) {
                var selectedCell = editor.getSelection().getStartElement();
                var rotationValue = 0;
                if (selectedCell) {
                    var transformValue = selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.getStyle("transform");
                    if (transformValue) {
                        var match = transformValue.match(/rotate\(([^deg]+)deg\)/);
                        if (match && match[1]) {
                            rotationValue = parseFloat(match[1]);
                            if (rotationValue > 270) {
                                rotationValue = 0;
                            }
                            rotationValue += 90;
                        }
                    }
                    var styles = {
                        'writing-mode': 'vertical-rl',
                        '-webkit-writing-mode': 'vertical-rl',
                        '-ms-writing-mode': 'vertical-rl',
                        '-webkit-transform': "rotate(".concat(rotationValue, "deg)"),
                        '-moz-transform': "rotate(".concat(rotationValue, "deg)"),
                        '-o-transform': "rotate(".concat(rotationValue, "deg)")
                    };
                    selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.setStyles(styles);
                    if (rotationValue === 270) {
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('writing-mode');
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('-webkit-writing-mode');
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('-ms-writing-mode');
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('-webkit-transform');
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('-moz-transform');
                        selectedCell === null || selectedCell === void 0 ? void 0 : selectedCell.removeStyle('-o-transform');
                    }
                }
            }
        };
        var previewCommand = {
            name: 'previewCommand',
            readOnly: true,
            canUndo: false,
            preserveState: false,
            state: CKEDITOR.TRISTATE_OFF,
            execute: function (editor) {
                var previewButton = document.querySelector('.cke_button.cke_button__previewbtn');
                var command = editor.getCommand('preview');
                var highlightCommand = editor.getCommand('highlight');
                var sourceCommand = editor.getCommand('source');
                var showStructureCommand = editor.getCommand('showStructure');
                if (command.state === CKEDITOR.TRISTATE_OFF) {
                    _this.htmlBeforePreviewOpened = editor.getData();
                    _this.parameterHighlightBeforePreviewOpened = highlightCommand.state;
                    _this.showStructureBeforePreviewOpened = showStructureCommand.state;
                    _this.getPreview(_this.template, _this.htmlBeforePreviewOpened)
                        .then(function (previewHtml) {
                        editor.setReadOnly(true);
                        var reportHtml = '';
                        _this.$compile(previewHtml)(_this.$rootScope).each(function (idx, element) {
                            if (element.outerHTML) {
                                reportHtml += element.outerHTML;
                            }
                        });
                        _this.setData(editor, reportHtml, { ignoreChanges: true, callback: function () {
                                sourceCommand.disable();
                                showStructureCommand.disable();
                                highlightCommand.disable();
                                previewButton.classList.add('cke_button_on');
                                command === null || command === void 0 ? void 0 : command.setState(CKEDITOR.TRISTATE_ON);
                            } });
                    });
                }
                else {
                    editor.setReadOnly(false);
                    sourceCommand.enable();
                    showStructureCommand.enable();
                    highlightCommand.enable();
                    previewButton.classList.remove('cke_button_on');
                    command === null || command === void 0 ? void 0 : command.setState(CKEDITOR.TRISTATE_OFF);
                    _this.setData(editor, _this.htmlBeforePreviewOpened, { ignoreChanges: true, callback: function () {
                            if (_this.parameterHighlightBeforePreviewOpened === CKEDITOR.TRISTATE_ON) {
                                highlightCommand.exec();
                            }
                            if (_this.showStructureBeforePreviewOpened === CKEDITOR.TRISTATE_ON) {
                                showStructureCommand.exec();
                            }
                        } });
                }
            }
        };
        var timestampBtn = {
            name: 'timestampBtn',
            label: this.language.getElementValue('timeStampHdr'),
            command: timestampCreateCommand
        };
        var highlightBtn = {
            name: 'highlightBtn',
            label: this.language.getElementValue('backlightHdr'),
            command: highlightCommand,
        };
        var showStructureBtn = {
            name: 'showStructureBtn',
            label: this.language.getElementValue('reportShowMarkupStructureHnt'),
            command: showStructureCommand,
        };
        var addColumnBtn = {
            name: 'addColumnBtn',
            label: this.language.getElementValue('reportAddColumnHnt'),
            command: addColumnCommand
        };
        var addRowBtn = {
            name: 'addRowBtn',
            label: this.language.getElementValue('reportAddRowHnt'),
            command: addRowCommand
        };
        var deleteColumnBtn = {
            name: 'deleteColumnBtn',
            label: this.language.getElementValue('reportDeleteColumnHnt'),
            command: deleteColumnCommand
        };
        var deleteRowBtn = {
            name: 'deleteRowBtn',
            label: this.language.getElementValue('reportDeleteRowHnt'),
            command: deleteRowCommand
        };
        var swapLeftColumnBtn = {
            name: 'swapLeftColumnBtn',
            label: this.language.getElementValue('reportSwapColumnLeftHnt'),
            command: swapLeftColumnCommand
        };
        var swapRightColumnBtn = {
            name: 'swapRightColumnBtn',
            label: this.language.getElementValue('reportSwapColumnRightHnt'),
            command: swapRightColumnCommand
        };
        var swapUpRowBtn = {
            name: 'swapUpRowBtn',
            label: this.language.getElementValue('reportSwapRowUpHnt'),
            command: swapUpRowCommand
        };
        var swapDownRowBtn = {
            name: 'swapDownRowBtn',
            label: this.language.getElementValue('reportSwapRowDownHnt'),
            command: swapDownRowCommand
        };
        var rotateTextBtn = {
            name: 'rotateText',
            label: this.language.getElementValue('rotateText'),
            command: rotateTextCommand,
        };
        var previewBtn = {
            name: 'previewBtn',
            label: this.language.getElementValue('reportPreviewBtnHdr'),
            command: previewCommand,
        };
        var parameterCreateMenuItem = {
            label: this.language.getElementValue('createBtn'),
            order: 1,
            command: parameterCreateCommand
        };
        var parameterInsertMenuItem = {
            label: this.language.getElementValue('insertBtn'),
            order: 2,
            command: parameterInsertCommand
        };
        var parameterEditMenuItem = {
            label: this.language.getElementValue('editBtn'),
            order: 3,
            command: parameterEditCommand
        };
        var parameterDeleteMenuItem = {
            label: this.language.getElementValue('deleteBtn'),
            order: 4,
            command: parameterDeleteCommand
        };
        var parameterMenuGroup = {
            label: this.language.getElementValue('parameterHdr'),
            order: 10,
            name: 'parameterGroup',
            menuItems: [
                parameterCreateMenuItem,
                parameterInsertMenuItem,
                parameterEditMenuItem,
                parameterDeleteMenuItem
            ],
            getItems: function (editor) {
                var element = editor
                    .getSelection()
                    .getStartElement();
                var isParameter = _this.isParameter(element, _this.template.Parameters);
                return {
                    parameterCreate: isParameter
                        ? CKEDITOR.TRISTATE_DISABLED
                        : CKEDITOR.TRISTATE_OFF,
                    parameterInsert: isParameter
                        ? CKEDITOR.TRISTATE_DISABLED
                        : CKEDITOR.TRISTATE_OFF,
                    parameterEdit: isParameter
                        ? CKEDITOR.TRISTATE_OFF
                        : CKEDITOR.TRISTATE_DISABLED,
                    parameterDelete: isParameter
                        ? CKEDITOR.TRISTATE_OFF
                        : CKEDITOR.TRISTATE_DISABLED,
                };
            },
            listener: function () {
                return {
                    parameterGroup: CKEDITOR.TRISTATE_OFF
                };
            },
        };
        this.commands = [
            parameterCommand,
            parameterCreateCommand,
            parameterDeleteCommand,
            parameterEditCommand,
            parameterInsertCommand,
            timestampCreateCommand,
            highlightCommand,
            showStructureCommand,
            addColumnCommand,
            addRowCommand,
            deleteColumnCommand,
            deleteRowCommand,
            swapLeftColumnCommand,
            swapRightColumnCommand,
            swapUpRowCommand,
            swapDownRowCommand,
        ];
        this.contextCommandGroups = [
            parameterMenuGroup,
        ];
        this.buttons = [
            timestampBtn,
            showStructureBtn,
            addColumnBtn,
            addRowBtn,
            deleteColumnBtn,
            deleteRowBtn,
            swapLeftColumnBtn,
            swapRightColumnBtn,
            swapUpRowBtn,
            swapDownRowBtn,
            highlightBtn,
            rotateTextBtn,
            previewBtn,
        ];
        this.toolbar = [
            { name: 'styles', items: ['Format', 'Font', 'FontSize'] },
            { name: 'colors', items: ['TextColor', 'BGColor'] },
            { name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'Undo', 'Redo'] },
            {
                name: 'insert',
                items: [
                    'Table',
                    'HorizontalRule',
                    'base64image',
                ]
            },
            {
                name: 'custom',
                items: [
                    timestampBtn.name,
                    highlightBtn.name
                ]
            },
            {
                name: 'basicstyles',
                items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', 'RemoveFormat', 'Link', 'Unlink', 'CopyFormatting', rotateTextBtn.name]
            },
            {
                name: 'paragraph',
                items: [
                    'NumberedList',
                    'BulletedList',
                    '-',
                    'Outdent',
                    'Indent',
                    '-',
                    '-',
                    'JustifyLeft',
                    'JustifyCenter',
                    'JustifyRight',
                    'JustifyBlock',
                ]
            },
            {
                name: 'structure',
                items: [showStructureBtn.name]
            },
            {
                name: 'blocks',
                items: [
                    addRowBtn.name,
                    addColumnBtn.name,
                    deleteRowBtn.name,
                    deleteColumnBtn.name,
                    swapLeftColumnBtn.name,
                    swapRightColumnBtn.name,
                    swapUpRowBtn.name,
                    swapDownRowBtn.name,
                ]
            },
            {
                name: 'document',
                items: [previewBtn.name, 'Source', 'Maximize']
            },
        ];
        this.tristateButtons = [
            showStructureBtn.name.toLowerCase(),
            highlightBtn.name.toLowerCase(),
        ];
    }
    TemplateEditorConfiguration.prototype.isPreview = function (editor) {
        var _a;
        return ((_a = editor === null || editor === void 0 ? void 0 : editor.getCommand('preview')) === null || _a === void 0 ? void 0 : _a.state) === CKEDITOR.TRISTATE_ON;
    };
    ;
    TemplateEditorConfiguration.prototype.getReportParameterTag = function (parameter, hasHighlight) {
        var _a;
        if (!parameter.Compilable) {
            return "%".concat(parameter.Ident, "%");
        }
        var parameterTimestamp = (_a = _.find(this.parameterTimestamps, function (parameterTimestamp) { return parameterTimestamp.value === parameter.Timestamp; })) !== null && _a !== void 0 ? _a : this.parameterTimestamps[0];
        return hasHighlight
            ? "<span data-parameter=\"\" title=\"".concat(this.language.getElementValue('timeStampHdr'), ": ").concat(parameterTimestamp.text, "\" contenteditable=\"false\" class=\"parameter-highlight\">%").concat(parameter.Ident, "%</span>")
            : "<span data-parameter=\"\" title=\"".concat(this.language.getElementValue('timeStampHdr'), ": ").concat(parameterTimestamp.text, "\">%").concat(parameter.Ident, "%</span>");
    };
    TemplateEditorConfiguration.prototype.wrapParameters = function (html, isHighlightEnabled) {
        var _this = this;
        if (isHighlightEnabled === void 0) { isHighlightEnabled = true; }
        var result = "".concat(html);
        _.forEach(this.template.Parameters, function (parameter) {
            result = result.replace(new RegExp("%".concat(parameter.Ident.escapeRegExp(), "%"), 'g'), _this.getReportParameterTag(parameter, isHighlightEnabled));
        });
        return result;
    };
    TemplateEditorConfiguration.prototype.unwrapParameters = function (html) {
        var $html = $('<div />', { html: html });
        $html.find('*[data-parameter=""]').contents().unwrap();
        $html.find('*[data-timestamp=""]').contents().unwrap();
        return $html.html();
    };
    TemplateEditorConfiguration.prototype.onSelectionChange = function (editor) {
        var toggleCommandState = function (commandNames, needDisable) {
            _.forEach(commandNames, function (commandName) {
                var command = editor.getCommand(commandName);
                needDisable ? command.disable() : command.enable();
            });
        };
        toggleCommandState(['deleteRow', 'swapUpRow', 'swapDownRow'], this.isSingleRow(editor));
        toggleCommandState(['deleteColumn', 'swapLeftColumn', 'swapRightColumn'], this.isSingleColumn(editor));
    };
    TemplateEditorConfiguration.prototype.updateStructuralBlocksJsBehavior = function (editor) {
        var _this = this;
        this.removeResizableBehavior();
        var rows = _.map(editor.editable().$.querySelectorAll(".".concat(this.reportRowClassName)), function (row) { return row; });
        _.forEach(rows, function (row) {
            var blocks = _.map(row.querySelectorAll(".".concat(_this.reportColumnClassName)), function (block) { return block; });
            for (var i = 0; i < blocks.length - 1; i++) {
                _this.addResizableBehavior(editor, blocks[i], _.rest(blocks, i + 1));
            }
        });
    };
    TemplateEditorConfiguration.prototype.updateHighlightMode = function (editor) {
        var command = editor.getCommand('highlight');
        var button = document.querySelector('.cke_button.cke_button__highlightbtn');
        if (this.isPreview(editor)) {
            command.disable();
            return;
        }
        if (command.state === CKEDITOR.TRISTATE_ON) {
            this.addHighlight(editor);
            button.classList.add('cke_button_on');
            command.setState(CKEDITOR.TRISTATE_ON);
        }
        else {
            this.removeHighlight(editor);
            button.classList.remove('cke_button_on');
            command.setState(CKEDITOR.TRISTATE_OFF);
        }
    };
    TemplateEditorConfiguration.prototype.updateShowStructureMode = function (editor) {
        var showStructureCommand = editor.getCommand('showStructure');
        var showStructureButton = document.querySelector('.cke_button.cke_button__showstructurebtn');
        if (this.isPreview(editor)) {
            showStructureCommand.disable();
            return;
        }
        var ckEditorBodyElement = editor.editable();
        if (showStructureCommand.state === CKEDITOR.TRISTATE_ON) {
            ckEditorBodyElement.addClass('cke_show_structure');
            showStructureButton.classList.add('cke_button_on');
            showStructureCommand.setState(CKEDITOR.TRISTATE_ON);
        }
        else {
            ckEditorBodyElement.removeClass('cke_show_structure');
            showStructureButton.classList.remove('cke_button_on');
            showStructureCommand.setState(CKEDITOR.TRISTATE_OFF);
        }
    };
    TemplateEditorConfiguration.prototype.beforeCommandExec = function (editor, event) {
        var commandName = event.data.name;
        if (commandName === 'tableDelete') {
            var selection = editor.getSelection();
            var selectedElement = selection === null || selection === void 0 ? void 0 : selection.getStartElement();
            if (_.isUndefined(selectedElement)) {
                return;
            }
            var tableElement = selectedElement.getName() !== 'table'
                ? selectedElement.getAscendant('table', true)
                : selectedElement;
            if (_.isUndefined(tableElement)) {
                return;
            }
            var bookmarks = selection.createBookmarks(true);
            var parentTableElement = new CKEDITOR.dom.element('span', editor.document);
            parentTableElement.insertBefore(tableElement);
            selection.selectBookmarks(bookmarks);
        }
    };
    TemplateEditorConfiguration.prototype.addHighlight = function (editor) {
        var ckEditorBodyElement = editor.editable().$;
        ckEditorBodyElement.classList.add('cke_parameter_highlight');
        $(ckEditorBodyElement).find('*[data-parameter=""]')
            .attr('contenteditable', 'false');
        $(ckEditorBodyElement).find('*[data-timestamp=""]')
            .attr('contenteditable', 'false');
    };
    TemplateEditorConfiguration.prototype.removeHighlight = function (editor) {
        var ckEditorBodyElement = editor.editable().$;
        ckEditorBodyElement.classList.remove('cke_parameter_highlight');
        $(ckEditorBodyElement).find('*[data-parameter=""]')
            .attr('contenteditable', 'true');
        $(ckEditorBodyElement).find('*[data-timestamp=""]')
            .attr('contenteditable', 'true');
    };
    TemplateEditorConfiguration.prototype.getParameter = function (element, parameters) {
        if (_.isUndefined(element) || element.getName() !== 'span') {
            return;
        }
        var text = element.getText();
        if (_.isUndefined(text)) {
            return;
        }
        return _.find(parameters, function (parameter) { return text.startsWith("%".concat(parameter.Ident, "%")); });
    };
    TemplateEditorConfiguration.prototype.getTimestamp = function (element) {
        if (_.isUndefined(element) || element.getName() !== 'span') {
            return;
        }
        var text = element.getText();
        if (_.isUndefined(text)) {
            return;
        }
        return _.find(this.timestampIdents, function (timestamp) { return _.contains(text, timestamp); });
    };
    TemplateEditorConfiguration.prototype.isParameter = function (element, parameters) {
        return _.isDefined(this.getParameter(element, parameters));
    };
    TemplateEditorConfiguration.prototype.isHighlightEnabled = function (editor) {
        return editor.getCommand('highlight').state === CKEDITOR.TRISTATE_ON;
    };
    TemplateEditorConfiguration.prototype.getSelectedElement = function (editor) {
        var _a;
        return (_a = editor.getSelection()) === null || _a === void 0 ? void 0 : _a.getStartElement();
    };
    TemplateEditorConfiguration.prototype.selectElement = function (editor, element) {
        var range = editor.createRange();
        range.setStart(element, 0);
        range.setEnd(element.getFirst(), 0);
        editor.getSelection().selectRanges([range]);
    };
    TemplateEditorConfiguration.prototype.addResizableBehavior = function (editor, resizable, otherElementsToRight) {
        var _this = this;
        var ckeditorContainer = editor.editable().$;
        var cursorApproximation = 10;
        var setCursorStyle = function (event) {
            if (event.offsetX > resizable.offsetWidth - cursorApproximation) {
                resizable.style.cursor = 'ew-resize';
            }
            else {
                resizable.style.cursor = 'auto';
            }
        };
        var startResize = function (event) {
            var containerWidth = resizable.parentElement.offsetWidth;
            var otherElementsToRightInitialWidths = _.map(otherElementsToRight, function (element) { return _this.getWidthPercent(element); });
            if (event.offsetX > resizable.offsetWidth - cursorApproximation) {
                var startX_1 = event.clientX;
                var startWidth_1 = _this.getWidthPercent(resizable);
                var resizeElement_1 = function (event) {
                    var difference = ((event.clientX - startX_1) / containerWidth) * 100;
                    if (difference > 0) {
                        resizable.style.width = (startWidth_1 + difference) + '%';
                        for (var index = 0; index < otherElementsToRight.length; index++) {
                            if (difference < 0) {
                                break;
                            }
                            var element = otherElementsToRight[index];
                            var elementWidth = otherElementsToRightInitialWidths[index];
                            var newElementWidth = elementWidth - difference;
                            if (newElementWidth < _this.minColumnWidth) {
                                element.style.width = "".concat(_this.minColumnWidth, "%");
                                difference -= elementWidth - _this.minColumnWidth;
                                continue;
                            }
                            element.style.width = "".concat(newElementWidth, "%");
                            break;
                        }
                    }
                    else {
                        if (startWidth_1 + difference > _this.minColumnWidth) {
                            resizable.style.width = (startWidth_1 + difference) + '%';
                            otherElementsToRight[0].style.width = (otherElementsToRightInitialWidths[0] - difference) + '%';
                        }
                    }
                };
                ckeditorContainer.addEventListener('mousemove', resizeElement_1);
                ckeditorContainer.addEventListener('mouseup', function () {
                    ckeditorContainer.removeEventListener('mousemove', resizeElement_1);
                    _this.onChange(editor);
                    if (!_this.template.isChanged) {
                        _this.$rootScope.$apply(function () {
                            _this.template.isChanged = true;
                        });
                    }
                });
            }
        };
        resizable.addEventListener('mousedown', startResize);
        resizable.addEventListener('mousemove', setCursorStyle);
        this.startResizeListeners.push({ element: resizable, event: startResize });
        this.cursorListeners.push({ element: resizable, event: setCursorStyle });
    };
    TemplateEditorConfiguration.prototype.getWidthPercent = function (element) {
        var containerWidth = element.parentElement.offsetWidth;
        return (element.style.width.endsWith('%'))
            ? Number.parseFloat(element.style.width.substring(-1))
            : ((element.offsetWidth + element.offsetLeft) / containerWidth) * 100;
    };
    TemplateEditorConfiguration.prototype.removeResizableBehavior = function () {
        _.forEach(this.cursorListeners, function (listener) {
            if (listener.element.style.cursor === 'ew-resize') {
                listener.element.style.cursor = 'auto';
            }
            listener.element.removeEventListener('mousemove', listener.event);
        });
        _.forEach(this.startResizeListeners, function (listener) {
            listener.element.removeEventListener('mousedown', listener.event);
        });
    };
    TemplateEditorConfiguration.prototype.isSingleRow = function (editor) {
        var editable = editor.editable();
        var elements = editable.find(".".concat(this.reportRowClassName));
        if (_.isUndefined(elements)) {
            return true;
        }
        return elements.count() === 1;
    };
    TemplateEditorConfiguration.prototype.isSingleColumn = function (editor) {
        var column = this.findSelectedColumnElement(editor);
        if (_.isUndefined(column)) {
            return true;
        }
        var elements = column.getParent().find(".".concat(this.reportColumnClassName));
        return elements.count() === 1;
    };
    TemplateEditorConfiguration.prototype.findSelectedColumnElement = function (editor) {
        var element = this.getSelectedElement(editor);
        if (_.isUndefined(element)) {
            return;
        }
        while (!element.hasClass(this.reportColumnClassName)) {
            element = element.getParent();
            if (_.isUndefined(element)) {
                return;
            }
        }
        return element;
    };
    TemplateEditorConfiguration.prototype.swapColumns = function (editor, currentColumn, swapElement) {
        if (_.isUndefined(swapElement)) {
            return;
        }
        var currentHtml = currentColumn.getHtml();
        var swapHtml = swapElement.getHtml();
        var currentWidth = currentColumn.getStyle('width');
        var swapWidth = swapElement.getStyle('width');
        currentColumn.setHtml(swapHtml);
        swapElement.setHtml(currentHtml);
        if (currentWidth && !swapWidth) {
            swapElement.setStyle('width', currentWidth);
            currentColumn.removeStyle('width');
        }
        else if (!currentWidth && swapWidth) {
            currentColumn.setStyle('width', swapWidth);
            swapElement.removeStyle('width');
        }
        else {
            currentColumn.setStyle('width', swapWidth || '');
            swapElement.setStyle('width', currentWidth || '');
        }
        this.selectElement(editor, swapElement);
    };
    TemplateEditorConfiguration.prototype.swapRows = function (editor, currentRow, swapElement) {
        if (_.isUndefined(swapElement)) {
            return;
        }
        var currentHtml = currentRow.getHtml();
        var swapHtml = swapElement.getHtml();
        var currentHeight = currentRow.getStyle('height');
        var swapHeight = swapElement.getStyle('height');
        currentRow.setHtml(swapHtml);
        swapElement.setHtml(currentHtml);
        if (currentHeight && !swapHeight) {
            swapElement.setStyle('height', currentHeight);
            currentRow.removeStyle('height');
        }
        else if (!currentHeight && swapHeight) {
            currentRow.setStyle('height', swapHeight);
            swapElement.removeStyle('height');
        }
        else {
            currentRow.setStyle('height', swapHeight || '');
            swapElement.setStyle('height', currentHeight || '');
        }
        this.selectElement(editor, swapElement.getChild(0));
    };
    TemplateEditorConfiguration.prototype.deleteSelectedRow = function (editor, row) {
        var nextSelectedRow = row.getPrevious();
        row.remove();
        if (_.isDefined(nextSelectedRow)) {
            this.selectElement(editor, nextSelectedRow.getChild(0));
        }
        else {
            nextSelectedRow = row.getNext();
            if (_.isDefined(nextSelectedRow)) {
                this.selectElement(editor, nextSelectedRow.getChild(0));
            }
        }
        this.updateStructuralBlocksJsBehavior(editor);
    };
    TemplateEditorConfiguration.prototype.getPreview = function (template, currentPageHtml) {
        var deferred = this.$q.defer();
        this.$http
            .post(this.clientSettings.getServerInstance() + '/Report/GetReportPreview', {
            reportTemplate: template,
            currentPageHtml: currentPageHtml
        })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (error) {
            deferred.reject(error);
        });
        return deferred.promise;
    };
    TemplateEditorConfiguration.prototype.setData = function (editor, html, props) {
        var _this = this;
        var wasChangedBefore = this.template.isChanged;
        editor.setData(html, {
            callback: function () {
                if (editor.mode === "source") {
                    editor.setMode("wysiwyg", function () { return editor.setMode("source", function () {
                        _this.$timeout(function () {
                            if (_.isDefined(props === null || props === void 0 ? void 0 : props.callback)) {
                                props.callback();
                            }
                            if (props === null || props === void 0 ? void 0 : props.resetUndoManager) {
                                editor.undoManager.reset();
                                editor.undoManager.refreshState();
                            }
                            if (props === null || props === void 0 ? void 0 : props.ignoreChanges) {
                                _this.template.isChanged = wasChangedBefore;
                            }
                        }, 0);
                    }); });
                }
                else {
                    if (_.isDefined(props === null || props === void 0 ? void 0 : props.callback)) {
                        props.callback();
                    }
                    if (props === null || props === void 0 ? void 0 : props.resetUndoManager) {
                        editor.undoManager.reset();
                        editor.undoManager.refreshState();
                    }
                    if (props === null || props === void 0 ? void 0 : props.ignoreChanges) {
                        _this.template.isChanged = wasChangedBefore;
                    }
                }
                if (!_this.isPreview(editor)) {
                    editor.getCommand('highlight').setState(_this.highlightCommandState);
                    editor.getCommand('showStructure').setState(_this.showStructureCommandState);
                }
            },
            noSnapshot: props === null || props === void 0 ? void 0 : props.ignoreChanges
        });
    };
    TemplateEditorConfiguration.prototype.addRow = function (editor) {
        var element = this.findSelectedColumnElement(editor);
        var newElement = new CKEDITOR.dom.element('div');
        newElement.addClass(this.reportRowClassName);
        newElement.setHtml("<div class=\"".concat(this.reportColumnClassName, "\" style=\"width:100%\">&nbsp;</div>"));
        var parent;
        if (_.isDefined(element)) {
            parent = element.getParent().getParent();
            if (_.isDefined(parent)) {
                element.$.parentElement.after(newElement.$);
            }
            else {
                editor.editable().append(newElement);
            }
        }
        else {
            element = this.getSelectedElement(editor);
            if (element.$.tagName === 'BODY') {
                element.$.appendChild(newElement.$);
            }
            else {
                element.$.after(newElement.$);
            }
        }
        editor.undoManager.save();
        this.selectElement(editor, newElement.getChild(0));
        this.updateStructuralBlocksJsBehavior(editor);
    };
    TemplateEditorConfiguration.prototype.getPageModalInstance = function (reportPage) {
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ReportPageSettingsModal.html',
            controller: 'reportPageSettingsModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                reportPage: function () {
                    return reportPage;
                }
            }
        });
    };
    TemplateEditorConfiguration.prototype.getInsertTimestampModalInstance = function (template) {
        var SpecificDateParameter = new ReportParameter();
        SpecificDateParameter.setSource('specificDate', template.UniqueGuid, template.ReportType, template.HasStep, this.language);
        SpecificDateParameter.Ident = this.language.getElementValue('timeStampHdr');
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/ParameterEditModal.html',
            controller: 'ReportParameterEditModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                parameter: function () {
                    return SpecificDateParameter;
                },
                reportTemplate: function () {
                    return template;
                }
            }
        });
    };
    TemplateEditorConfiguration.$inject = ['$rootScope', '$modal', '$http', '$q', '$compile', '$timeout', 'clientSettings', 'language', 'templateParameterService'];
    return TemplateEditorConfiguration;
}());
angular.module('kamhpp').service('smsTemplateEditorConfiguration', TemplateEditorConfiguration);
