var QueryAlarmFields = (function () {
    function QueryAlarmFields() {
    }
    QueryAlarmFields.prototype.load = function (source) {
        this._timestamp = _.any(source, function (f) { return f === 0; });
        this._tag = _.any(source, function (f) { return f === 1; });
        this._value = _.any(source, function (f) { return f === 2; });
        this._message = _.any(source, function (f) { return f === 4; });
        this._class = _.any(source, function (f) { return f === 3; });
        this._direction = _.any(source, function (f) { return f === 5; });
        this._acknowledgeState = _.any(source, function (f) { return f === 6; });
        this._acknowledgeTime = _.any(source, function (f) { return f === 7; });
    };
    return QueryAlarmFields;
}());
var QueryAlarmsSettingsCtrl = (function () {
    function QueryAlarmsSettingsCtrl(parameter, editor, scope, language) {
        this.fields = new QueryAlarmFields();
        this.tagFilter = [];
        this.classFilter = [];
        var self = this;
        this.language = language;
        this.watchFunctions = [];
        this.watchFunctions.push(scope.$watch(function () {
            return self.fields;
        }, function (after, before) {
            if (after == undefined || after === before)
                return;
            var fields = [];
            if (self.fields._timestamp)
                fields.push(0);
            if (self.fields._tag)
                fields.push(1);
            if (self.fields._value)
                fields.push(2);
            if (self.fields._class)
                fields.push(3);
            if (self.fields._message)
                fields.push(4);
            if (self.fields._direction)
                fields.push(5);
            if (self.fields._acknowledgeState)
                fields.push(6);
            if (self.fields._acknowledgeTime)
                fields.push(7);
            self.parameter.WinccOa.queryAlarmsSettings.fields = fields;
            editor.setFormula(self.getFormula());
        }, true));
        this.watchFunctions.push(scope.$watch(function () {
            return self.tagFilter;
        }, function (after, before) {
            if (after == undefined || after === before)
                return;
            self.parameter.WinccOa.queryAlarmsSettings.tagFilter = _.map(self.tagFilter, function (t) { return t.name; });
            editor.setFormula(self.getFormula());
        }, true));
        this.watchFunctions.push(scope.$watch(function () {
            return self.classFilter;
        }, function (after, before) {
            if (after == undefined || after === before)
                return;
            self.parameter.WinccOa.queryAlarmsSettings.classFilter = _.map(self.classFilter, function (c) { return c.name; });
            editor.setFormula(self.getFormula());
        }, true));
        this.directionFilter = getVariantsContainer(scope, [
            new UiSelectItem(-1, this.language.getElementValue('winccQueryAlarmsDirectionFilterNone')),
            new UiSelectItem(1, this.language.getElementValue('winccQueryAlarmsDirectionFilterCame')),
            new UiSelectItem(0, this.language.getElementValue('winccQueryAlarmsDirectionFilterWent')),
        ], function (t) {
            return t.ident === -1;
        }, function (after, before) {
            if (after === before)
                return;
            self.parameter.WinccOa.queryAlarmsSettings.directionFilter = after.ident;
            editor.setFormula(self.getFormula());
        });
        this.parameter = parameter;
    }
    QueryAlarmsSettingsCtrl.prototype.addTagFilter = function () {
        this.tagFilter.push({ name: '' });
    };
    QueryAlarmsSettingsCtrl.prototype.addClassFilter = function () {
        this.classFilter.push({ name: '' });
    };
    QueryAlarmsSettingsCtrl.prototype.load = function (settings) {
        this.tagFilter = _.map(settings.tagFilter, function (t) {
            return { name: t };
        });
        this.classFilter = _.map(settings.classFilter, function (c) {
            return { name: c };
        });
        this.fields.load(settings.fields);
        this.directionFilter.selected = _.find(this.directionFilter, function (o) { return o.ident === settings.directionFilter; });
    };
    QueryAlarmsSettingsCtrl.prototype.getFormula = function () {
        var fields = _.map(this.parameter.WinccOa.queryAlarmsSettings.fields, function (f) {
            switch (f) {
                case 0:
                    return 'WinccOaAlarmField.Timestamp';
                case 1:
                    return 'WinccOaAlarmField.Tag';
                case 2:
                    return 'WinccOaAlarmField.Value';
                case 3:
                    return 'WinccOaAlarmField.Class';
                case 5:
                    return 'WinccOaAlarmField.Direction';
                case 6:
                    return 'WinccOaAlarmField.AcknowledgeState';
                case 7:
                    return 'WinccOaAlarmField.AcknowledgeTime';
                default:
                    return 'WinccOaAlarmField.Message';
            }
        }).join();
        var tagFilter = _.map(this.parameter.WinccOa.queryAlarmsSettings.tagFilter, function (t) {
            return '*' + t + '*';
        }).join();
        var classFilter = _.map(this.parameter.WinccOa.queryAlarmsSettings.classFilter, function (c) {
            return '"' + c + '"';
        }).join();
        var formula = String.Format('GetWinccoaAlarms(\n\t"{0}", \n\t{1}, \n\t{2}, \n\tnew[] { {3} }, \n\tnew string[] { {4} }, \n\t{5})', _.any(tagFilter) ? tagFilter : '*', this.parameter.WinccOa.startTimestamp, this.parameter.WinccOa.endTimestamp, fields, classFilter, this.directionFilter.selected.ident);
        return formula;
    };
    QueryAlarmsSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
    };
    return QueryAlarmsSettingsCtrl;
}());
