var ReportParameterWincc = (function () {
    function ReportParameterWincc(templateHasStep) {
        this.aggregationType = 0;
        this.startTimestamp = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endTimestamp = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
    }
    ReportParameterWincc.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterWincc();
        clone.connectionGuid = obj.connectionGuid;
        clone.tagName = obj.tagName;
        clone.aggregationType = obj.aggregationType;
        clone.startTimestamp = obj.startTimestamp;
        clone.endTimestamp = obj.endTimestamp;
        clone.dbNameParameterIdent = obj.dbNameParameterIdent;
        return clone;
    };
    ReportParameterWincc.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.tagName === other.tagName &&
            obj.aggregationType === other.aggregationType &&
            obj.startTimestamp === other.startTimestamp &&
            obj.endTimestamp === other.endTimestamp &&
            obj.dbNameParameterIdent === other.dbNameParameterIdent);
    };
    ReportParameterWincc.prototype.canEdited = function () {
        return true;
    };
    ReportParameterWincc.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterWincc.prototype.canBacklight = function () {
        return true;
    };
    ReportParameterWincc.prototype.canPredefined = function () {
        return false;
    };
    return ReportParameterWincc;
}());
