var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SelectPiramidaFunctionsItem = (function (_super) {
    __extends(SelectPiramidaFunctionsItem, _super);
    function SelectPiramidaFunctionsItem(ident, name, sourceFunction, returnType) {
        var _this = _super.call(this, ident, name, returnType) || this;
        _this.sourceFunction = sourceFunction;
        return _this;
    }
    return SelectPiramidaFunctionsItem;
}(SelectSourceFunctionsItem));
var PiramidaSettingsCtrl = (function () {
    function PiramidaSettingsCtrl(parentScope, language) {
        this.watchFunctions = [];
        this.connectionTypes = [0, 9];
        this.parentScope = parentScope;
        this.language = language;
    }
    PiramidaSettingsCtrl.prototype.updateUIComponentsVisibility = function (func) {
        switch (func.ident) {
            case 'discreteState':
                this.discreteGroupSelectorVisible = true;
                this.discreteSelectorVisible = true;
                this.parameterSelectorVisible = false;
                this.objectSelectorVisible = false;
                this.startPeriodSelectorVisible = true;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = false;
                this.objItemObjCodeFieldsVisible = false;
                break;
            case 'discreteStatesOnPeriod':
                this.discreteGroupSelectorVisible = true;
                this.discreteSelectorVisible = true;
                this.parameterSelectorVisible = false;
                this.objectSelectorVisible = false;
                this.startPeriodSelectorVisible = true;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = false;
                this.objItemObjCodeFieldsVisible = false;
                break;
            case 'discreteGroupState':
                this.discreteGroupSelectorVisible = true;
                this.discreteSelectorVisible = false;
                this.parameterSelectorVisible = false;
                this.objectSelectorVisible = false;
                this.startPeriodSelectorVisible = false;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = false;
                this.objItemObjCodeFieldsVisible = false;
                break;
            case 'discreteStateAtTimestamp':
                this.discreteGroupSelectorVisible = true;
                this.discreteSelectorVisible = true;
                this.parameterSelectorVisible = false;
                this.objectSelectorVisible = false;
                this.startPeriodSelectorVisible = false;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = true;
                this.objItemObjCodeFieldsVisible = false;
                break;
            case 'lastValue':
                this.discreteGroupSelectorVisible = false;
                this.discreteSelectorVisible = false;
                this.parameterSelectorVisible = false;
                this.objectSelectorVisible = true;
                this.startPeriodSelectorVisible = true;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = false;
                this.objItemObjCodeFieldsVisible = true;
                break;
            default:
                this.discreteGroupSelectorVisible = false;
                this.discreteSelectorVisible = false;
                this.parameterSelectorVisible = true;
                this.objectSelectorVisible = true;
                this.startPeriodSelectorVisible = true;
                this.endPeriodSelectorVisible = true;
                this.discreteDefaultValuesSelectorVisible = false;
                this.objItemObjCodeFieldsVisible = false;
                break;
        }
    };
    PiramidaSettingsCtrl.prototype.init = function () {
        var self = this;
        var afterChangeSimpleSetting = function (after, before) {
            if (after == undefined || after === before)
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        };
        this.setting = this.parentScope.param.Piramida;
        this.discreteSettings = new PiramidaDiscreteSettings(this.parentScope, this.language, this.setting.discreteSettings);
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectPiramidaFunctionsItem('lastValueOnPeriod', this.language.getElementValue('reportParameterPiramideGetLastValueOnPeriodHdr'), 'GetLastPiramidaValueOnPeriod', 'PiramidaValue'),
            new SelectPiramidaFunctionsItem('discreteState', this.language.getElementValue('reportParameterPiramideDiscreteStateHdr'), 'PiramidaQuery', 'PiramidaDiscretState'),
            new SelectPiramidaFunctionsItem('discreteGroupState', this.language.getElementValue('reportParameterPiramideDiscreteGroupStateHdr'), 'PiramidaQuery', 'PiramidaDiscretState[]'),
            new SelectPiramidaFunctionsItem('discreteStatesOnPeriod', this.language.getElementValue('reportParameterPiramideDiscreteStatesOnPeriodHdr'), 'GetPiramidaDiscreteStatesOnPeriod', 'PiramidaDiscretState[]'),
            new SelectPiramidaFunctionsItem('discreteStateAtTimestamp', this.language.getElementValue('reportParameterPiramideDiscreteStatesAtTimeHdr'), 'GetLastPiramidaDiscreteStateOnTime', 'PiramidaDiscretState'),
            new SelectPiramidaFunctionsItem('lastValue', this.language.getElementValue('reportParameterPiramideGetLastValueHdr'), 'GetLastPiramidaValue', 'PiramidaValue')
        ], function (t) {
            return t.ident === self.setting.func;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.setting.func = after.ident;
            self.updateUIComponentsVisibility(after);
            switch (after.ident) {
                case 'lastValueOnPeriod':
                case 'lastValue':
                    self.setting.discreteSettings = null;
                    break;
                case 'discreteState':
                case 'discreteGroupState':
                case 'discreteStatesOnPeriod':
                case 'discreteStateAtTimestamp':
                    self.setting.discreteSettings = self.discreteSettings;
                    break;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.parameters = getVariantsExtendableContainer(this.parentScope, [
            new UiSelectItem(2, this.language.getElementValue('reportParameterPiramidePowerInPrevious3MinutesHdr')),
            new UiSelectItem(4, this.language.getElementValue('reportParameterPiramidePowerInPrevious1MinuteHdr')),
            new UiSelectItem(5, this.language.getElementValue('reportParameterPiramidePowerInPrevious2MinutesHdr')),
            new UiSelectItem(6, this.language.getElementValue('reportParameterPiramidePowerInPrevious4MinutesHdr')),
            new UiSelectItem(7, this.language.getElementValue('reportParameterPiramidePowerInPrevious5MinutesHdr')),
            new UiSelectItem(8, this.language.getElementValue('reportParameterPiramidePowerInPrevious6MinutesHdr')),
            new UiSelectItem(9, this.language.getElementValue('reportParameterPiramidePowerInPrevious10MinutesHdr')),
            new UiSelectItem(11, this.language.getElementValue('reportParameterPiramidePowerInPrevious15MinutesHdr')),
            new UiSelectItem(13, this.language.getElementValue('reportParameterPiramideIntEnergyInPrevious30MinutesWithTransferHdr')),
            new UiSelectItem(17, this.language.getElementValue('reportParameterPiramideEnergyInCurrent1HourHdr')),
            new UiSelectItem(18, this.language.getElementValue('reportParameterPiramidePowerEnergyInPrevious1HourHdr')),
            new UiSelectItem(19, this.language.getElementValue('reportParameterPiramideIntEnergyInPrevious1HourHdr')),
            new UiSelectItem(16, this.language.getElementValue('reportParameterPiramideEnergyInPrevious30MinutesHdr')),
            new UiSelectItem(20, this.language.getElementValue('reportParameterPiramideMaxPowerInCurrentDayHdr')),
            new UiSelectItem(22, this.language.getElementValue('reportParameterPiramideMaxPowerInPreviousDayHdr')),
            new UiSelectItem(24, this.language.getElementValue('reportParameterPiramideEnergyInCurrentDayHdr')),
            new UiSelectItem(26, this.language.getElementValue('reportParameterPiramideEnergyInPreviousDayHdr')),
            new UiSelectItem(27, this.language.getElementValue('reportParameterPiramideIntEnergyInPreviousDayWithTransferHdr')),
            new UiSelectItem(12, this.language.getElementValue('reportParameterPiramidePowerInPrevious30MinutesHdr')),
            new UiSelectItem(14, this.language.getElementValue('reportParameterPiramideEnergyInCurrent30MinutesHdr')),
            new UiSelectItem(10, this.language.getElementValue('reportParameterPiramidePowerInCurrent30MinutesHdr')),
        ], function () {
            return self.setting.parameter;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.setting.parameter = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.setting.objectName;
        }, afterChangeSimpleSetting));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.discreteSettings;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            self.setting.discreteSettings = after;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.setting.startDate;
        }, function (after, before) {
            if (after === before)
                return;
            self.setting.startDate = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.setting.endDate;
        }, function (after, before) {
            if (after === before)
                return;
            self.setting.endDate = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.setting.connectionGuid;
        }, afterChangeSimpleSetting, true));
        this.updateUIComponentsVisibility(this.functions.selected);
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    PiramidaSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        this.parameters.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        if (!_.isNull(this.discreteSettings)) {
            this.discreteSettings.destroy();
        }
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
    };
    PiramidaSettingsCtrl.prototype.getFormula = function () {
        var discreteStateQueryStr = '"SELECT dis.discret_name as DISNAME, dis.discret_code as DISCODE, el.EVCODE, el.EVGENESISDT as timestamp " + \n' +
            '  "FROM EVENTLIST as el " + \n' +
            ' "INNER JOIN (SELECT el.OBJCODE, el.OBJITEM, MAX(el.EVGENESISDT) as timestamp " + \n' +
            '               "FROM EVENTLIST as el " + \n' +
            '              "WHERE el.OBJTYPE = 97 " + \n' +
            '		         "AND convert(varchar(8), el.EVGENESISDT, 108) != \'00:00:00\' " + \n' +
            '		         "AND el.EVGENESISDT <= \'" + {2}.ToString("yyyy-MM-dd HH:mm:ss") + "\' " + \n' +
            '              "GROUP BY el.OBJCODE, el.OBJITEM) as last_discret_events " + \n' +
            '    "ON el.OBJCODE = last_discret_events.OBJCODE " + \n' +
            '   "AND el.OBJITEM = last_discret_events.OBJITEM " + \n' +
            '   "AND el.EVGENESISDT = last_discret_events.timestamp " + \n' +
            '   "AND el.APPID IS NOT NULL " + \n' +
            ' "INNER JOIN (SELECT d.CODE as device_code, dis.Name as discret_name, dis.CODE as discret_code, dis.SUBDEVICEID as counting_object_code " + \n' +
            '			    "FROM DISCRETS as dis, " + \n' +
            '				     "DEVICES as d " + \n' +
            '              "WHERE d.NAME = \'{0}\' " + \n' +
            '                "AND dis.STATIONID = d.ID) as dis " + \n' +
            '    "ON el.OBJITEM = dis.discret_code " + \n' +
            '   "AND el.OBJCODE = dis.device_code " + \n' +
            '   "AND dis.discret_name = \'{1}\' "';
        switch (this.functions.selected.ident) {
            case 'discreteState':
                return String.Format('var query = \n' +
                    String.Format(discreteStateQueryStr, this.discreteSettings.discreteGroupName, this.discreteSettings.discreteName, this.setting.endDate) +
                    ';\n' +
                    'var result = {0}("{1}", query)\n' +
                    '    .Select(row => \n' +
                    '        new PiramidaDiscretState(\n' +
                    '            new PiramidaDiscret((int) row[1], (string) row[0]),\n' +
                    '            (int) row[2] == 3001 ? PiramidaDiscretStatus.On : PiramidaDiscretStatus.Off,\n' +
                    '            (DateTime) row[3])\n' +
                    '    ).FirstOrDefault();\n' +
                    'return result;', this.functions.selected.sourceFunction, this.setting.connectionGuid);
            case 'discreteGroupState':
                return String.Format('var query = \n' +
                    '"SELECT dis.discret_name as DISNAME, dis.discret_code as DISCODE, el.EVCODE, el.EVGENESISDT as timestamp " + \n' +
                    '  "FROM EVENTLIST as el " + \n' +
                    ' "INNER JOIN (SELECT el.OBJCODE, el.OBJITEM, MAX(el.EVGENESISDT) as timestamp " + \n' +
                    '               "FROM EVENTLIST as el " + \n' +
                    '              "WHERE el.OBJTYPE = 97 " + \n' +
                    '		         "AND convert(varchar(8), el.EVGENESISDT, 108) != \'00:00:00\' " + \n' +
                    '		         "AND el.EVGENESISDT <= \'" + {3}.ToString("yyyy-MM-dd HH:mm:ss") + "\' " + \n' +
                    '              "GROUP BY el.OBJCODE, el.OBJITEM) as last_discret_events " + \n' +
                    '    "ON el.OBJCODE = last_discret_events.OBJCODE " + \n' +
                    '   "AND el.OBJITEM = last_discret_events.OBJITEM " + \n' +
                    '   "AND el.EVGENESISDT = last_discret_events.timestamp " + \n' +
                    '   "AND el.APPID IS NOT NULL " + \n' +
                    ' "INNER JOIN (SELECT d.CODE as device_code, dis.Name as discret_name, dis.CODE as discret_code, dis.SUBDEVICEID as counting_object_code " + \n' +
                    '			    "FROM DISCRETS as dis, " + \n' +
                    '				     "DEVICES as d " + \n' +
                    '              "WHERE d.NAME = \'{2}\' " + \n' +
                    '                "AND dis.STATIONID = d.ID) as dis " + \n' +
                    '    "ON el.OBJITEM = dis.discret_code " + \n' +
                    '   "AND el.OBJCODE = dis.device_code " + \n' +
                    ' "ORDER BY dis.discret_code";\n' +
                    'return {0}("{1}", query)\n' +
                    '    .Select(row => \n' +
                    '        new PiramidaDiscretState(\n' +
                    '            new PiramidaDiscret((int) row[1], (string) row[0]),\n' +
                    '            (int) row[2] == 3001 ? PiramidaDiscretStatus.On : PiramidaDiscretStatus.Off,\n' +
                    '            (DateTime) row[3])\n' +
                    '    )\n' +
                    '    .ToArray();', this.functions.selected.sourceFunction, this.setting.connectionGuid, this.setting.discreteSettings.discreteGroupName, this.setting.endDate);
            case 'discreteStatesOnPeriod':
                return String.Format('return {0}("{1}", @"{2}", @"{3}", new TimeInterval({4}, {5}));', this.functions.selected.sourceFunction, this.setting.connectionGuid, this.setting.discreteSettings.discreteGroupName, this.setting.discreteSettings.discreteName, this.setting.startDate, this.setting.endDate);
            case 'discreteStateAtTimestamp':
                return String.Format('return {0}("{1}", @"{2}", @"{3}", {4}, (PiramidaDiscretStatus){5});', this.functions.selected.sourceFunction, this.setting.connectionGuid, this.setting.discreteSettings.discreteGroupName, this.setting.discreteSettings.discreteName, this.setting.endDate, _.isUndefined(this.setting.discreteSettings.discreteDefaultValue)
                    ? ''
                    : this.setting.discreteSettings.discreteDefaultValue.toString());
            case 'lastValue':
                return String.Format('return {0}("{1}", {2}, {3}, {4}, {5});', this.functions.selected.sourceFunction, this.setting.connectionGuid, this.setting.objCode.toString(), this.setting.objItem.toString(), this.setting.startDate, this.setting.endDate);
            default:
                return String.Format('return {0}("{1}", @"{2}", (PiramidaParameter){3}, {4}, {5});', this.functions.selected.sourceFunction, this.setting.connectionGuid, this.setting.objectName, this.setting.parameter.toString(), this.setting.startDate, this.setting.endDate);
        }
    };
    PiramidaSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    PiramidaSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Piramida.canEdited();
    };
    PiramidaSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Piramida.canPlanned();
    };
    PiramidaSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Piramida.canBacklight();
    };
    PiramidaSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Piramida.canPredefined();
    };
    return PiramidaSettingsCtrl;
}());
