var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var UiSelectOperationTimeParameter = (function (_super) {
    __extends(UiSelectOperationTimeParameter, _super);
    function UiSelectOperationTimeParameter(parameter) {
        var _this = _super.call(this, parameter.name, parameter.name) || this;
        _this.parameter = parameter;
        return _this;
    }
    return UiSelectOperationTimeParameter;
}(UiSelectItem));
var OperationTimeSettingsCtrl = (function () {
    function OperationTimeSettingsCtrl(parentScope, operationTimeParameterProvider, language, notificationService) {
        this.parentScope = parentScope;
        this.operationTimeParameterProvider = operationTimeParameterProvider;
        this.language = language;
        this.notificationService = notificationService;
        this.watchFunctions = [];
    }
    OperationTimeSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.startDates = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.OperationTime.StartDate;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            self.parentScope.param.OperationTime.StartDate = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('durationForPeriod', this.language.getElementValue('operationTimeDurationForPeriodHdr'), 'double'),
            new SelectSourceFunctionsItem('countOfEntriesForPeriod', this.language.getElementValue('operationTimeCountOfEntriesForPeriodHdr'), 'int'),
            new SelectSourceFunctionsItem('durationLastStateOnDate', this.language.getElementValue('operationTimeDurationLastStateOnDateHdr'), 'Dictionary<string, double>'),
            new SelectSourceFunctionsItem('logForPeriod', this.language.getElementValue('operationTimeLogForPeriodHdr'), 'OperationTimeParameterLog')
        ], function (t) {
            return t.ident === self.parentScope.param.OperationTime.Func;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            self.parentScope.param.OperationTime.Func = after.ident;
            switch (self.parentScope.param.OperationTime.Func) {
                case 'durationForPeriod':
                case 'countOfEntriesForPeriod':
                case 'logForPeriod':
                    self.startDates.selected = self.parentScope.settingsCtrl.getStartTimestamp();
                    self.endDates.selected = self.parentScope.settingsCtrl.getEndTimestamp();
                    break;
                case 'durationLastStateOnDate':
                    self.endDates.selected = self.parentScope.settingsCtrl.getEndTimestamp();
                    break;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        if (_.isUndefined(this.parentScope.param.OperationTime.StartDate)) {
            this.startDates.selected = self.parentScope.settingsCtrl.getStartTimestamp();
            self.parentScope.param.OperationTime.StartDate = this.startDates.selected.ident;
        }
        this.endDates = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.OperationTime.EndDate;
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            self.parentScope.param.OperationTime.EndDate = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        if (_.isUndefined(this.parentScope.param.OperationTime.EndDate)) {
            this.endDates.selected = self.parentScope.settingsCtrl.getEndTimestamp();
            self.parentScope.param.OperationTime.EndDate = this.endDates.selected.ident;
        }
        if (_.isUndefined(this.parentScope.param.OperationTime.ParameterName)) {
            this.devices = undefined;
            this.states = undefined;
        }
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
        this.operationTimeParameterProvider
            .getAllShortInfo()
            .then(function (operationTimeShortInfos) {
            _this.parameters = getVariantsContainer(self.parentScope, _.map(operationTimeShortInfos, function (parameter) {
                return new UiSelectOperationTimeParameter(parameter);
            }), function (t) {
                return t.ident === self.parentScope.param.OperationTime.ParameterName;
            }, function (after, before) {
                if ((after === before && !_.isUndefined(_this.devices) && !_.isUndefined(_this.states)) ||
                    after == undefined) {
                    return;
                }
                self.parentScope.param.OperationTime.ParameterName = after.ident;
                if (!_.isUndefined(_this.devices)) {
                    _this.devices.destroy();
                }
                _this.devices = getVariantsContainer(self.parentScope, _.map(self.parameters.selected.parameter.devices, function (device) {
                    return new UiSelectItem(device.id, device.name);
                }), function (t) {
                    return t.name === self.parentScope.param.OperationTime.DeviceName;
                }, function (after, before) {
                    if (after === before)
                        return;
                    self.parentScope.param.OperationTime.DeviceName = after.name;
                    self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
                });
                if (!_.isUndefined(_this.states)) {
                    _this.states.destroy();
                }
                _this.states = getVariantsContainer(self.parentScope, _.map(self.parameters.selected.parameter.states, function (state) {
                    return new UiSelectItem(state.name, state.name);
                }), function (t) {
                    return t.ident === self.parentScope.param.OperationTime.StateName;
                }, function (after, before) {
                    if (after === before)
                        return;
                    self.parentScope.param.OperationTime.StateName = after.ident;
                    self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
                });
                self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            });
        })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    OperationTimeSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        this.startDates.destroy();
        this.endDates.destroy();
        this.parameters.destroy();
        if (!_.isUndefined(this.devices)) {
            this.devices.destroy();
        }
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
    };
    OperationTimeSettingsCtrl.prototype.getFormula = function () {
        var deviceName = this.parentScope.param.OperationTime.DeviceName;
        var paramName = this.parentScope.param.OperationTime.ParameterName;
        var regimenName = this.parentScope.param.OperationTime.StateName;
        var startDate = this.parentScope.param.OperationTime.StartDate;
        var endDate = this.parentScope.param.OperationTime.EndDate;
        var formula = '';
        switch (this.parentScope.param.OperationTime.Func) {
            case 'durationForPeriod':
                formula =
                    'return OperationTimeGetDurationForPeriod("' +
                        deviceName +
                        '", "' +
                        paramName +
                        '", "' +
                        regimenName +
                        '", ' +
                        startDate +
                        ', ' +
                        endDate +
                        ');';
                break;
            case 'countOfEntriesForPeriod':
                formula =
                    'return OperationTimeGetCountOfEntriesForPeriod("' +
                        deviceName +
                        '", "' +
                        paramName +
                        '", "' +
                        regimenName +
                        '", ' +
                        startDate +
                        ', ' +
                        endDate +
                        ');';
                break;
            case 'durationLastStateOnDate':
                formula =
                    'return OperationTimeGetDurationLastStateOnDate("' +
                        paramName +
                        '", "' +
                        regimenName +
                        '", ' +
                        endDate +
                        ');';
                break;
            case 'logForPeriod':
                formula =
                    'return OperationTimeGetLogForPeriod("' + paramName + '", ' + startDate + ', ' + endDate + ');';
                break;
        }
        return formula;
    };
    OperationTimeSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        if (_.isUndefined(this.states) ||
            this.states == null ||
            (!this.states.selected && this.parentScope.param.OperationTime.Func !== 'logForPeriod')) {
            return true;
        }
        if (_.isUndefined(this.parameters) || this.parameters == null || !this.parameters.selected) {
            return true;
        }
        if (_.isUndefined(this.devices) ||
            this.devices == null ||
            (!this.devices.selected &&
                (this.parentScope.param.OperationTime.Func === 'durationForPeriod' ||
                    this.parentScope.param.OperationTime.Func === 'countOfEntriesForPeriod'))) {
            return true;
        }
        return false;
    };
    OperationTimeSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.OperationTime.canEdited();
    };
    OperationTimeSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.OperationTime.canPlanned();
    };
    OperationTimeSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.OperationTime.canBacklight();
    };
    OperationTimeSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.OperationTime.canPredefined();
    };
    return OperationTimeSettingsCtrl;
}());
