var OpcSettings = (function () {
    function OpcSettings(templateHasStep) {
        this.address = '';
        this.name = '';
        this.func = 'onCurrentTime';
        this.startPeriod = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endPeriod = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
        this.maxFields = 10000;
        this.includeBorders = true;
    }
    OpcSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new OpcSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.name = obj.name;
        clone.address = obj.address;
        clone.startPeriod = obj.startPeriod;
        clone.endPeriod = obj.endPeriod;
        clone.includeBorders = obj.includeBorders;
        clone.maxFields = obj.maxFields;
        return clone;
    };
    OpcSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.name === other.name &&
            obj.address === other.address &&
            obj.startPeriod === other.startPeriod &&
            obj.endPeriod === other.endPeriod &&
            obj.includeBorders === other.includeBorders &&
            obj.maxFields === other.maxFields);
    };
    OpcSettings.prototype.canEdited = function () {
        return this.func !== 'historical';
    };
    OpcSettings.prototype.canPlanned = function () {
        return true;
    };
    OpcSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    OpcSettings.prototype.canPredefined = function () {
        return false;
    };
    return OpcSettings;
}());
