var MySqlSettings = (function () {
    function MySqlSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    MySqlSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new MySqlSettings();
        clone.func = obj.func;
        clone.sql = obj.sql;
        clone.includeHeader = obj.includeHeader;
        clone.connectionGuid = obj.connectionGuid;
        return clone;
    };
    MySqlSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func &&
            obj.connectionGuid === other.connectionGuid &&
            obj.sql === other.sql &&
            obj.includeHeader === other.includeHeader);
    };
    MySqlSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    MySqlSettings.prototype.canPlanned = function () {
        return true;
    };
    MySqlSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray', 'objectArray'], this.func);
    };
    MySqlSettings.prototype.canPredefined = function () {
        return false;
    };
    return MySqlSettings;
}());
