var LogFieldScope = (function () {
    function LogFieldScope(scope, sourse, fieldTypes, openDropdownFieldSettingsWindow, language) {
        var _this = this;
        this.language = language;
        this.caption = sourse.caption;
        this.type = sourse.type;
        this.isRequired = sourse.isRequired;
        this.isKey = sourse.isKey;
        this.defaultValue = sourse.defaultValue;
        this.additionalSettings = sourse.additionalSettings;
        this.width = sourse.width;
        this.types = getVariantsContainer(scope, _.deepclone(fieldTypes), function (t) {
            return t.ident === _this.type;
        }, function (after, before) {
            if (before === after) {
                return;
            }
            _this.type = after.ident;
            _this.defaultValue = _this.types.selected.defaultValue;
            _this.width = _this.types.selected.width;
            _this.updateDefaultValues();
        });
        this.openDropdownFieldSettingsWindow = function () {
            openDropdownFieldSettingsWindow(_this);
        };
        this.updateDefaultValues = function () {
            if (!_.isUndefined(_this.defaultValues)) {
                _this.defaultValues.destroy();
            }
            _this.defaultValues = getVariantsContainer(scope, _this.type === 'datetime'
                ? [
                    new UiSelectItem(LogFieldDateTimeDefaultValue.Now, _this.language.getElementValue('timeStampNowHdr')),
                    new UiSelectItem(LogFieldDateTimeDefaultValue.StartTimeReport, _this.language.getElementValue('reportDataCreateHdr')),
                    new UiSelectItem(LogFieldDateTimeDefaultValue.None, _this.language.getElementValue('reportParameterSettingsLogDateTimeDefaultValueHdr')),
                ]
                : _.map(_this.additionalSettings, function (option) {
                    return new UiSelectItem(option, option);
                }), function (t) {
                return t.ident === _this.defaultValue;
            }, function (after, before) {
                if (before === after) {
                    return;
                }
                if (_.isUndefined(after)) {
                    _this.defaultValue = after;
                }
                else {
                    _this.defaultValue = after.ident;
                }
            });
        };
        var keyIsTrueWatchUnreg = scope.$watch(function () {
            return _this.isKey;
        }, function (after, before) {
            if (after === before || !after)
                return;
            _this.isRequired = true;
        });
        this.updateDefaultValues();
        this.destroy = function () {
            _this.types.destroy();
            _this.defaultValues.destroy();
            keyIsTrueWatchUnreg();
        };
    }
    return LogFieldScope;
}());
