var LogFieldList = (function () {
    function LogFieldList(scope, reportParameter, fieldTypes, modal, language, notificationService) {
        var _this = this;
        this.language = language;
        this.notificationService = notificationService;
        this.isCorrect = true;
        var modalService = modal;
        this.headers = [
            '<div class="log-field-list-header" style="width: 30%; border-right:solid 1px rgb(200,200,200);">{{ \'reportTitleHdr\' | lng }}</div>',
            '<div class="log-field-list-header" style="width: 15%; border-right:solid 1px rgb(200,200,200);">{{ \'typeHdr\' | lng }}</div>',
            '<div class="log-field-list-header" style="width: 11%; border-right:solid 1px rgb(200,200,200);">{{ \'reportRequiredHdr\' | lng }}</div>',
            '<div class="log-field-list-header" style="width: 4%; border-right:solid 1px rgb(200,200,200);"><i class="fa fa-lock" title="{{ \'smsReportNewLogRowDialogKeyFieldsHdr\' | lng }}"></i></div>',
            '<div class="log-field-list-header" style="width: 10%; border-right:solid 1px rgb(200,200,200);">{{ \'reportWidthHdr\' | lng }}</div>',
            '<div class="log-field-list-header" style="width: 30%;" title="{{ \'reportSettingsHnt\' | lng }}">{{ \'reportDefaultValueHdr\' | lng }}</div>',
        ];
        this.cells = [
            '<input input-safe-html-text type="text" class="form-control" placeholder="{{ \'reportTitlePch\' | lng }}" ng-model="item.caption" title="{{item.caption}}" style="width: 30%; display: inline-block;">',
            '<ui-select class="ui-select-cell" ng-model="item.types.selected">' +
                '<ui-select-match placeholder="{{ \'reportChangeTypePch\' | lng }}" >' +
                '<span ng-bind-html="$select.selected.name"></span>' +
                '</ui-select-match >' +
                '<ui-select-choices repeat="type in item.types | filter: {name: $select.search}">' +
                '<small ng-bind-html="type.name"></small>' +
                '</ui-select-choices>' +
                '</ui-select>',
            '<input type="checkbox" class="form-control" ng-disabled="item.isKey" ng-model="item.isRequired" style="width: 10%; display: inline-block; margin-right: 0px !important;">',
            '<input type="checkbox" class="form-control" ng-model="item.isKey" style="width: 5%; display: inline-block; margin-right: 0px !important;">',
            '<input input-float type="text" class="form-control" placeholder="{{ \'reportWidthPch\' | lng }}" ng-model="item.width" style="width: 10%; display: inline-block;">',
            '<input ' +
                'type="text" ' +
                'input-safe-html-text ' +
                'class="form-control" ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.String].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.String].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValue" ' +
                'title="{{item.defaultValue}}" ' +
                'placeholder="{{ \'reportValuePch\' | lng }}" ' +
                'style="width: 25%; display: inline-block;">',
            '<input ' +
                'input-float ' +
                'type="text" ' +
                'class="form-control" ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.Double].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.Double].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValue" ' +
                'placeholder="{{ \'reportValuePch\' | lng }}" ' +
                'style="width: 25%; display: inline-block;">',
            '<input ' +
                'input-time ' +
                'type="text" ' +
                'class="form-control" ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.Time].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.Time].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValue" ' +
                'placeholder="{{ \'reportValuePch\' | lng }}" ' +
                'style="width: 25%; display: inline-block;">',
            '<input ' +
                'input-time-span ' +
                'type="text" ' +
                'class="form-control" ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.TimeSpan].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.TimeSpan].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValue" ' +
                'placeholder="{{ \'reportValuePch\' | lng }}" ' +
                'style="width: 25%; display: inline-block;">',
            '<ui-select ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.DateTime].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.DateTime].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValues.selected" ' +
                'class="ui-select-cell"' +
                'style="width: 25%">' +
                '<ui-select-match placeholder="{{ \'reportValuePch\' | lng }}" >' +
                '<span title="{{$select.selected.name}}">{{$select.selected.name | smsTailTo:18:" …"}}</span>' +
                '</ui-select-match >' +
                '<ui-select-choices repeat="value in item.defaultValues | filter:$select.search">' +
                '<small title="{{value.name}}">{{value.name | smsTailTo:24:" …"}}</small>' +
                '</ui-select-choices>' +
                '</ui-select>' +
                '<ui-select ' +
                'ng-if="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.Dropdown].toLowerCase() +
                '\'" ' +
                'ng-hide="item.types.selected.ident != \'' +
                LogFieldTypes[LogFieldTypes.Dropdown].toLowerCase() +
                '\'" ' +
                'ng-model="item.defaultValues.selected" ' +
                'class="ui-select-cell"' +
                'style="width: 20%">' +
                '<ui-select-match placeholder="{{ \'reportValuePch\' | lng }}" >' +
                '<span title="{{$select.selected.name}}">{{$select.selected.name | smsTailTo:12:" …"}}</span>' +
                '</ui-select-match >' +
                '<ui-select-choices repeat="value in item.defaultValues | filter:$select.search">' +
                '<small title="{{value.name}}">{{value.name | smsTailTo:18:" …"}}</small>' +
                '</ui-select-choices>' +
                '</ui-select>' +
                '<div class="btn" ng-show="item.types.selected.ident == \'' +
                LogFieldTypes[LogFieldTypes.Dropdown].toLowerCase() +
                '\'" ng-click="item.openDropdownFieldSettingsWindow()" style="display: inline; cursor: pointer;"><i class="fa fa-gear"></i></div>',
        ];
        this.openDropdownFieldSettingsWindow = function (field) {
            var modalInstance = modalService.open({
                templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/LogSettings/LogDropdownFieldSettingsModal.html',
                controller: 'LogDropdownFieldSettingsModalCtrl',
                windowClass: 'app-modal-window level-two',
                backdrop: 'static',
                resolve: {
                    field: function () {
                        return field;
                    },
                },
            });
            modalInstance.result.then(function (field) {
                field.updateDefaultValues();
            });
        };
        this.add = function () {
            reportParameter.Log.fields.push(new LogFieldScope(scope, {
                caption: '',
                type: LogFieldTypes[LogFieldTypes.String].toLowerCase(),
                isRequired: false,
                isKey: false,
                defaultValue: undefined,
                additionalSettings: undefined,
                width: 72,
            }, fieldTypes, _this.openDropdownFieldSettingsWindow, _this.language));
        };
        this.checkDuplication = function () {
            var length = reportParameter.Log.fields.length;
            for (var i = 0; i < length - 1; i++) {
                for (var j = i + 1; j < length; j++) {
                    if (!_.isEmpty(reportParameter.Log.fields[i].caption) &&
                        reportParameter.Log.fields[i].caption === reportParameter.Log.fields[j].caption) {
                        return true;
                    }
                }
            }
            return false;
        };
        this.check = function () {
            var isDuplication = _this.checkDuplication();
            if (isDuplication && _this.isCorrect) {
                _this.notificationService.errorMessage(_this.language.getElementValue('reportParameterLogThereAreDuplicatesMsg'));
            }
            _this.isCorrect = !isDuplication;
        };
    }
    return LogFieldList;
}());
