var ExcelSettingsCtrl = (function () {
    function ExcelSettingsCtrl(parentScope, language) {
        this.parentScope = parentScope;
        this.language = language;
        this.functions = [];
        this.connectionTypes = [11];
        this.watchFunctions = [];
    }
    ExcelSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('tableHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
        ], function (t) {
            return t.ident === self.parentScope.param.Excel.func;
        }, function (after, before) {
            if (after == undefined || after === before) {
                return;
            }
            self.parentScope.param.Excel.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.functions.selected = this.parentScope.getSelectedItem(this.functions, this.parentScope.param.Excel.func);
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Excel;
        }, function (excel) {
            if (excel == undefined)
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    ExcelSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    ExcelSettingsCtrl.prototype.isTableParameterTypeSelected = function () {
        return this.parentScope.param.Excel.func === 'table';
    };
    ExcelSettingsCtrl.prototype.getFormula = function () {
        var type;
        var fieldAAsString = _.isDefined(this.parentScope.param.Excel.fieldA) &&
            this.parentScope.param.Excel.fieldA.length > 0 &&
            this.parentScope.param.Excel.fieldA[0] === '%' &&
            this.parentScope.param.Excel.fieldA[this.parentScope.param.Excel.fieldA.length - 1] === '%'
            ? this.parentScope.param.Excel.fieldA
            : '"' + this.parentScope.param.Excel.fieldA + '"';
        var fieldBAsString = _.isDefined(this.parentScope.param.Excel.fieldB) &&
            this.parentScope.param.Excel.fieldB.length > 0 &&
            this.parentScope.param.Excel.fieldB[0] === '%' &&
            this.parentScope.param.Excel.fieldB[this.parentScope.param.Excel.fieldB.length - 1] === '%'
            ? this.parentScope.param.Excel.fieldB
            : '"' + this.parentScope.param.Excel.fieldB + '"';
        switch (this.functions.selected.ident) {
            case 'table':
                type = 'ReportTable';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return ('return GetExcelTableByConnection(@"' +
                    this.parentScope.param.Excel.connectionGuid +
                    '", "' +
                    this.parentScope.param.Excel.sheetName +
                    '", ' +
                    fieldAAsString +
                    ', ' +
                    fieldBAsString +
                    ');');
            case 'cellString':
                type = 'string';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return ('return ExcelCellAsStringByConnection(@"' +
                    this.parentScope.param.Excel.connectionGuid +
                    '", "' +
                    this.parentScope.param.Excel.sheetName +
                    '", ' +
                    fieldAAsString +
                    ');');
            case 'cellDouble':
                type = 'double';
                this.parentScope.settingsCtrl.formulaCtrl.setResultType(type);
                return ('return ExcelCellAsDoubleByConnection(@"' +
                    this.parentScope.param.Excel.connectionGuid +
                    '", "' +
                    this.parentScope.param.Excel.sheetName +
                    '", ' +
                    fieldAAsString +
                    ');');
        }
        return '';
    };
    ExcelSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    ExcelSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Excel.canEdited();
    };
    ExcelSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Excel.canPlanned();
    };
    ExcelSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Excel.canBacklight();
    };
    ExcelSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Excel.canPredefined();
    };
    return ExcelSettingsCtrl;
}());
