var SwitchoverFormService = (function () {
    function SwitchoverFormService($q, switchoverFormProviderService, switchoverFormTemplateProviderService, switchoverFormAlarmsProviderService, modal, location, notificationService, userProvider, configProvider, language) {
        this.$q = $q;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.switchoverFormAlarmsProviderService = switchoverFormAlarmsProviderService;
        this.modal = modal;
        this.location = location;
        this.notificationService = notificationService;
        this.userProvider = userProvider;
        this.configProvider = configProvider;
        this.language = language;
    }
    SwitchoverFormService.prototype.create = function (templateId, templateName) {
        var _this = this;
        this.switchoverFormProviderService
            .isExistsOpenedSwitchoverForm()
            .then(function (openSwitchoverForm) {
            if (openSwitchoverForm) {
                _this.notificationService.warnMessage(_this.language.getElementValue('switchoverFormsDontCreateNewFormMsg'));
                return;
            }
            _this.$q
                .all([
                _this.switchoverFormTemplateProviderService.getSignerAppointments(templateId),
                _this.switchoverFormProviderService.getSerialNumber(templateName),
                _this.userProvider.getRegularUsers(),
                _this.configProvider.getPreferredSigners(),
            ])
                .then(function (_a) {
                var appointments = _a[0], serialNumber = _a[1], users = _a[2], preferredSigners = _a[3];
                var modalInstance = _this.modal.open({
                    templateUrl: 'ng1/dist/src/SwitchoverForms/View/CreateModal/CreateSwitchoverFormModal.html',
                    controller: 'createSwitchoverFormModalCtrl',
                    backdrop: 'static',
                    resolve: {
                        appointments: function () { return appointments; },
                        serialNumber: function () { return serialNumber; },
                        users: function () { return _.sortBy(users, function (user) { return user.name; }); },
                        preferredSigners: function () { return preferredSigners; },
                    },
                });
                modalInstance.result.then(function (modalResult) {
                    if (!_.isEqual(preferredSigners, modalResult.signers)) {
                        _this.configProvider
                            .setPreferredSigners(modalResult.signers)
                            .catch(function (error) {
                            return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
                        });
                    }
                    if (modalResult.needVerifyConditions) {
                        _this.switchoverFormTemplateProviderService
                            .getFormConditions(templateId)
                            .then(function (formConditions) {
                            if (!_.any(formConditions, function (condition) {
                                return condition.type === 1;
                            })) {
                                _this.createSwitchoverForm(templateId, modalResult.serialNumber, modalResult.signers, []);
                            }
                            else {
                                _this.$q
                                    .all([
                                    _this.switchoverFormAlarmsProviderService.getTemplateAlarms(templateId),
                                    _this.configProvider.getSwitchoverFormConfiguration(),
                                ])
                                    .then(function (_a) {
                                    var formAlarms = _a[0], settings = _a[1];
                                    return _this.modal
                                        .open({
                                        templateUrl: 'ng1/dist/src/SwitchoverForms/View/VerifyConditionModal/VerifySwitchoverFormConditionModal.html',
                                        controller: 'verifySwitchoverFormConditionModalCtrl',
                                        windowClass: 'switchover-form-verify-conditions-modal',
                                        backdrop: 'static',
                                        resolve: {
                                            formName: function () { return templateName; },
                                            formSerialNumber: function () {
                                                return modalResult.serialNumber;
                                            },
                                            conditions: function () {
                                                return _this.setConditionsUiOrder(formConditions);
                                            },
                                            alarms: function () { return formAlarms; },
                                            delayBetweenSteps: function () {
                                                return settings.delayBetweenSteps;
                                            },
                                        },
                                    })
                                        .result.then(function (conditions) {
                                        _this.createSwitchoverForm(templateId, modalResult.serialNumber, modalResult.signers, conditions);
                                    }, function () { });
                                });
                            }
                        });
                    }
                    else {
                        _this.createSwitchoverForm(templateId, modalResult.serialNumber, modalResult.signers, []);
                    }
                }, function () { });
            }, function (error) {
                return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
            });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormService.prototype.createSwitchoverForm = function (templateId, serialNumber, signers, conditions) {
        var _this = this;
        this.switchoverFormProviderService
            .create(templateId, serialNumber, signers, conditions)
            .then(function (switchoverForm) { return _this.location.url('switchover-forms/' + switchoverForm.id); })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsCreatedErrorMsg'), error);
        });
    };
    SwitchoverFormService.prototype.setConditionsUiOrder = function (conditions) {
        var conditionOrder = 0;
        _.forEach(conditions, function (condition) {
            if (condition.type === 2) {
                return;
            }
            if (!condition.isOrderNumberHidden) {
                conditionOrder++;
            }
            condition.uiOrderNumber = conditionOrder;
        });
        return conditions;
    };
    SwitchoverFormService.$inject = [
        '$q',
        'switchoverFormProvider',
        'switchoverFormTemplateProvider',
        'switchoverFormAlarmsProvider',
        '$modal',
        '$location',
        'notificationService',
        'userProvider',
        'switchoverFormConfigurationProvider',
        'language',
    ];
    return SwitchoverFormService;
}());
angular.module('kamhpp').service('switchoverFormService', SwitchoverFormService);
