var SwitchoverFormTemplateAttachmentsModalCtrl = (function () {
    function SwitchoverFormTemplateAttachmentsModalCtrl($scope, modal, $upload, clientSettings, language, notificationService, switchoverFormTemplateAttachmentService, exportService, templateId, attachments) {
        this.$scope = $scope;
        this.modal = modal;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.language = language;
        this.notificationService = notificationService;
        this.switchoverFormTemplateAttachmentService = switchoverFormTemplateAttachmentService;
        this.exportService = exportService;
        this.templateId = templateId;
        this.attachments = attachments;
        this.$scope.ctrl = this;
    }
    SwitchoverFormTemplateAttachmentsModalCtrl.prototype.upload = function (attachments) {
        var _this = this;
        if (_.isEmpty(attachments)) {
            return;
        }
        this.$upload
            .upload({
            url: this.clientSettings.getServerInstance() + '/SwitchoverFormTemplateAttachment/ImportAttachments',
            file: attachments,
            data: this.templateId,
        })
            .then(function (response) {
            var _a;
            (_a = _this.attachments).push.apply(_a, response.data);
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsTemplateAttachmentsAddedMsg'));
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsTemplateAttachmentsFailedToAddMsg'), error);
        });
    };
    SwitchoverFormTemplateAttachmentsModalCtrl.prototype.exportAttachment = function (attachment) {
        this.exportService.export('/SwitchoverFormTemplateAttachment/ExportAttachment?id=' + attachment.id);
    };
    SwitchoverFormTemplateAttachmentsModalCtrl.prototype.removeAttachment = function (index) {
        var _this = this;
        this.switchoverFormTemplateAttachmentService
            .deleteAttachment(this.attachments[index].id)
            .then(function () {
            _this.attachments.splice(index, 1);
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsTemplateAttachmentRemovedMsg'));
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsTemplateAttachmentFailedToRemoveMsg'), error);
        });
    };
    SwitchoverFormTemplateAttachmentsModalCtrl.prototype.close = function () {
        this.modal.close();
    };
    SwitchoverFormTemplateAttachmentsModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        '$upload',
        'clientSettings',
        'language',
        'notificationService',
        'switchoverFormTemplateAttachmentProvider',
        'exportService',
        'templateId',
        'attachments',
    ];
    return SwitchoverFormTemplateAttachmentsModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('switchoverFormTemplateAttachmentsModalCtrl', SwitchoverFormTemplateAttachmentsModalCtrl);
