app.controller('DeviceSelectModalWindowCtrl', function ($scope, $http, clientSettings, notificationService, guid, $modal, $window, blockUI, $modalInstance, shifrsOfDevicesThatCanNotBeAdded, language) {
    $scope.tree = {};
    $scope.columns = [{ header: language.getElementValue('nameHdr') }];
    $scope.startingData = {
        id: '1',
        text: language.getElementValue('cimModelLoadDictionaryPch'),
    };
    $scope.plugins = ['types', 'wholerow', 'grid'];
    $scope.types = {
        none: { icon: 'glyphicon glyphicon-none' },
        folder: { icon: 'fa fa-cog' },
        file: { icon: 'fa fa-file-o' },
    };
    $scope.expandLevel = 2;
    $scope.loadData = function () {
        $http.get(clientSettings.getServerInstance() + '/CimModel/GetDevicesTreeWithoutParameters').then(function (response) {
            $window.localStorage.deviceSelectModalWindowData = undefined;
            $scope.treeData = response.data.Nodes;
            $scope.mapItems = response.data.CimDictionaryMap;
            $window.localStorage.deviceSelectModalWindowData = JSON.stringify($scope.treeData);
            drawTree($scope.treeData);
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    var getIconName = function (className) {
        if (className == 'parameter')
            return 'file';
        return 'folder';
    };
    var drawTree = function (data) {
        var treeNodes = _.map(data, function (arg) {
            return {
                id: arg.UniqueCode,
                parent: arg.ParentUniqueCode == '' ? '#' : arg.ParentUniqueCode,
                text: arg.Name,
                changed: 'false',
                type: getIconName(arg.ClassUniqueCode),
            };
        });
        $scope.tree.element.jstree().settings.core.data = treeNodes;
        $scope.tree.element.jstree().refresh();
    };
    $scope.ok = function () {
        var selectedNodes = $scope.tree.element.jstree().get_selected();
        if (_.isUndefined(selectedNodes) || selectedNodes.length === 0) {
            notificationService.infoMessage(language.getElementValue('cimModelSelectItemEquipmentMsg'));
            return;
        }
        var nodeId = selectedNodes[0];
        var newDeviceId = guid.fromString(nodeId);
        var deviceWasAddedBefore = _.find(shifrsOfDevicesThatCanNotBeAdded, function (arg) {
            return arg === newDeviceId;
        }) != undefined;
        if (deviceWasAddedBefore) {
            notificationService.infoMessage(language.getElementValue('cimModelSelectedEquipmentAlreadyAddedMsg'));
            return;
        }
        if (nodeId.indexOf('group_node') == 0) {
            notificationService.infoMessage(language.getElementValue('cimModelSelectItemEquipmentSelectedGroupEquipmentMsg'));
        }
        else {
            $modalInstance.close({ result: true, id: newDeviceId, name: $('.jstree-clicked').text() });
        }
    };
    $scope.cancel = function () {
        $modalInstance.close({ result: false });
    };
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            if (!$window.localStorage.deviceSelectModalWindowData) {
                $scope.loadData();
            }
            else {
                blockUI.start();
                $scope.treeData = JSON.parse($window.localStorage.deviceSelectModalWindowData);
                drawTree($scope.treeData);
                blockUI.stop();
            }
        }
    });
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        $scope.tree.element.jstree().destroy();
        unregistrationJstreeReadyOnFunc();
        unregistrationDestroyFunc();
    });
});
