angular
    .module('kamhpp')
    .controller('CimModelViewerCtrl', function ($scope, $http, clientSettings, notificationService, $modal, language, authentication, $rootScope, $routeParams, $q, $location, exportService) {
    var _this = this;
    var watchFunctions = [];
    var modelRequiresSaving = false;
    $scope.dictionaryInstanceCtrl = new CimDictionaryInstance($scope, clientSettings, $http, $q, exportService);
    $scope.tree = {};
    $scope.isJstreeReady = false;
    $scope.userCameFromMainPage = $routeParams.cameFromMainPage === '1';
    $scope.userHasEditPermission = authentication.hasPermission($rootScope.permissions.CimEdit);
    $scope.userHasAdminPermission = authentication.hasPermission($rootScope.permissions.CimAdmin);
    var unregistrationJstreeReadyOnFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            $scope.isJstreeReady = true;
        }
    });
    $scope.columns = [{ header: '', value: 'text' }];
    $scope.isDictionariesLoaded = false;
    $scope.dictionaryInstanceCtrl
        .loadDictionaryInstance()
        .then(function (dictionaries) {
        $scope.dictionaryInstanceCtrl.instances = dictionaries;
        $scope.startingData =
            dictionaries.length === 0
                ? {
                    id: '1',
                    text: language.getElementValue('cimModelNoDictionaryPch'),
                    a_attr: { title: language.getElementValue('cimModelNoDictionaryTooltip') },
                }
                : {
                    id: '1',
                    text: language.getElementValue('cimModelLoadDictionaryPch'),
                };
        $scope.isDictionariesLoaded = true;
    })
        .catch(function (error) {
        _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
    });
    $scope.plugins = ['types', 'wholerow', 'grid'];
    $scope.types = {
        none: { icon: 'glyphicon glyphicon-none' },
        folder: { icon: 'fa fa-cog' },
        file: { icon: 'fa fa-file-o' },
    };
    $scope.expandLevel = 2;
    $scope.selectedNodeLevel = 0;
    $scope.groupedLinks = [];
    $scope.refresh = function (arg) {
        if ($scope.isJstreeReady == false) {
            return;
        }
        $http.get(clientSettings.getServerInstance() + '/CimModel/GetDictionaryTree?id=' + arg).then(function (response) {
            $scope.selectedNodeLevel = 0;
            $scope.treeData = response.data.Nodes;
            $scope.mapItems = response.data.CimDictionaryMap;
            drawTree();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.$watch('tree.selectedElements', function () {
        afterSelectedNodeChanged();
    });
    var afterSelectedNodeChanged = function () {
        if ($scope.tree.selectedElements === undefined || $scope.tree.selectedElements[0] === undefined)
            return;
        var uniqueCode = $scope.tree.selectedElements[0];
        $scope.selectedNodeUniqueCode = uniqueCode;
        $scope.selectedNodeLevel = $('#' + uniqueCode.replace('#', '\\#')).attr('aria-level');
        $scope.selectedNode = _.find($scope.treeData, function (arg) {
            return arg.TreeId == $scope.selectedNodeUniqueCode;
        });
        updateAvailableSubitemsForSelectedDictionaryItem();
        $http
            .get(clientSettings.getServerInstance() +
            '/CimModel/GetClassInstance?uniqueCode=' +
            $scope.selectedNode.UniqueCode)
            .then(function (response) {
            $scope.selectedClassInstanceDto = response.data;
            watchFunctions.push($scope.$watch(function () {
                return $scope.selectedClassInstanceDto;
            }, function (newValue, oldValue) {
                if (newValue === oldValue)
                    return;
                if (newValue.UniqueCode === oldValue.UniqueCode) {
                    modelRequiresSaving = true;
                }
            }, true));
            $scope.groupLinksByUniqueCode($scope.selectedClassInstanceDto.LinksTo);
            $('#cimClassNameInput').focus();
        });
    };
    var getParentClasses = function () {
        var res = [];
        var uniqueCode = $scope.tree.selectedElements[0];
        var node = _.find($scope.treeData, function (arg) {
            return arg.TreeId == uniqueCode;
        });
        var prevUniqueCode = '';
        while (node != undefined && node != null) {
            if (prevUniqueCode != node.ClassUniqueCode) {
                res.push(node);
            }
            prevUniqueCode = node.ClassUniqueCode;
            node = _.find($scope.treeData, function (arg) {
                return arg.UniqueCode == node.ParentUniqueCode;
            });
        }
        return res;
    };
    $scope.currentMapItems = [];
    var updateAvailableSubitemsForSelectedDictionaryItem = function () {
        $scope.currentMapItems = [];
        var map = getParentClasses();
        var mapItems = $scope.mapItems;
        var currentMapItem;
        var _loop_1 = function (i) {
            var currentClass = map[i];
            currentMapItem = _.find(mapItems, function (arg) {
                return arg.UniqueCode == currentClass.ClassUniqueCode && arg.Id == currentClass.ProfileId;
            });
            if (currentMapItem == undefined)
                return { value: void 0 };
            mapItems = currentMapItem.Items;
        };
        for (var i = map.length - 1; i >= 0; i--) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        if (currentMapItem == null) {
            $scope.currentMapItems = $scope.mapItems;
        }
        else {
            if ($scope.selectedNode.IsGroupNode == true) {
                $scope.currentMapItems = [];
                $scope.currentMapItems.push(currentMapItem);
            }
            else {
                $scope.currentMapItems = currentMapItem.Items;
                if (currentMapItem.ShowRecursiveSelfLinks &&
                    !_.contains($scope.currentMapItems, currentMapItem)) {
                    $scope.currentMapItems.push(currentMapItem);
                }
            }
        }
    };
    $scope.addNewTreeNode = function (mapItem) {
        $http
            .get(clientSettings.getServerInstance() +
            '/CimModel/CanCreateLinkInstance?linkUniqueCode=' +
            mapItem.LinkUniqueCode +
            '&sourceClassInstanceUniqueCode=' +
            ($scope.selectedNode.ClassUniqueCode == mapItem.ParentUniqueCode
                ? $scope.selectedNode.UniqueCode
                : $scope.selectedNode.ParentUniqueCode))
            .then(function (response) {
            if (!response.data.answer) {
                notificationService.warnMessage(language.getElementValue('cimModelCannotBeAddLinkOneToOneMsg'));
                return;
            }
            var tree = $scope.tree.element.jstree();
            var parentNodeUniqueCode = tree.get_selected();
            var parentNode = _.find($scope.treeData, function (arg) {
                return arg.TreeId == parentNodeUniqueCode;
            });
            if (parentNode != undefined && parentNode.IsGroupNode == true) {
                parentNodeUniqueCode = tree.get_parent(parentNodeUniqueCode);
                parentNode = _.find($scope.treeData, function (arg) {
                    return arg.TreeId == parentNodeUniqueCode;
                });
            }
            if (mapItem.UniqueCode == 'parameter') {
                $scope.newParametersModalWindow = $modal.open({
                    templateUrl: 'ng1/dist/src/CimModel/ClassViewer/InsertParametersModal.html',
                    controller: 'cimModelInsertParametersModalCtrl',
                    backdrop: 'static',
                });
                $scope.newParametersModalWindow.result.then(function (res) {
                    if (res.ok == false)
                        return;
                    doAddNewTreeNode(mapItem, res.data, parentNodeUniqueCode);
                }, function () { });
            }
            else {
                doAddNewTreeNode(mapItem, [{ name: language.getElementValue('cimModelNewObjectHdr') + ' ' + mapItem.Name }], parentNodeUniqueCode);
            }
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('cimModelServerAddressErrorMsg'));
        });
    };
    var getIconName = function (className) {
        if (className == 'parameter')
            return 'file';
        return 'folder';
    };
    var getParentTreeNodeForInsert = function (mapItem, selectedNodeUniqueCode) {
        if ($scope.selectedNode.IsGroupNode == true)
            return selectedNodeUniqueCode;
        var childs = _.filter($scope.tree.element.jstree().settings.core.data, function (arg) {
            return arg.parent == selectedNodeUniqueCode;
        });
        var _loop_2 = function (i) {
            var child = childs[i];
            var treeDataNode = _.find($scope.treeData, function (arg) {
                return arg.TreeId == child.id;
            });
            if (treeDataNode != undefined &&
                treeDataNode.IsGroupNode == true &&
                treeDataNode.ClassUniqueCode == mapItem.UniqueCode) {
                return { value: child.id };
            }
        };
        for (var i = 0; i < childs.length; i++) {
            var state_2 = _loop_2(i);
            if (typeof state_2 === "object")
                return state_2.value;
        }
        return selectedNodeUniqueCode;
    };
    var doAddNewTreeNode = function (mapItem, newNodes, parentNodeUniqueCode) {
        for (var i = 0; i < newNodes.length; i++) {
            var newName = newNodes[i].name;
            if (newName == '' || newName == null)
                continue;
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/CreateNewClassInstance', {
                classUniqueCode: mapItem.UniqueCode,
                name: newName,
            })
                .then(function (response) {
                var newRecord = response.data;
                var newRecordUniqueCode = newRecord.UniqueCode;
                var treeId = newRecordUniqueCode +
                    '__' +
                    getParentTreeNodeForInsert(mapItem, $scope.selectedNodeUniqueCode);
                response.data.TreeId = treeId;
                response.data.ProfileId = mapItem.Id;
                var newNodeData = {
                    id: treeId,
                    parent: getParentTreeNodeForInsert(mapItem, $scope.selectedNodeUniqueCode),
                    text: newRecord.Name,
                    changed: 'false',
                    type: getIconName(mapItem.UniqueCode),
                };
                var newNodeId = $scope.tree.element
                    .jstree()
                    .create_node(newNodeData.parent, newNodeData);
                var parentNode = _.find($scope.treeData, function (arg) {
                    return arg.TreeId == parentNodeUniqueCode;
                });
                newRecord.ParentUniqueCode =
                    parentNodeUniqueCode == null || _.isUndefined(parentNode)
                        ? '#'
                        : parentNode.UniqueCode;
                $scope.treeData.push(response.data);
                $scope.tree.element.jstree().settings.core.data.push(newNodeData);
                if (parentNodeUniqueCode != '#') {
                    var srcUniqueCode = mapItem.IsBackLink == false ? parentNode.UniqueCode : newRecordUniqueCode;
                    var targetUniqueCode = mapItem.IsBackLink == false ? newRecordUniqueCode : parentNode.UniqueCode;
                    $http
                        .post(clientSettings.getServerInstance() + '/CimModel/CreateNewLinkInstance', {
                        linkUniqueCode: mapItem.LinkUniqueCode,
                        sourceClassInstanceUniqueCode: srcUniqueCode,
                        targetClassInstanceUniqueCode: targetUniqueCode,
                        createTransitionLinks: false,
                    })
                        .then(function (response) { }, function (response) {
                        notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
                    });
                }
                if (mapItem.UniqueCode == 'parameter' &&
                    response.config.newParameterAddress != null &&
                    response.config.newParameterAddress != undefined) {
                    $http
                        .post(clientSettings.getServerInstance() + '/CimModel/SetAttributeValue', {
                        attributeUniqueCode: 'parameter_winccoa_address',
                        classUniqueCode: newRecordUniqueCode,
                        value: response.config.newParameterAddress,
                    })
                        .then(function (response) { }, function (response) {
                        notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
                    });
                }
                if (newNodes[newNodes.length - 1].name == newRecord.Name) {
                    $scope.tree.element.jstree().deselect_all();
                    $scope.tree.element.jstree().select_node(newNodeId);
                    updateAvailableSubitemsForSelectedDictionaryItem();
                    setTimeout(function () {
                        $('#cimClassNameInput').focus();
                        $('#cimClassNameInput').select();
                    }, 300);
                }
            }, function (response) {
                notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
            });
        }
    };
    $scope.groupLinksByUniqueCode = function (links) {
        $scope.groupedLinks = [];
        $scope.groupedLinks['Один к одному'] = {};
        $scope.groupedLinks['Один ко многим'] = {};
        var groupingByType = _.groupBy(links, function (arg) {
            return arg.LinkCapacity;
        });
        $scope.groupedLinks['Один к одному'] = _.toArray(_.groupBy(groupingByType['Один к одному'], function (arg) {
            return arg.LinkUniqueCode;
        }));
        var groups = _.groupBy(groupingByType['Один ко многим'], function (arg) {
            return arg.LinkUniqueCode;
        });
        $scope.groupedLinks['Один ко многим'] = _.map(groups, function (values) {
            var valuesWithoutEmptyInstances = _.filter(values, function (arg) {
                return arg.ClassInstance != null;
            });
            return {
                Name: values[0].Name,
                LinkUniqueCode: values[0].LinkUniqueCode,
                Instances: _.map(valuesWithoutEmptyInstances, function (arg) {
                    return { ClassInstance: arg.ClassInstance, LinkInstanceUniqueCode: arg.UniqueCode };
                }),
            };
        });
    };
    $scope.deleteLink = function (item) {
        $http
            .get(clientSettings.getServerInstance() +
            '/CimModel/DeleteLinkInstance?linkUniqueCode=' +
            item.LinkInstanceUniqueCode)
            .then(function (response) {
            notificationService.showMessage(language.getElementValue('cimModelSuccessLinkDeleteMsg'));
            $scope.tree.element.jstree().deselect_all();
            $scope.tree.element.jstree().select_node($scope.selectedNodeUniqueCode);
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('cimModelServerAddressErrorMsg'));
        });
    };
    $scope.addNewLink = function (linkCapacity, linkUniqueCode, uniqueCode) {
        $http
            .get(clientSettings.getServerInstance() +
            '/CimModel/GetClassInstancesTree?linkUniqueCode=' +
            linkUniqueCode +
            '&sourceClassInstanceUniqueCode=' +
            (linkCapacity == 'Один ко многим' ? $scope.selectedNode.UniqueCode : ''))
            .then(function (response) {
            $scope.selectClassInstanceModal = $modal.open({
                templateUrl: 'ng1/dist/src/CimModel/ClassViewer/SelectClassInstanceModal.html',
                controller: 'selectClassInstanceModalCtrl',
                backdrop: 'static',
                resolve: {
                    data: function () { return response.data; },
                    language: function () { return language; },
                },
            });
            $scope.selectClassInstanceModal.result.then(function (res) {
                if (res.ok == false)
                    return;
                $http
                    .post(clientSettings.getServerInstance() + '/CimModel/UpdateLinkInstance', {
                    linkUniqueCode: linkUniqueCode,
                    sourceClassInstanceUniqueCode: $scope.selectedNode.UniqueCode,
                    oldTargetClassInstanceUniqueCode: uniqueCode,
                    targetClassInstanceUniqueCode: res.data.UniqueCode,
                })
                    .then(function (response) {
                    $scope.tree.element.jstree().deselect_all();
                    $scope.tree.element.jstree().select_node($scope.selectedNodeUniqueCode);
                    notificationService.showMessage(language.getElementValue('cimModelSuccessLinkRefrashMsg'));
                }, function (response) {
                    notificationService.errorMessage(language.getElementValue('cimModelServerAddressErrorMsg'));
                });
            }, function () { });
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    $scope.save = function () {
        var deferred = $q.defer();
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/UpdateClassInstance', {
            arg: $scope.selectedClassInstanceDto,
        })
            .then(function (response) {
            $scope.objectLinks = String.Format(language.getElementValue('cimModelObjectLinksHdr'), response.data.Name);
            $scope.tree.element.jstree().redraw_node($scope.tree.element.jstree().get_selected()[0]);
            var elementsToUpdate = _.filter($scope.treeData, function (val) {
                return val.UniqueCode == $scope.selectedClassInstanceDto.UniqueCode;
            });
            elementsToUpdate = _.map(elementsToUpdate, function (val) {
                return val.TreeId;
            });
            var treeElements = _.filter($scope.tree.element.jstree().settings.core.data, function (arg) {
                return _.contains(elementsToUpdate, arg.id);
            });
            _.each(treeElements, function (element) {
                $scope.tree.element
                    .jstree()
                    .rename_node(element.id, $scope.selectedClassInstanceDto.Name);
            });
            notificationService.showMessage(language.getElementValue('changesSuccessSaveMsg'));
            modelRequiresSaving = false;
            deferred.resolve();
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), response.data);
            deferred.reject();
        });
        return deferred.promise;
    };
    var drawTree = function () {
        var treeNodes = _.map($scope.treeData, function (arg) {
            var treeId = arg.UniqueCode + '__' + (arg.ParentUniqueCode == '' ? '#' : arg.ParentUniqueCode);
            arg.TreeId = treeId;
            var parent;
            _.each($scope.treeData, function (val) {
                if (val.UniqueCode == arg.ParentUniqueCode && !_.isUndefined(val.TreeId)) {
                    parent = val;
                }
            });
            var treeParentId = '';
            if (!_.isUndefined(parent)) {
                treeParentId = parent.TreeId;
            }
            return {
                id: treeId,
                parent: treeParentId == '' ? '#' : treeParentId,
                text: arg.Name,
                changed: 'false',
                type: getIconName(arg.ClassUniqueCode),
            };
        });
        if (treeNodes.length == 0) {
            $scope.tree.element.jstree().settings.core.data = {
                id: '1',
                text: language.getElementValue('dataDictionaryIsNoneHdr'),
            };
        }
        else {
            $scope.tree.element.jstree().settings.core.data = treeNodes;
        }
        $scope.tree.element.jstree('refresh');
    };
    $scope.deleteTreeNode = function (uniqueCodeToDelete) {
        var nodeToSelect = undefined;
        var nodesToDelete = [];
        if (_.isUndefined(uniqueCodeToDelete)) {
            uniqueCodeToDelete = $scope.selectedNodeUniqueCode;
            _.each($scope.treeData, function (val) {
                if (val.UniqueCode == $scope.selectedNode.UniqueCode) {
                    nodeToSelect = val.TreeId;
                    nodesToDelete.push(val.TreeId);
                }
            });
        }
        $scope.deleteModalWindow = $modal.open({
            templateUrl: 'ng1/dist/src/CimModel/ClassViewer/RemoveTreeNodeModal.html',
            controller: 'cimModelRemoveTreeNodeModalCtrl',
            backdrop: 'static',
        });
        $scope.deleteModalWindow.result.then(function (res) {
            if (res.ok == false)
                return;
            var nodeToDelete = _.find($scope.treeData, function (arg) {
                return arg.TreeId == uniqueCodeToDelete;
            });
            $http
                .post(clientSettings.getServerInstance() + '/CimModel/DeleteClassInstance', {
                uniqueCode: nodeToDelete.UniqueCode,
            })
                .then(function (response) {
                if (!_.isUndefined(nodeToSelect)) {
                    $scope.tree.element
                        .jstree()
                        .select_node($scope.tree.element.jstree().get_prev_dom(nodeToSelect));
                }
                _.each(nodesToDelete, function (val) {
                    $scope.tree.element.jstree().delete_node(val);
                });
                if (!_.isUndefined(nodeToSelect)) {
                    afterSelectedNodeChanged();
                }
                notificationService.showMessage(language.getElementValue('cimModelSuccessDeleteMsg'));
            }, function (response) {
                notificationService.errorMessage(language.getElementValue('cimModelFailedDeleteMsg'), response.data);
            });
        }, function () { });
    };
    $scope.copyTreeNode = function () {
        $http
            .post(clientSettings.getServerInstance() + '/CimModel/CopyClassInstance', {
            classInstanceCode: $scope.selectedNode.UniqueCode,
        })
            .then(function (response) {
            notificationService.showMessage(language.getElementValue('cimModelSuccessCopyMsg'));
            $scope.refresh($scope.dictionaryInstanceCtrl.instances.selected.Id);
        }, function (response) {
            notificationService.errorMessage(language.getElementValue('cimModelFailedCopyMsg'), response.data);
        });
    };
    watchFunctions.push($rootScope.$on('$locationChangeStart', function (event) {
        if (!modelRequiresSaving) {
            return;
        }
        var newUrl = $location.url();
        event.preventDefault();
        var modalInstance = $modal.open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
            controller: 'yesNoCancelModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                header: function () {
                    return language.getElementValue('cimModelHdr');
                },
                body: function () {
                    return language.getElementValue('saveChangesQuestionHdr');
                }
            },
        });
        modalInstance.result.then(function (data) {
            if (data === 'ok') {
                $scope.save().then(function () { return $location.url(newUrl); });
            }
            if (data === 'no') {
                modelRequiresSaving = false;
                $location.url(newUrl);
            }
        }, function () { });
    }));
    watchFunctions.push($scope.$on('$destroy', function () {
        $scope.tree.element.jstree().destroy();
        unregistrationJstreeReadyOnFunc();
        $scope.dictionaryInstanceCtrl.destroy();
        for (var i = 0; i < watchFunctions.length; i++) {
            var func = watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    }));
    $rootScope.$on('cimDictionarieListChanged', function () {
        $scope.dictionaryInstanceCtrl.loadDictionaryInstance();
    });
    $scope.dictionaryInstanceCtrl.loadDictionaryInstance();
    $('#treeContainer').css('max-height', window.innerHeight - 214 + 'px');
});
