_.mixin({
    deepclone: function (object) {
        return JSON.parse(JSON.stringify(object));
    },
    isBlank: function (string) {
        return (_.isUndefined(string) || _.isNull(string) || string.trim().length === 0)
    },
    isDefined: function (value) {
        return !_.isUndefined(value);
    },
    isUndefined: function (value) {
        return value == undefined;
    },
    // TODO: Временный костыль, пока не избавимся от механизма сравнений
    isEqual: function (object, other) {
        var countProps = function (obj) {
            var count = 0;
            for (var k in obj) {
                if (obj.hasOwnProperty(k)) {
                    count++;
                }
            }
            return count;
        };
        var objectDeletedhashKey;
        var otherDeletedhashKey;
        if (typeof (object) !== typeof (other))
            return false;
        if (typeof (object) === "function")
            return object.toString() === other.toString();
        if (object instanceof Object && other instanceof Object) {
            if ("$$hashKey" in object) {
                objectDeletedhashKey = object.$$hashKey;
                delete object.$$hashKey;
            }
            if ("$$hashKey" in other) {
                otherDeletedhashKey = other.$$hashKey;
                delete other.$$hashKey;
            }
            if (countProps(object) !== countProps(other))
                return false;
            for (var k in object) {
                if (_.isDate(object[k]) && _.isDate(other[k])) {
                    if (+object[k] !== +other[k])
                        return false;
                }
                else {
                    if (!_.isEqual(object[k], other[k]))
                        return false;
                }
            }
            if (objectDeletedhashKey != undefined) {
                object.$$hashKey = objectDeletedhashKey;
            }
            if (otherDeletedhashKey != undefined) {
                other.$$hashKey = otherDeletedhashKey;
            }
            return true;
        }
        else {
            return object === other;
        }
    }
});