// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с отчетами ТехноДок

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

#uses "Technodoc/Common/technodocNet"
#uses "Technodoc/Core/technodocAuthorization"
#uses "Technodoc/Core/technodocServerSettings"
#uses "Technodoc/Core/technodocServer"

//--------------------------------------------------------------------------------
// Variables and Constants

// API метрик
const string METRICS_API = "/metrics";

// Логирование
// Ключ для включения логов скрипта
private const string LogFlag = "LogReportsFunctions";

//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Создать отчет
  @param guid Идентификатор шаблона отчета
  @param startTimestamp Дата начала отчета
  @param endTimestamp Дата окончания отчета
*/
void createReport(string guid, time startTimestamp, time endTimestamp) {
  string activeServerUrl = getActiveServerUrl();
  string url = activeServerUrl + "/api/Report/CreateReport";

  string timePattern = "%Y.%m.%d.%H.%M.%S";

  // Если дата будет хранится в формате UTC, то заменить на formatTime
  string startTimestampArg = formatTimeUTC(timePattern, startTimestamp);
  string endTimestampArg = formatTimeUTC(timePattern, endTimestamp);

  string content = "{"
    + "templateGuid: \"" + guid + "\","
    + "startDate: \"" + startTimestampArg + "\","
    + "endDate: \"" + endTimestampArg + "\","
    + "predefinedValues: []" + ","
    + "needSave: true"
    + "}";

  string token = getAccessToken(activeServerUrl, TECHNODOC_DEFAULT_USER_LOGIN, TECHNODOC_DEFAULT_USER_PASSWORD);

  mapping response;
  mapping headers = makeMapping("Content-Type","application/json; charset=utf-8",
                                "Authorization", "Bearer " + token);

  mapping data = makeMapping("content", content,
                             "headers", headers);

  int result = technodocNetPost(url, data, response);

  if (result != 0) {
    DebugTN("Не удалось создать отчет в ПО \"ТехноДок\"."
           + " Код состояния: " + response["httpStatusCode"] + ": " + response["httpStatusText"] + "."
           + " Подробности: " + response["errorString"]);
  }
  else {
    DebugTN("Отчет с идентификатором \"" + guid + "\" за интервал" + "[" + startTimestampArg + "-" + endTimestampArg + "] успешно создан");
  }
}

/** Вернуть последние рассчитанные значения для указанного шаблона
  @param templateName Наименование шаблона
  @param parameters Список параметров
  @return Структура параметр-значение
*/
mapping getLastReportValues(string templateName, dyn_string parameters)
{
  mapping result;


  if(templateName.isEmpty())
  {
    return result;
  }

  string activeServerUrl = getActiveServerUrl();
  string metrics;

  if(activeServerUrl.isEmpty())
  {
    DebugFN(LogReportsFunctions, "Не найден активный сервер");
    return result;
  }

  // запрашиваем метрики
  if(netGet(activeServerUrl + METRICS_API, metrics) < 0)
  {
    DebugFN(LogReportsFunctions, "Не удалось получить данные с сервера: " + getLastError());
    return result;
  }

  dyn_string lines = metrics.split("\n");
  for(int i = 1; i <= lines.count(); i++)
  {
    // ищем строки для метрики последнего значения и указанного шаблона
    if(lines[i].indexOf("technodoc_report_parameter_last_value") < 0
       || lines[i].indexOf("template=\"" + templateName + "\"") < 0)
    {
      continue;
    }

    // ищем указанные параметры
    for(int j = 1; j <= parameters.count(); j++)
    {
      if(lines[i].indexOf("parameter=\"" + parameters[j] + "\"") < 0)
      {
        continue;
      }

      int endDefinitionIdx = lines[i].lastIndexOf("}");
      if(endDefinitionIdx < 0)
      {
        continue;
      }

      // Добавляем значение
      string val = lines[i].right(lines[i].length() - endDefinitionIdx - 1);
      val = val.trimmed();
      result.insert(parameters[j], val);
    }
  }

  return result;
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

