CREATE TEMPORARY TABLE RankedDevices AS
SELECT 
    Id,
    ParameterId,
    ROW_NUMBER() OVER (
        PARTITION BY ParameterId 
        ORDER BY Name ASC
    ) - 1 AS RowNum
FROM 
    OTDevices;

UPDATE OTDevices
SET "Order" = (
    SELECT RowNum
    FROM RankedDevices
    WHERE RankedDevices.Id = OTDevices.Id
);

DROP TABLE RankedDevices;
