﻿START TRANSACTION;

DROP TABLE "td"."Mails";

CREATE TABLE "td"."Mails" (
    "Id" integer NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "CreationDate"  timestamp without time zone NOT NULL,
    "SendingDate" timestamp without time zone NULL,
    "SenderAdress" text NOT NULL,
    "RecipientsAddresses" text NOT NULL,
    "Subject" text NOT NULL,
    "Body" text NULL,
    "IsSent" boolean NOT NULL, 
    CONSTRAINT "PK_Mails" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."MailAttachments" (
    "Id" integer NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "MailId" integer NOT NULL,
    "Name" text NOT NULL,
    "ContentMediaType" text NOT NULL,
    "ContentStream" bytea NOT NULL,
    CONSTRAINT "PK_MailAttachments" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_MailAttachments_Mails_MailId" FOREIGN KEY ("MailId") REFERENCES "td"."Mails" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_Mail_Id" ON "td"."Mails" ("Id");

CREATE INDEX "IX_MailAttachments_MailId" ON "td"."MailAttachments" ("MailId");

INSERT INTO "td"."__EFMigrationsHistory" ("MigrationId", "ProductVersion")
VALUES ('20220204055835_UpdateMailTable', '5.0.2');

COMMIT;