
CREATE PROCEDURE UpdateAlgorithm
    AS
BEGIN
    -- Создаем временную таблицу для хранения обновленных алгоритмов
CREATE TABLE #TempAlgorithms (Id UNIQUEIDENTIFIER, Algorithm NVARCHAR(MAX));

INSERT INTO #TempAlgorithms (Id, Algorithm)
SELECT Id, Algorithm FROM OTParameters;

-- Обрабатываем переменные
UPDATE ta
SET Algorithm = REPLACE(ta.Algorithm, ap.Name, CONCAT('%', ap.Name, '%'))
    FROM #TempAlgorithms ta
    JOIN OTAlgorithmParameters ap ON ta.Id = ap.ParameterId;

-- Обрабатываем константы
UPDATE ta
SET Algorithm = REPLACE(ta.Algorithm, ac.Name, CONCAT('%', ac.Name, '%'))
    FROM #TempAlgorithms ta
    JOIN OTAlgorithmConstants ac ON ta.Id = ac.ParameterId;

-- Обновляем основную таблицу
UPDATE p
SET p.Algorithm = ta.Algorithm
    FROM OTParameters p
    JOIN #TempAlgorithms ta ON p.Id = ta.Id;

-- Удаляем временную таблицу
DROP TABLE #TempAlgorithms;
END;

