UPDATE OTParameters
SET
    CalculationEndDate = (
        SELECT CASE
                   WHEN Value IS NULL OR Value = 'DEFAULT_VALUE' THEN NULL
                   ELSE Value
                   END
        FROM ServerSettings
        WHERE ServerSettings.Name = 'OperationTime:LastCalculationTime'
    ),
    CalculationStartDate = (
        CASE
            WHEN EXISTS (
                SELECT 1 FROM OTRecords
                                  JOIN OTDevices ON OTDevices.Id = OTRecords.DeviceId
                WHERE OTDevices.ParameterId = OTParameters.Id
            )
                THEN (
                SELECT MIN(OTRecords.TimeStamp)
                FROM OTRecords
                         JOIN OTDevices ON OTDevices.Id = OTRecords.DeviceId
                WHERE OTDevices.ParameterId = OTParameters.Id
            )
            ELSE CalculationStartDate
            END
        );
