var ReportTemplateProviderSvc = (function () {
    function ReportTemplateProviderSvc(location, $http, $q, $modal, $upload, clientSettings, reportTemplateProvider, authentication) {
        this.location = location;
        this.$http = $http;
        this.$q = $q;
        this.$modal = $modal;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.reportTemplateProvider = reportTemplateProvider;
        this.authentication = authentication;
    }
    ReportTemplateProviderSvc.prototype.changeChapterState = function (chapter) {
        chapter.isOpen = !chapter.isOpen;
    };
    ReportTemplateProviderSvc.prototype.closeChapters = function (chapters) {
        _.forEach(chapters, function (chapter) {
            chapter.isOpen = false;
        });
    };
    ReportTemplateProviderSvc.prototype.groupReportTemplateByChapters = function (reportTemplatesShortInfo) {
        var reportGroupByChapter = _.groupBy(reportTemplatesShortInfo, function (item) {
            return item.chapter;
        });
        var reportChapters = [];
        for (var key in reportGroupByChapter) {
            reportChapters.push({
                name: key,
                templates: reportGroupByChapter[key],
                ident: key.replace(' ', '_'),
                isOpen: true,
            });
        }
        return reportChapters;
    };
    ReportTemplateProviderSvc.prototype.isReportTemplateVisible = function (reportTemplate) {
        return !reportTemplate.isHide
            && this.checkViewReportPermission(reportTemplate.uniqueGuid);
    };
    ReportTemplateProviderSvc.prototype.importReportTemplates = function (templatesFile, currentTemplatesCount) {
        var _this = this;
        var deferred = this.$q.defer();
        if (_.isUndefined(templatesFile) || !_.any(templatesFile))
            deferred.resolve([]);
        this.$upload
            .upload({
            url: this.clientSettings.getServerInstance() + '/ReportTemplate/GetReportTemplatesImportInfo',
            file: templatesFile,
        })
            .then(function (response) {
            _this.getReportImportTemplatesModal(response.data, currentTemplatesCount).result.then(function (reportTemplateImportInfo) {
                if (reportTemplateImportInfo.length === 0) {
                    deferred.resolve([]);
                    return;
                }
                _this.$upload
                    .upload({
                    url: _this.clientSettings.getServerInstance() + '/ReportTemplate/ImportReportTemplates',
                    file: templatesFile,
                    data: JSON.stringify(reportTemplateImportInfo),
                })
                    .then(function (response) {
                    _this.authentication.updatePermissions();
                    deferred.resolve(response.data);
                }, function (response) {
                    deferred.reject(response);
                });
            }, function () { });
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplateProviderSvc.prototype.importDemoReportTemplates = function (currentTemplatesCount) {
        var _this = this;
        var deferred = this.$q.defer();
        this.reportTemplateProvider.getDemoReportTemplatesImportInfo()
            .then(function (shortInfo) {
            _this.getReportImportTemplatesModal(shortInfo, currentTemplatesCount).result
                .then(function (selectedTemplatesToImport) {
                _this.$http
                    .post(_this.clientSettings.getServerInstance() + '/ReportTemplate/ImportDemoReportTemplates', {
                    reportTemplateShortImportInfo: selectedTemplatesToImport
                })
                    .then(function (response) {
                    _this.authentication.updatePermissions();
                    deferred.resolve(response.data);
                }, function (data) {
                    deferred.reject(data);
                });
            }, function () { });
        }, function (data) {
            deferred.reject(data);
        });
        return deferred.promise;
    };
    ReportTemplateProviderSvc.prototype.getReportImportTemplatesModal = function (reportTemplatesImportInfo, currentTemplatesCount) {
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/InformationImportingReportTemplates.html',
            controller: 'informationImportingReportTemplatesModalCtrl as ctrl',
            backdrop: 'static',
            resolve: {
                reportTemplates: function () {
                    return reportTemplatesImportInfo;
                },
                totalTemplatesCount: function () {
                    return currentTemplatesCount;
                },
            },
        });
    };
    ReportTemplateProviderSvc.prototype.getCurrentReportUniqueGuid = function () {
        return this.location.search().templateGuid;
    };
    ReportTemplateProviderSvc.prototype.checkViewReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportView_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkViewCurrentReportPermission = function () {
        return this.checkViewReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkEditReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportEdit_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkEditCurrentReportPermission = function () {
        return this.checkEditReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkDeleteReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportDelete_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkDeleteCurrentReportPermission = function () {
        return this.checkDeleteReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkCreateReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportCreate_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkCreateCurrentReportPermission = function () {
        return this.checkCreateReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkRecreateReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportRecreate_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkRecreateCurrentReportPermission = function () {
        return this.checkRecreateReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkManualSendingReportByMailPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportSendingReportByMail_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkManualSendingCurrentReportByMailPermission = function () {
        return this.checkManualSendingReportByMailPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkExportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportExport_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkExportReportPermission = function () {
        return this.checkExportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkViewManualEditsPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportViewManualEdits_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkViewManualEditsReportPermission = function () {
        return this.checkViewManualEditsPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkPrintPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportPrint_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkPrintReportPermission = function () {
        return this.checkPrintPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkViewInfoPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportViewInfo_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkViewInfoReportPermission = function () {
        return this.checkViewInfoPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkViewRulesPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportViewRules_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkViewRulesReportPermission = function () {
        return this.checkViewRulesPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.prototype.checkLockReportPermission = function (uniqueGuid) {
        return this.authentication.hasPermission('ReportLock_'.concat(uniqueGuid));
    };
    ReportTemplateProviderSvc.prototype.checkLockReportCurrentReportPermisson = function () {
        return this.checkLockReportPermission(this.getCurrentReportUniqueGuid());
    };
    ReportTemplateProviderSvc.$inject = [
        '$location',
        '$http',
        '$q',
        '$modal',
        '$upload',
        'clientSettings',
        'reportTemplateProvider',
        'authentication',
    ];
    return ReportTemplateProviderSvc;
}());
angular.module('kamhpp').service('reportTemplateService', ReportTemplateProviderSvc);
