var _this = this;
var SmsTreeCheckBox = (function () {
    function SmsTreeCheckBox(visible, three_state, whole_node, keep_selected_style, cascade, tie_selection, cascade_to_disabled, cascade_to_hidden) {
        this.visible = visible;
        this.three_state = three_state;
        this.whole_node = whole_node;
        this.keep_selected_style = keep_selected_style;
        this.cascade = cascade;
        this.tie_selection = tie_selection;
        this.cascade_to_disabled = cascade_to_disabled;
        this.cascade_to_hidden = cascade_to_hidden;
    }
    return SmsTreeCheckBox;
}());
var SmsTree = (function () {
    function SmsTree() {
    }
    return SmsTree;
}());
var SmsTreeSettings = (function () {
    function SmsTreeSettings(columns, startingData, themes, types, plugins, expandLevel, contextMenu, multiple, checkbox, search, massload, state, worker, sort) {
        if (search === void 0) { search = {}; }
        if (massload === void 0) { massload = {}; }
        if (state === void 0) { state = {}; }
        if (worker === void 0) { worker = true; }
        if (sort === void 0) { sort = null; }
        this.columns = columns;
        this.startingData = startingData;
        this.themes = themes;
        this.types = types;
        this.plugins = plugins;
        this.expandLevel = expandLevel;
        this.contextMenu = contextMenu;
        this.multiple = multiple;
        this.checkbox = checkbox;
        this.search = search;
        this.massload = massload;
        this.worker = worker;
        this.state = state;
        this.sort = sort;
    }
    return SmsTreeSettings;
}());
var SmsTreeDataItemAttr = (function () {
    function SmsTreeDataItemAttr(title, href) {
        this.title = title;
        this.href = href;
    }
    return SmsTreeDataItemAttr;
}());
var SmsTreeDataItem = (function () {
    function SmsTreeDataItem(id, text, type, parent, a_attr) {
        this.id = id;
        this.text = text;
        this.type = type;
        this.parent = parent;
        this.a_attr = a_attr;
    }
    return SmsTreeDataItem;
}());
var SmsTreeColumn = (function () {
    function SmsTreeColumn(header, value) {
        this.header = header;
        this.value = value;
    }
    return SmsTreeColumn;
}());
var SmsTypes = (function () {
    function SmsTypes(noneIcon, folderIcon, fileIcon, errorFolderIcon, errorFileIcon) {
        this.none = { icon: noneIcon };
        this.folder = { icon: folderIcon };
        this.file = { icon: fileIcon };
        this.errorfolder = { icon: errorFolderIcon };
        this.errorfile = { icon: errorFileIcon };
        this['#'] = {};
        this.default = {};
    }
    return SmsTypes;
}());
var SmsTreeContextMenu = (function () {
    function SmsTreeContextMenu(items) {
        this.items = items;
    }
    return SmsTreeContextMenu;
}());
app.directive('smsTree', function ($rootScope, $controller, language) {
    return {
        restrict: 'EA',
        scope: {
            tree: '=',
            columns: '=?',
            grid: '=?',
            startingData: '=?',
            themes: '=?',
            types: '=?',
            plugins: '=?',
            state: '=?',
            expandLevel: '=?',
            contextMenu: '=?',
            multiple: '=?',
            checkbox: '=?',
            search: '=?',
            massload: '=?',
            worker: '=?'
        },
        link: function (scope, element) {
            angular.extend(_this, $controller('BaseController', { $scope: scope }));
            var defaultSettings = new SmsTreeSettings([new SmsTreeColumn(language.getElementValue('titleHdr'))], new SmsTreeDataItem('1', language.getElementValue('smsTreeMustLoadTreeHdr'), 'none'), $.jstree.defaults.core.themes, new SmsTypes('glyphicon glyphicon-none', 'jstree-folder', 'jstree-file', 'fa fa-exclamation-triangle', 'fa fa-exclamation-triangle'), ['types', 'wholerow', 'grid'], 0, null, true, new SmsTreeCheckBox(true, true, true, true, 'undetermined', true, true, true), {}, {}, {}, true, function (node, other) {
                return element.jstree().get_text(node).toLowerCase() >
                    element.jstree().get_text(other).toLowerCase()
                    ? 1
                    : -1;
            });
            scope.tree.element = element;
            element.jstree({
                core: {
                    animation: 0,
                    multiple: scope.multiple == undefined
                        ? defaultSettings.multiple
                        : scope.multiple,
                    data: scope.startingData == undefined
                        ? defaultSettings.startingData
                        : scope.startingData,
                    themes: scope.themes == undefined
                        ? defaultSettings.themes
                        : scope.themes,
                    check_callback: true,
                    strings: { 'Loading ...': language.getElementValue('smsTreeLoadHdr') },
                    worker: _.isUndefined(scope.worker)
                        ? defaultSettings.worker
                        : scope.worker
                },
                grid: _.isUndefined(scope.grid)
                    ? {
                        columns: _.isUndefined(scope.columns)
                            ? defaultSettings.columns
                            : scope.columns
                    }
                    : scope.grid,
                types: _.isUndefined(scope.types)
                    ? defaultSettings.types
                    : scope.types,
                plugins: _.isUndefined(scope.plugins)
                    ? defaultSettings.plugins
                    : scope.plugins,
                contextmenu: _.isUndefined(scope.contextMenu)
                    ? defaultSettings.contextMenu
                    : scope.contextMenu,
                checkbox: _.isUndefined(scope.checkbox)
                    ? defaultSettings.checkbox
                    : scope.checkbox,
                search: _.isUndefined(scope.search)
                    ? defaultSettings.search
                    : scope.search,
                massload: _.isUndefined(scope.massload)
                    ? defaultSettings.massload
                    : scope.massload,
                sort: _.isUndefined(scope.sort)
                    ? defaultSettings.sort
                    : scope.sort,
                state: _.isUndefined(scope.state)
                    ? defaultSettings.state
                    : scope.state,
            });
            element.on('changed.jstree', function (event, data) {
                scope.tree.selectedElements = data.selected;
                scope.safeApply(function () { });
                $rootScope.$broadcast('jstreeChanged', data);
            });
            element.on('refresh.jstree', function (event) {
                element.jstree().deselect_all(true);
                element.jstree('close_all');
                var level = _.isUndefined(scope.expandLevel)
                    ? defaultSettings.expandLevel
                    : scope.expandLevel;
                for (var i = 1; i < level; i++) {
                    element.find('[aria-level=' + i + ']').each(function (idx, arg) {
                        element.jstree().open_node(arg, function () { }, false);
                    });
                }
                $rootScope.$broadcast('jstreeRefresh', event.target.getAttribute('id'));
            });
            element.on('ready.jstree', function (event, data) {
                $rootScope.$broadcast('jstreeReady', event.target.getAttribute('id'), data);
            });
            element.on('load_node.jstree', function (event, data) {
                $rootScope.$broadcast('jstreeLoadNode', data.node);
            });
            element.on('select_node.jstree', function (event, data) {
                $rootScope.$broadcast('jstreeSelectNode', data.node, data.event);
            });
            element.on('search.jstree', function (event, nodes) {
                $rootScope.$broadcast('jstreeSearchIsOver');
            });
            element.on('state_ready.jstree', function (event, data) {
                $rootScope.$broadcast('jstreeStateReady', event, data);
            });
            element.on('open_all.jstree', function (event, data) {
                $rootScope.$broadcast('jstreeOpenAll', event, data);
            });
            element.on('hover_node.jstree', function (event) {
                $rootScope.$broadcast('jstreeHoverNode');
            });
        },
    };
});
