app.directive('smsReportLogValue', function ($rootScope, $compile, reportSigningChecker, reportTemplateService) {
    return {
        restrict: 'EA',
        priority: 1000,
        scope: {
            value: '=',
            field: '=',
            onchange: '&',
            rows: '=',
        },
        link: function (scope, element, attrs) {
            var inputIndex = 2;
            scope.reportSigningChecker = reportSigningChecker;
            scope.inputVisible = false;
            var canEditValue = function () {
                return reportTemplateService.checkEditCurrentReportPermission();
            };
            scope.onValueClick = function () {
                if (scope.reportSigningChecker.checkReportSigning()) {
                    return;
                }
                if (!canEditValue())
                    return;
                $rootScope.$broadcast('reportValueStartEdit');
                $(scope.element[inputIndex]).attr('size', $(scope.element[inputIndex]).val().length);
                scope.inputVisible = true;
                scope.lastValue = scope.value;
                if (scope.inputVisible) {
                    setTimeout(function () {
                        scope.element[inputIndex].focus();
                    }, 200);
                }
            };
            scope.lostFocus = function () {
                scope.inputVisible = false;
            };
            var cursorStyle = canEditValue() ? 'cursor: pointer' : 'cursor: default';
            var template = '';
            switch (scope.field.type) {
                case 'double':
                    template =
                        "<div style='".concat(cursorStyle, "; padding: 3px; display: inline;' ng-hide='inputVisible' ng-click='onValueClick()'>{{value}}</div>\n                            <input input-float type='text' style='text-align: center;' ng-show='inputVisible' ng-blur='lostFocus()' ng-model='value' />");
                    break;
                case 'time':
                    template =
                        "<div style='".concat(cursorStyle, "; padding: 3px; display: inline;' ng-hide='inputVisible' ng-click='onValueClick()'>{{value}}</div>\n                            <input input-time type='text' style='text-align: center;' ng-show='inputVisible' ng-blur='lostFocus()' ng-model='value' />");
                    break;
                case 'timespan':
                    template =
                        "<div style='".concat(cursorStyle, "; padding: 3px; display: inline;' ng-hide='inputVisible' ng-click='onValueClick()'>{{value}}</div>\n                            <input input-time-span type='text' style='text-align: center;' ng-show='inputVisible' ng-blur='lostFocus()' ng-model='value' />");
                    break;
                case 'dropdown':
                    template =
                        "<ui-select \n                                style=\"width: inherit\"\n                                ng-model=\"$parent.value\" \n                                append-to-body=\"true\"\n                                ng-disabled=\"reportSigningChecker.checkReportSigning()\">\n                                <ui-select-match placeholder=\"{{ 'selectDropdownElementPch' | lng }}\">{{ value }}</ui-select-match>\n                                <ui-select-choices \n                                    repeat=\"option in field.additionalSettings | filter: $select.search\">\n                                    <small>{{option}}</small>\n                                </ui-select-choices>\n                            </ui-select>";
                    break;
                case 'datetime':
                    if (_.isDefined(scope.value)) {
                        scope.value = scope.value.getTime
                            ? new Date(scope.value.getTime())
                            : Date.fromSMSExternalFormat(scope.value);
                    }
                    template =
                        "<date-time-picker date=\"value\"></date-time-picker>";
                    break;
                default:
                    template =
                        "<div style='".concat(cursorStyle, "; padding: 3px; display: inline;' ng-hide='inputVisible' ng-click='onValueClick()'>{{value}}</div>\n                            <input type='text' style='text-align: inherit; width: 100%;' ng-show='inputVisible' ng-blur='lostFocus()' ng-model='value' />");
                    break;
            }
            var t = angular.element($compile(template)(scope));
            scope.element = t;
            $(t[inputIndex]).bind('keydown keypress', function (event) {
                if (event.which === 13) {
                    scope.lostFocus();
                    scope.inputVisible = false;
                    scope.$apply();
                    event.preventDefault();
                }
                if (event.which === 27) {
                    scope.inputVisible = false;
                    scope.value = scope.lastValue;
                    scope.$apply();
                    event.preventDefault();
                }
            });
            element.replaceWith(t);
            var watchValuechangeUnreg = scope.$watch(function () {
                return scope.value;
            }, function (after, before) {
                if (after === before) {
                    return;
                }
                scope.onchange();
            }, true);
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                watchValuechangeUnreg();
                unregistrationDestroyFunc();
            });
        },
    };
});
