var PredefinedValuesComponent = (function () {
    function PredefinedValuesComponent() {
        this.bindings = {
            start: '<',
            stop: '<',
            templateName: '<',
            templateGuid: '<',
            templateStep: '<',
            reportType: '<',
            precalculatedParameters: '<',
            userDefinedParameters: '<',
            isScrollable: '<?',
            isDisabled: '<?',
            onChange: '&?',
        };
        this.templateUrl = 'ng1/dist/src/UserDocuments/PredefinedParameters/PredefinedParameters.html';
        this.controller = PredefinedValuesComponentController;
    }
    return PredefinedValuesComponent;
}());
var PredefinedValuesComponentController = (function () {
    function PredefinedValuesComponentController(http, clientSettings, notificationService, language) {
        this.http = http;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.language = language;
        this.precalculatedParameters = [];
        this.userDefinedParameters = [];
        this.loadingData = false;
        this.isScrollable = true;
    }
    PredefinedValuesComponentController.prototype.$onChanges = function (onChangesObj) {
        var _this = this;
        if (!_.any(onChangesObj, function (obj, key) { return key !== 'start' && key !== 'stop'; })) {
            return;
        }
        this.loadingData = true;
        var parameters = _.filter(this.precalculatedParameters, function (parameter) {
            return !_.any(_this.userDefinedParameters, function (userParameter) { return userParameter.parameter.Ident === parameter.parameter.Ident; });
        });
        this.calcParametersValues(parameters);
    };
    PredefinedValuesComponentController.prototype.predefinedFilter = function (parameterInfo) {
        return parameterInfo.parameter.Predefined;
    };
    PredefinedValuesComponentController.prototype.onManualChange = function (changedParameterInfo) {
        if (_.isDefined(changedParameterInfo.value)) {
            changedParameterInfo.value.status = 2;
            changedParameterInfo.value.markWithoutErrors();
        }
        this.userDefinedParameters = _.filter(this.userDefinedParameters, function (param) { return param.parameter.Ident !== changedParameterInfo.parameter.Ident; });
        var dependentParameters = _.filter(this.precalculatedParameters, function (parameter) {
            return (parameter.dependsOn(changedParameterInfo) &&
                (parameter.parameter.ParameterType === 'DropDownValue' ||
                    parameter.value.status !== 2));
        });
        if (_.any(dependentParameters)) {
            this.calcParametersValues(dependentParameters);
        }
        this.onChange && this.onChange();
    };
    PredefinedValuesComponentController.prototype.isStringType = function (parameter) {
        return (parameter.ParameterType === 'string' || parameter.ParameterType === 'string?');
    };
    PredefinedValuesComponentController.prototype.isUserFileType = function (parameter) {
        return parameter.ParameterType === 'ReportFileValue';
    };
    PredefinedValuesComponentController.prototype.isDateTimeType = function (parameter) {
        return parameter.ParameterType === 'DateTime';
    };
    PredefinedValuesComponentController.prototype.isNumericType = function (parameter) {
        return (parameter.ParameterType === 'double' ||
            parameter.ParameterType === 'double?' ||
            parameter.ParameterType === 'int' ||
            parameter.ParameterType === 'int?');
    };
    PredefinedValuesComponentController.prototype.isDropdown = function (parameter) {
        return parameter.ParameterType === 'DropDownValue';
    };
    PredefinedValuesComponentController.prototype.calcParametersValues = function (parameters) {
        var _this = this;
        var dependencyParametersInfo = _.filter(this.precalculatedParameters, function (item) {
            return (_.any(parameters, function (parameter) {
                return parameter.dependsOn(item);
            }) &&
                !_.any(parameters, function (parameter) {
                    return parameter.parameter.Ident === item.parameter.Ident;
                }));
        });
        var data = {
            templateName: this.templateName,
            templateStep: this.templateStep,
            interval: _.isUndefined(this.start) && _.isUndefined(this.stop)
                ? null
                : {
                    start: this.start,
                    stop: this.reportType === 1
                        ? this.stop
                        : this.start,
                },
            parameters: _.map(parameters.concat(dependencyParametersInfo), function (parameterInfo) {
                return parameterInfo.parameter;
            }),
            dependencyParametersDefaultValues: _.map(dependencyParametersInfo, function (parameterValueInfo) {
                if (parameterValueInfo.parameter.ParameterType === 'DropDown'
                    && parameterValueInfo.parameter.Dropdown.canMultipleSelect) {
                    parameterValueInfo.value.value = JSON.stringify(parameterValueInfo.value.value);
                }
                return new ParameterValueWithStatus(parameterValueInfo.parameter.Ident, parameterValueInfo.value, parameterValueInfo.parameter.ParameterType);
            }),
            templateGuid: this.templateGuid,
        };
        this.http
            .post(this.clientSettings.getServerInstance() + '/ReportCalculation/CalculateParametersValues', data)
            .then(function (response) {
            _.forEach(_this.precalculatedParameters, function (predefinedValue) {
                var calculatedParameterValueWithStatus = _.find(response.data, function (item) {
                    return item.parameterIdent === predefinedValue.parameter.Ident;
                });
                if (_.isDefined(calculatedParameterValueWithStatus) &&
                    _.isDefined(calculatedParameterValueWithStatus.value)) {
                    _.extend(predefinedValue.value, calculatedParameterValueWithStatus.value);
                }
            });
            _this.onChange && _this.onChange();
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('predefinedParamValueCalcErrorMsg'), error);
        })
            .finally(function () {
            _this.loadingData = false;
        });
    };
    PredefinedValuesComponentController.$inject = ['$http', 'clientSettings', 'notificationService', 'language'];
    return PredefinedValuesComponentController;
}());
angular.module('kamhpp').component('predefinedParametersValues', new PredefinedValuesComponent());
