var DropDownVariant = (function () {
    function DropDownVariant(ident, name, isSelected) {
        this.Ident = ident;
        this.Name = name;
        this.IsSelected = isSelected;
    }
    return DropDownVariant;
}());
var DropDownValue = (function () {
    function DropDownValue(variations, canMultipleSelect, defaultValue) {
        this.Variants = _.map(JSON.parse(variations), function (item) {
            return new DropDownVariant(item, item, item === defaultValue);
        });
        this.CanMultipleSelect = canMultipleSelect;
    }
    return DropDownValue;
}());
var PredefinedDropDownValueComponent = (function () {
    function PredefinedDropDownValueComponent() {
        this.bindings = {
            value: '<',
            variants: '<',
            isMultipleChoice: '<',
            onChanged: '&',
            isDisabled: '<?'
        };
        this.templateUrl = 'ng1/dist/src/UserDocuments/PredefinedParameters/DropDownValue/PredefinedDropDownValue.html';
        this.controller = PredefinedDropDownValueComponentController;
    }
    return PredefinedDropDownValueComponent;
}());
var PredefinedDropDownValueComponentController = (function () {
    function PredefinedDropDownValueComponentController() {
    }
    PredefinedDropDownValueComponentController.prototype.$onChanges = function (onChangesObj) {
        if (onChangesObj.variants && onChangesObj.variants.currentValue) {
            this.dropDownValue = { selected: null };
            var selectedValues = _.filter(onChangesObj.variants.currentValue, function (variant) { return variant.IsSelected; });
            if (_.any(selectedValues)) {
                this.dropDownValue.selected = this.isMultipleChoice
                    ? _.map(selectedValues, function (variant) { return variant.Ident; })
                    : _.map(selectedValues, function (variant) { return variant.Ident; })[0];
            }
        }
    };
    PredefinedDropDownValueComponentController.prototype.$onInit = function () {
        this.dropDownValue = { selected: null };
        if (this.value.value.value && this.value.value.value.Variants) {
            var selectedValues = _.filter(this.value.value.value.Variants, function (variant) { return variant.IsSelected; });
            if (_.any(selectedValues)) {
                this.dropDownValue.selected = this.isMultipleChoice
                    ? _.map(selectedValues, function (variant) { return variant.Ident; })
                    : _.map(selectedValues, function (variant) { return variant.Ident; })[0];
            }
        }
    };
    PredefinedDropDownValueComponentController.prototype.onSelected = function () {
        this.updateSelectedVariants();
        this.onChanged({ change: this.value });
    };
    PredefinedDropDownValueComponentController.prototype.onRemoved = function () {
        this.updateSelectedVariants();
        this.onChanged({ change: this.value });
    };
    PredefinedDropDownValueComponentController.prototype.updateSelectedVariants = function () {
        var _this = this;
        if (!this.dropDownValue.selected) {
            return {};
        }
        if (!this.isMultipleChoice) {
            _.forEach(this.value.value.value.Variants, function (variant) {
                variant.IsSelected = variant.Ident === _this.dropDownValue.selected;
            });
            return;
        }
        _.forEach(this.value.value.value.Variants, function (variant) {
            variant.IsSelected = _.any(_this.dropDownValue.selected, function (v) { return v === variant.Ident; });
        });
    };
    return PredefinedDropDownValueComponentController;
}());
angular.module('kamhpp').component('predefinedDropDownParameter', new PredefinedDropDownValueComponent());
