var ReportTemplateChapterInfo = (function () {
    function ReportTemplateChapterInfo(reportTemplateChapters) {
        this.chapters = reportTemplateChapters !== null && reportTemplateChapters !== void 0 ? reportTemplateChapters : [];
    }
    Object.defineProperty(ReportTemplateChapterInfo.prototype, "chapters", {
        get: function () {
            return this._reportTemplateChapters;
        },
        set: function (value) {
            this._reportTemplateChapters = value;
            this._reportTemplateNames = _.map(value, function (c) { return c.name; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ReportTemplateChapterInfo.prototype, "chapterNames", {
        get: function () {
            return this._reportTemplateNames;
        },
        enumerable: false,
        configurable: true
    });
    return ReportTemplateChapterInfo;
}());
var CheckResult = (function () {
    function CheckResult(result, notification) {
        this.result = result;
        this.notification = notification;
    }
    return CheckResult;
}());
var ReportTemplatesManagementCtrl = (function () {
    function ReportTemplatesManagementCtrl($rootScope, $scope, $http, $modal, $location, $upload, $window, $modalStack, $q, notificationService, clientSettings, guid, authentication, reportTemplateService, reportTemplateProvider, licenseProvider, language, mailValidationService, mailProvider, userPreferencesService, exportService, printProvider, smsTemplateEditorConfiguration) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$http = $http;
        this.$modal = $modal;
        this.$location = $location;
        this.$upload = $upload;
        this.$window = $window;
        this.$modalStack = $modalStack;
        this.$q = $q;
        this.notificationService = notificationService;
        this.clientSettings = clientSettings;
        this.guid = guid;
        this.authentication = authentication;
        this.reportTemplateService = reportTemplateService;
        this.reportTemplateProvider = reportTemplateProvider;
        this.licenseProvider = licenseProvider;
        this.language = language;
        this.mailValidationService = mailValidationService;
        this.mailProvider = mailProvider;
        this.userPreferencesService = userPreferencesService;
        this.exportService = exportService;
        this.printProvider = printProvider;
        this.smsTemplateEditorConfiguration = smsTemplateEditorConfiguration;
        this.searchTemplate = { name: '' };
        this.onSaveConfirmed = function (reportTemplate) {
            var index = _.findIndex(_this.$scope.templates, function (template) { return template.uniqueGuid === reportTemplate.UniqueGuid; });
            _this.$scope.templates[index] = new ReportTemplateInfo(reportTemplate);
            _this.$scope.reportTemplateChapterInfo.chapters = _this.reportTemplateService.groupReportTemplateByChapters(_this.$scope.templates);
        };
        this.insertTemplateInfo = function (template) {
            var reportTemplateInfo = new ReportTemplateInfo(template);
            _this.$scope.templates.push(reportTemplateInfo);
            _this.$scope.reportTemplateChapterInfo.chapters = _this.reportTemplateService.groupReportTemplateByChapters(_this.$scope.templates);
            _this.authentication.updatePermissions();
            _this.$scope.setSelectedTemplate(reportTemplateInfo);
        };
        this.showCreateModalInstance = function () {
            var userPrefernces = _this.userPreferencesService.getPreferences();
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/UserDocuments/Administration/ReportTemplateModalInstance.html',
                controller: 'createReportTemplateModalCtrl',
                backdrop: 'static',
                resolve: {
                    reportTemplates: function () {
                        return _this.$scope.templates;
                    },
                    reportChapters: function () {
                        return _this.$scope.reportTemplateChapterInfo.chapterNames;
                    },
                    chapterName: function () {
                        var _a;
                        return ((_a = userPrefernces.report.reportTemplateChapter) !== null && _a !== void 0 ? _a : _this.getTemplateUniqueName(_this.language.getElementValue('reportsWithoutSectionHdr')));
                    },
                    name: function () {
                        return _this.getTemplateUniqueName(_this.language.getElementValue('reportNewTemplateHdr'));
                    },
                },
            })
                .result.then(function (data) {
                userPrefernces.report.reportTemplateChapter = data.chapter;
                _this.userPreferencesService.setPreferences(userPrefernces);
                _this.$http
                    .post(_this.clientSettings.getServerInstance() + '/ReportTemplate/CreateReportTemplate', data)
                    .then(function (response) {
                    var template = new ReportTemplate(_this.$scope, response.data, _this.notificationService, _this.language, _this.$http, _this.clientSettings, _this.reportTemplateProvider, _this.$modal, _this.mailValidationService, _this.mailProvider, _this.userPreferencesService, _this.printProvider);
                    _this.insertTemplateInfo(template);
                }, function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
                });
            }, function () { });
        };
        this.onNeedSave = function (template) {
            _this.$scope.editorCtrlApi.onNeedSave(template);
        };
        $scope.selfScope = $scope;
        var watchFunctions = [];
        $scope.reportTemplateService = reportTemplateService;
        $scope.administrationProvider = licenseProvider;
        $scope.reportTemplateChapterInfo = new ReportTemplateChapterInfo();
        $scope.templates = [];
        $scope.templateUniqGuid = $location.search().uniqueGuid;
        $scope.isTemplatesSidebarOpened = true;
        $scope.toogleSidebar = function () {
            $scope.isTemplatesSidebarOpened = !$scope.isTemplatesSidebarOpened;
        };
        $scope.createTemplate = function () {
            _this.licenseProvider
                .getLicense()
                .then(function (license) {
                if (_.isDefined(license.modules.reports.templatesCount) && $scope.templates.length >= license.modules.reports.templatesCount) {
                    notificationService.errorMessage(String.Format(language.getElementValue('reportWorkTemlatesAvalibleInLicenseMsg'), license.modules.reports.templatesCount.toString()));
                    return;
                }
                if (_.isUndefined($scope.selectedTemplate) || !$scope.selectedTemplate.isChanged) {
                    _this.showCreateModalInstance();
                }
                else {
                    _this.getSaveTemplateModalInstance().result.then(function (data) {
                        if (data === 'ok') {
                            _this.onNeedSave($scope.selectedTemplate);
                            _this.showCreateModalInstance();
                        }
                        if (data === 'no') {
                            _this.showCreateModalInstance();
                        }
                        if (data === 'cancel') {
                            return;
                        }
                    });
                }
            })
                .catch(function (error) {
                notificationService.errorMessage(_this.language.getElementValue('licenseNotFoundMsg'), error);
            });
        };
        $scope.copyTemplate = function () {
            _this.licenseProvider
                .getLicense()
                .then(function (license) {
                if (_.isDefined(license.modules.reports.templatesCount) && $scope.templates.length >= license.modules.reports.templatesCount) {
                    notificationService.errorMessage(String.Format(language.getElementValue('reportWorkTemlatesAvalibleInLicenseMsg'), license.modules.reports.templatesCount.toString()));
                    return;
                }
                if ($scope.selectedTemplate.isChanged) {
                    _this.getSaveTemplateModalInstance().result.then(function (data) {
                        if (data === 'cancel') {
                            return;
                        }
                        if (data === 'ok') {
                            _this.onNeedSave($scope.selectedTemplate);
                        }
                        if (data === 'no') {
                            _this.$scope.selectedTemplate.isChanged = false;
                        }
                        _this.createCopyOfSelectedTemplate();
                    });
                }
                else {
                    _this.createCopyOfSelectedTemplate();
                }
            })
                .catch(function (error) {
                notificationService.errorMessage(_this.language.getElementValue('licenseNotFoundMsg'), error);
                return;
            });
        };
        $scope.deleteTemplate = function () {
            if (_.isUndefined($scope.selectedTemplate))
                return;
            $modal
                .open({
                templateUrl: 'ng1/dist/src/UserDocuments/Administration/DeleteReportTemplateModal.html',
                controller: 'deleteReportTemplateModalCtrl',
                backdrop: 'static',
                resolve: {
                    name: function () {
                        return $scope.selectedTemplate.Name;
                    },
                },
            })
                .result.then(function (data) {
                if (!data)
                    return;
                $scope.selectedTemplate.isChanged = false;
                var reportTemplateInfo = {
                    id: $scope.selectedTemplate.Id,
                    uniqueGuid: $scope.selectedTemplate.UniqueGuid,
                    name: $scope.selectedTemplate.Name,
                };
                reportTemplateProvider.deleteReportTemplate(reportTemplateInfo).then(function () {
                    _this.authentication.updatePermissions();
                    _this.deleteTemplateInfo($scope.selectedTemplate);
                }, function (arg) {
                    notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), arg);
                });
            });
        };
        $scope.templateIsSelected = function (template) {
            var _a;
            return template.uniqueGuid === ((_a = $scope.selectedTemplate) === null || _a === void 0 ? void 0 : _a.UniqueGuid);
        };
        $scope.setSelectedTemplate = function (info) {
            var before = $scope.selectedTemplate;
            if (_.isUndefined(info)) {
                $scope.selectedTemplate = undefined;
                return;
            }
            _this.getLastVersionReportTemplate(info.uniqueGuid).then(function (data) {
                var after = new ReportTemplate($scope, data, notificationService, language, $http, clientSettings, reportTemplateProvider, $modal, mailValidationService, mailProvider, userPreferencesService, printProvider);
                _this.selectTemplate(after, before);
            }, function (data) {
                notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data);
            });
        };
        watchFunctions.push(this.$rootScope.$on('$locationChangeStart', function (event) {
            var newUrl = $location.url();
            if (_.isUndefined($scope.selectedTemplate) || !$scope.selectedTemplate.isChanged) {
                _this.$modalStack.dismissAll();
                return;
            }
            _this.getSaveTemplateModalInstance().result.then(function (data) {
                if (data === 'ok') {
                    _this.onNeedSave($scope.selectedTemplate);
                    _this.$modalStack.dismissAll();
                    $scope.selectedTemplate = undefined;
                    $location.url(newUrl);
                }
                if (data === 'no') {
                    _this.$modalStack.dismissAll();
                    $scope.selectedTemplate = undefined;
                    $location.url(newUrl);
                }
            });
            event.preventDefault();
        }));
        $scope.exportReportTemplates = function () {
            $modal.open({
                templateUrl: 'ng1/dist/src/UserDocuments/InformationExportingReportTemplates.html',
                controller: 'informationExportingReportTemplatesModalCtrl as ctrl',
                backdrop: 'static',
                resolve: {
                    reportTemplates: function () {
                        return $scope.templates;
                    }
                }
            }).result.then(function (ids) {
                var url = '/ReportTemplate/ExportReportTemplates';
                url += '?templateIds=' + ids.toString();
                _this.exportService.export(url);
            }, function () { });
        };
        this.$window.onbeforeunload = function (event) {
            var message = undefined;
            if ($scope.selectedTemplate !== undefined && $scope.selectedTemplate.isChanged) {
                message = language.getElementValue('changesNoSaveMsg');
            }
            if (typeof event === 'undefined') {
                event = window.event;
            }
            if (_.isDefined(event) && _.isDefined(message)) {
                event.returnValue = message;
                return message;
            }
            return undefined;
        };
        var searchObject = this.$location.search();
        this.reportTemplateProvider
            .getAllReportTemplatesShortInfo()
            .then(function (reportTemplates) {
            _this.$scope.reportTemplateChapterInfo.chapters =
                _this.reportTemplateService.groupReportTemplateByChapters(reportTemplates);
            _this.$scope.templates = reportTemplates;
            if (_.isEmpty(reportTemplates)) {
                return;
            }
            var sortedReportTemplates = _.sortBy(_.sortBy(reportTemplates, function (t) { return t.name; }), function (rt) { return rt.chapter; });
            var reportTemplate = _.isDefined(searchObject.uniqueGuid)
                ? _.find(_this.$scope.templates, function (report) { return searchObject.uniqueGuid === report.uniqueGuid; })
                : _.first(sortedReportTemplates);
            _this.$scope.setSelectedTemplate(reportTemplate);
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    }
    ReportTemplatesManagementCtrl.prototype.isChapterVisible = function (chapter) {
        var _this = this;
        return _.any(chapter.templates, function (template) {
            return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase());
        });
    };
    ReportTemplatesManagementCtrl.prototype.onFileToImportSelected = function (templatesFile) {
        var _this = this;
        if (_.isUndefined(templatesFile) || !_.any(templatesFile))
            return;
        this.reportTemplateService.importReportTemplates(templatesFile, this.$scope.templates.length)
            .then(function (templates) {
            _this.processImportedTemplates(templates);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplatesImportMsg'), data);
        });
    };
    ReportTemplatesManagementCtrl.prototype.importDemoTemplates = function () {
        var _this = this;
        this.reportTemplateService.importDemoReportTemplates(this.$scope.templates.length)
            .then(function (response) {
            _this.processImportedTemplates(response);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplatesImportMsg'), data);
        });
    };
    ReportTemplatesManagementCtrl.prototype.createCopyOfSelectedTemplate = function () {
        var _this = this;
        if (_.isUndefined(this.$scope.selectedTemplate))
            return;
        var item = _.deepclone(this.$scope.selectedTemplate);
        var lastTemplate = _.max(this.$scope.templates, function (info) {
            return info.id;
        });
        item.Id = lastTemplate.id + 1;
        item.Name = this.getTemplateUniqueName(String.Format(this.language.getElementValue('copyHdr'), item.Name));
        item.Version = 0;
        item.UniqueGuid = this.guid.new();
        this.$http
            .post(this.clientSettings.getServerInstance() + '/ReportTemplate/CopyReportTemplate', {
            reportTemplate: item,
        })
            .then(function (response) {
            var template = new ReportTemplate(_this.$scope, response.data, _this.notificationService, _this.language, _this.$http, _this.clientSettings, _this.reportTemplateProvider, _this.$modal, _this.mailValidationService, _this.mailProvider, _this.userPreferencesService, _this.printProvider);
            _this.insertTemplateInfo(template);
            _this.notificationService.showMessage(_this.language.getElementValue('reportSuccessTemplateCopyMsg'));
        }, function (response) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorTemplateCopyMsg'), response.data);
        });
    };
    ReportTemplatesManagementCtrl.prototype.processImportedTemplates = function (templates) {
        var _this = this;
        var _a;
        var selectedTemplateUniqueGuid = (_a = this.$scope.selectedTemplate) === null || _a === void 0 ? void 0 : _a.UniqueGuid;
        var isSelectedTemplateWasImported = _.isDefined(selectedTemplateUniqueGuid)
            && _.any(templates, function (template) { return selectedTemplateUniqueGuid === template.UniqueGuid; });
        this.authentication.updatePermissions();
        this.reportTemplateProvider.getAllReportTemplatesShortInfo().then(function (reportTemplates) {
            var _a;
            _this.$scope.reportTemplateChapterInfo.chapters =
                _this.reportTemplateService.groupReportTemplateByChapters(reportTemplates);
            _this.$scope.templates = reportTemplates;
            if (isSelectedTemplateWasImported) {
                var importedTemplate = _.find(reportTemplates, function (template) { return template.uniqueGuid === selectedTemplateUniqueGuid; });
                (_a = _this.$scope.selectedTemplate) === null || _a === void 0 ? void 0 : _a.destroy();
                _this.$scope.selectedTemplate = null;
                _this.$scope.setSelectedTemplate(importedTemplate);
            }
            _this.notificationService.showMessage(_this.language.getElementValue('reportSuccessTemplatesImportMsg'));
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ReportTemplatesManagementCtrl.prototype.getLastVersionReportTemplate = function (uniqueGuid) {
        var deferred = this.$q.defer();
        this.$http
            .get(this.clientSettings.getServerInstance() + '/ReportTemplate/GetLastVersionReportTemplate', {
            params: { uniqueGuid: uniqueGuid },
        })
            .then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    ReportTemplatesManagementCtrl.prototype.getTemplateUniqueName = function (name) {
        var i = 1;
        var names = _.map(this.$scope.templates, function (reportTemplate) {
            return reportTemplate.name;
        });
        while (names.indexOf(name + ' ' + i) !== -1) {
            i++;
        }
        return name + ' ' + i;
    };
    ReportTemplatesManagementCtrl.prototype.getSaveTemplateModalInstance = function () {
        var _this = this;
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
            controller: 'yesNoCancelModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () {
                    return _this.language.getElementValue('reportTemplateReportModalHdr');
                },
                body: function () {
                    return String.Format(_this.language.getElementValue('reportSaveChangesReportTemplateModalQuestionHdr'), _this.$scope.selectedTemplate.Name);
                },
            },
        });
    };
    ReportTemplatesManagementCtrl.prototype.deleteTemplateInfo = function (template) {
        var item = _.find(this.$scope.templates, function (info) {
            return info.id === template.Id;
        });
        var idx = this.$scope.templates.indexOf(item);
        if (idx > -1) {
            this.$scope.templates.splice(idx, 1);
            var orderedChapters = _.sortBy(this.$scope.reportTemplateChapterInfo.chapters, function (c) { return c.name; });
            var chapter_1 = _.find(orderedChapters, function (c) { return c.name === item.chapter; });
            var chapterIdx = _.findIndex(orderedChapters, function (c) { return c.ident === chapter_1.ident; });
            var sortedChapters = _.sortBy(chapter_1.templates, function (t) { return t.name; });
            var idxInChapter = _.findIndex(sortedChapters, function (t) { return t.id === template.Id; });
            this.$scope.reportTemplateChapterInfo.chapters = this.reportTemplateService.groupReportTemplateByChapters(this.$scope.templates);
            if (chapter_1.templates.length > 1) {
                this.$scope.setSelectedTemplate(sortedChapters[idxInChapter === 0 ? idxInChapter + 1 : idxInChapter - 1]);
            }
            else {
                if (this.$scope.reportTemplateChapterInfo.chapters.length > 0) {
                    this.$scope.setSelectedTemplate(_.sortBy(orderedChapters[chapterIdx === 0 ? chapterIdx + 1 : chapterIdx - 1].templates, function (t) { return t.name; })[0]);
                }
                else {
                    this.$scope.selectedTemplate = undefined;
                }
            }
        }
    };
    ReportTemplatesManagementCtrl.prototype.selectTemplate = function (after, before) {
        var _this = this;
        if (_.isDefined(before) && before.isChanged) {
            this.getSaveTemplateModalInstance().result.then(function (data) {
                if (data === 'ok') {
                    _this.onNeedSave(before);
                    _this.$scope.selectedTemplate = after;
                    before === null || before === void 0 ? void 0 : before.destroy();
                }
                if (data === 'no') {
                    _this.$scope.selectedTemplate = after;
                    before === null || before === void 0 ? void 0 : before.destroy();
                }
                if (data === 'cancel') {
                    return;
                }
            });
        }
        else {
            this.$scope.selectedTemplate = after;
        }
    };
    ReportTemplatesManagementCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$http',
        '$modal',
        '$location',
        '$upload',
        '$window',
        '$modalStack',
        '$q',
        'notificationService',
        'clientSettings',
        'guid',
        'authentication',
        'reportTemplateService',
        'reportTemplateProvider',
        'licenseProvider',
        'language',
        'mailValidationService',
        'mailProvider',
        'userPreferencesService',
        'exportService',
        'printProvider',
        'smsTemplateEditorConfiguration',
    ];
    return ReportTemplatesManagementCtrl;
}());
app.controller('reportTemplatesManagementCtrl', ReportTemplatesManagementCtrl);
