var ReportScheduleRulesSettingsCtrl = (function () {
    function ReportScheduleRulesSettingsCtrl($timeout, scope, language, template, reportTemplateService, notification, modal, mailValidationService, mailProvider, userPreferencesService, printProvider) {
        this.$timeout = $timeout;
        this.scope = scope;
        this.language = language;
        this.template = template;
        this.reportTemplateService = reportTemplateService;
        this.notification = notification;
        this.modal = modal;
        this.mailValidationService = mailValidationService;
        this.mailProvider = mailProvider;
        this.userPreferencesService = userPreferencesService;
        this.printProvider = printProvider;
        this.ruleCtrls = [];
        this.template = template;
    }
    ReportScheduleRulesSettingsCtrl.prototype.insertRule = function () {
        var rule = new ReportRule(this.scope, this.language, this.reportTemplateService, this.notification, this.modal, this.template, null, this.mailValidationService, this.userPreferencesService, this.printProvider);
        this.template.Rules.push(rule);
        var ruleCtrl = new ReportRuleCtrl(this.$timeout, this.scope, rule, this.language, this.reportTemplateService, this.notification, this.modal, this.template, this.mailValidationService, this.mailProvider, this.userPreferencesService, this.printProvider);
        this.ruleCtrls.push(ruleCtrl);
    };
    ReportScheduleRulesSettingsCtrl.prototype.deleteRule = function (idx) {
        var removedRuleCtrls = this.ruleCtrls.splice(idx, 1);
        _.forEach(removedRuleCtrls, function (ctrl) { return ctrl.destroy(); });
        this.template.Rules.splice(idx, 1);
    };
    ReportScheduleRulesSettingsCtrl.prototype.setSelectedTemplate = function (template) {
        this.ruleCtrls = [];
        this.template = template;
        for (var i = 0; i < template.Rules.length; i++) {
            var reportRule = new ReportRule(this.scope, this.language, this.reportTemplateService, this.notification, this.modal, this.template, template.Rules[i], this.mailValidationService, this.userPreferencesService, this.printProvider);
            template.Rules[i] = reportRule;
            var reportRuleCtrl = new ReportRuleCtrl(this.$timeout, this.scope, reportRule, this.language, this.reportTemplateService, this.notification, this.modal, this.template, this.mailValidationService, this.mailProvider, this.userPreferencesService, this.printProvider);
            this.ruleCtrls.push(reportRuleCtrl);
        }
    };
    ReportScheduleRulesSettingsCtrl.prototype.getErrorMessages = function () {
        return _.flatten(_.map(this.ruleCtrls, function (rule) {
            return rule.getErrorMessages();
        }));
    };
    return ReportScheduleRulesSettingsCtrl;
}());
