var RecalcAction = (function () {
    function RecalcAction(actionType, source) {
        if (source === void 0) { source = null; }
        this.type = actionType;
        if (source) {
            this.currentAttemps = source.currentAttemps;
            this.reportRecreateInstruction = source.reportRecreateInstruction;
        }
        else {
            this.currentAttemps = 0;
            this.reportRecreateInstruction = {
                needKeepManualEditValues: true,
                needKeepCalculatedValues: true,
                needKeepExternalSourceValues: true,
                toLastTemplateVersion: false
            };
        }
    }
    RecalcAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.reportRecreateInstruction.needKeepManualEditValues === other.reportRecreateInstruction.needKeepManualEditValues &&
            obj.reportRecreateInstruction.needKeepCalculatedValues === other.reportRecreateInstruction.needKeepCalculatedValues &&
            obj.reportRecreateInstruction.needKeepExternalSourceValues === other.reportRecreateInstruction.needKeepExternalSourceValues &&
            obj.reportRecreateInstruction.toLastTemplateVersion === other.reportRecreateInstruction.toLastTemplateVersion &&
            obj.currentAttemps === other.currentAttemps);
    };
    return RecalcAction;
}());
