var PrintAction = (function () {
    function PrintAction(language, notificationService, printProvider, source) {
        if (source === void 0) { source = null; }
        var _this = this;
        this.language = language;
        this.notificationService = notificationService;
        this.printProvider = printProvider;
        this.type = 6;
        this.printerNames = [];
        this.paperSizes = [];
        if (_.isDefined(source)) {
            this.printerName = source.printerName;
            this.paperSize = source.paperSize;
            this.copiesAmount = source.copiesAmount;
            this.executionStatus = source.executionStatus;
            this.loadPaperSizes(this.printerName);
        }
        else {
            this.printerName = "";
            this.paperSize = "";
            this.copiesAmount = 1;
            this.executionStatus = null;
        }
        printProvider.getPrinterNames()
            .then(function (printerNames) {
            _this.printerNames = printerNames;
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    }
    PrintAction.prototype.loadPaperSizes = function (printerName) {
        var _this = this;
        if (_.isEmpty(printerName)) {
            return;
        }
        this.printProvider.getPaperSizes(printerName)
            .then(function (paperSizes) {
            _this.paperSizes = paperSizes;
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    PrintAction.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.printerName === other.printerName
            && obj.paperSize === other.paperSize
            && obj.copiesAmount === other.copiesAmount;
    };
    return PrintAction;
}());
