var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var WccoaFuncUiSelectItem = (function (_super) {
    __extends(WccoaFuncUiSelectItem, _super);
    function WccoaFuncUiSelectItem(ident, name, isPeriodic, returnType, alias) {
        var _this = _super.call(this, ident, name, returnType) || this;
        _this.isPeriodic = isPeriodic;
        _this.returnType = returnType;
        _this.alias = alias;
        return _this;
    }
    return WccoaFuncUiSelectItem;
}(SelectSourceFunctionsItem));
var WinccoaSettingsCtrl = (function () {
    function WinccoaSettingsCtrl(parentScope, language, modalService, winccOaService, notificationService) {
        var _this = this;
        this.winccOaService = winccOaService;
        this.notificationService = notificationService;
        this.GetCatStrFunctionIdent = 'getCatStr';
        this.watchFunctions = [];
        this.connectionTypes = [4];
        this.checkParamAddress = function () {
            _this.winccOaService
                .isDataPointExists(_this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress, _this.parentScope.param.WinccOa.connectionGuid)
                .then(function (checkResult) {
                if (checkResult) {
                    _this.notificationService.showMessage(_this.language.getElementValue('tagAddressIsExistMsg'));
                }
                else {
                    _this.notificationService.errorMessage(_this.language.getElementValue('tagAddressIsNotExistMsg'));
                }
            }, function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('errorCheckTagAddressMsg'), error);
            });
        };
        this.parentScope = parentScope;
        this.language = language;
        this.modalService = modalService;
    }
    WinccoaSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.queryAlarms = new QueryAlarmsSettingsCtrl(this.parentScope.param, this.parentScope.settingsCtrl.formulaCtrl, this.parentScope, this.language);
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.WinccOa.startTimestamp;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.parentScope.param.WinccOa.startTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.parentScope.param.WinccOa.endTimestamp;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.parentScope.param.WinccOa.endTimestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.parentScope.settingsCtrl.sourceCtrl.getFormula());
        });
        var timeStampDictionary = new Dictionary();
        timeStampDictionary.add('dpGet', 'StartDate');
        timeStampDictionary.add('dpReportDay', 'ReportDay');
        timeStampDictionary.add('dpReportMonth', 'ReportMonth');
        timeStampDictionary.add('dpReportYear', 'ReportYear');
        var setDefaultSettingsAfterChangeFunction = function (after) {
            self.parentScope.param.WinccOa.queryAlarmsSettings = null;
            self.parentScope.param.WinccOa.querySettings = null;
            self.parentScope.param.WinccOa.requestDPValuesSettings = null;
            if (timeStampDictionary.containsKey(after.ident)) {
                self.startPeriods.selected = _.find(self.startPeriods, function (item) {
                    return item.ident === timeStampDictionary.get(self.parentScope.param.WinccOa.func);
                });
                self.parentScope.param.WinccOa.requestDPValuesSettings = new WinccOaDpRequestSettings();
            }
            else if (self.parentScope.param.WinccOa.func === 'dpChange') {
                self.startPeriods.selected = _.find(self.startPeriods, function (item) {
                    return item.ident === 'StartDate';
                });
                self.endPeriods.selected = _.find(self.endPeriods, function (item) {
                    return item.ident === 'EndDate';
                });
                self.parentScope.param.WinccOa.requestDPValuesSettings = new WinccOaDpRequestSettings(1);
            }
            else if (after.ident === _this.GetCatStrFunctionIdent) {
                self.parentScope.param.WinccOa.catalogMessageSettings = new WinccOaCatalogMessageSettings();
            }
            else {
                if (after.isPeriodic) {
                    self.startPeriods.selected = _.find(self.startPeriods, function (item) {
                        return item.ident === 'StepStart';
                    });
                    self.endPeriods.selected = _.find(self.startPeriods, function (item) {
                        return item.ident === 'StepEnd';
                    });
                }
                if (after.ident === 'queryAsHtmlTable') {
                    if (_.isUndefined(self.parentScope.param.WinccOa.querySettings)) {
                        self.parentScope.param.WinccOa.querySettings = new WinccOaQuerySettings();
                    }
                    return;
                }
                if (after.ident === 'queryEventsAsHtmlTable') {
                    if (_.isUndefined(self.parentScope.param.WinccOa.queryAlarmsSettings)) {
                        self.parentScope.param.WinccOa.queryAlarmsSettings = new WinccoaQueryAlarmsSettings();
                    }
                    return;
                }
                if (after.ident === 'dpBitNumber') {
                    if (_.isUndefined(self.parentScope.param.WinccOa.requestDPValuesSettings))
                        self.parentScope.param.WinccOa.requestDPValuesSettings = new WinccOaDpRequestSettings(1);
                    return;
                }
                self.parentScope.param.WinccOa.requestDPValuesSettings = new WinccOaDpRequestSettings();
            }
        };
        var afterSelectFunction = function (after) {
            self.queryInputVisible = after.ident === 'queryAsHtmlTable';
            self.queryAlarms.visible = after.ident === 'queryEventsAsHtmlTable';
            if (_.isDefined(self.parentScope.param.WinccOa.queryAlarmsSettings)) {
                self.queryAlarms.load(self.parentScope.param.WinccOa.queryAlarmsSettings);
            }
            self.tagInputVisible
                = after.ident !== 'queryAsHtmlTable'
                    && after.ident !== 'queryEventsAsHtmlTable'
                    && after.ident !== _this.GetCatStrFunctionIdent;
            self.acceptableRangeInputVisible
                = after.ident !== 'dpAlarmsOnPeriod'
                    && after.ident !== 'queryAsHtmlTable'
                    && after.ident !== 'queryEventsAsHtmlTable'
                    && after.ident !== 'dpBitNumber'
                    && after.ident !== _this.GetCatStrFunctionIdent;
            self.catalogMessagesInputVisible = after.ident === _this.GetCatStrFunctionIdent;
            self.parentScope.showPeriods = after.isPeriodic;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        };
        this.paramWinccOaFunctions = getVariantsContainer(this.parentScope, [
            new WccoaFuncUiSelectItem('dpGet', this.language.getElementValue('winccValueParameterTimeStampHdr'), false, 'WinccOaValue', 'Get'),
            new WccoaFuncUiSelectItem('dpAvg', this.language.getElementValue('winccAveragePeriodForDiscreteParameterHdr'), true, 'double', 'Avg'),
            new WccoaFuncUiSelectItem('dpWAvg', this.language.getElementValue('winccAverageWeightedAverageForPeriodHdr'), true, 'double', 'WAvg'),
            new WccoaFuncUiSelectItem('dpLastOnPeriod', this.language.getElementValue('winccAverageLastForPeriodHdr'), true, 'WinccOaValue', 'LastOnPeriod'),
            new WccoaFuncUiSelectItem('dpMin', this.language.getElementValue('winccMinPeriodForDiscreteParameterHdr'), true, 'WinccOaValue', 'Min'),
            new WccoaFuncUiSelectItem('dpMax', this.language.getElementValue('winccMaxPeriodForDiscreteParameterHdr'), true, 'WinccOaValue', 'Max'),
            new WccoaFuncUiSelectItem('dpCAvg', this.language.getElementValue('winccAveragePeriodForContinuousParameterHdr'), true, 'double', 'ContinuousAvg'),
            new WccoaFuncUiSelectItem('dpCMin', this.language.getElementValue('winccMinPeriodForContinuousParameterHdr'), true, 'WinccOaValue', 'ContinuousMin'),
            new WccoaFuncUiSelectItem('dpCMax', this.language.getElementValue('winccMaxPeriodForContinuousParameterHdr'), true, 'WinccOaValue', 'ContinuousMax'),
            new WccoaFuncUiSelectItem('dpSum', this.language.getElementValue('winccSumPeriodHdr'), true, 'double', 'Sum'),
            new WccoaFuncUiSelectItem('dpCount', this.language.getElementValue('winccChangesCountPeriodParameterHdr'), true, 'int', 'Count'),
            new WccoaFuncUiSelectItem('queryAsHtmlTable', this.language.getElementValue('winccQueryAsHtmlTableHdr'), true, 'ReportTable', 'QueryAsHtmlTable'),
            new WccoaFuncUiSelectItem('queryEventsAsHtmlTable', this.language.getElementValue('winccQueryAlarmsAsHtmlTableHdr'), true, 'WinccOaAlarmsTable', 'QueryAsHtmlTable'),
            new WccoaFuncUiSelectItem('dpReportDay', this.language.getElementValue('winccParameterValueBeginningReportingDayHdr'), false, 'WinccOaValue', 'Get'),
            new WccoaFuncUiSelectItem('dpReportMonth', this.language.getElementValue('winccParameterValueFirstDayReportingMonthHdr'), false, 'WinccOaValue', 'Get'),
            new WccoaFuncUiSelectItem('dpReportYear', this.language.getElementValue('winccParameterValueFirstDayReportingYearHdr'), false, 'WinccOaValue', 'Get'),
            new WccoaFuncUiSelectItem('dpChange', this.language.getElementValue('winccParameterChangeParameterValuePeriodHdr'), true, 'double'),
            new WccoaFuncUiSelectItem('dpAlarmsOnPeriod', this.language.getElementValue('winccAlarmsPeriodHdr'), true, 'WinccOaAlarm[]', 'GetAlarmsOnPeriod'),
            new WccoaFuncUiSelectItem('dpGetOnPeriod', this.language.getElementValue('winccGetOnPeriodHdr'), true, 'WinccOaValue[]', 'GetPeriod'),
            new WccoaFuncUiSelectItem('dpBitNumber', this.language.getElementValue('winccoaParameterUserBitHdr'), false, 'WinccOaValue', 'GetUserbit'),
            new WccoaFuncUiSelectItem('dpGetDescription', this.language.getElementValue('winccoaParameterGetDescriptionHdr'), false, 'string', 'GetDescription'),
            new WccoaFuncUiSelectItem('dpGetUnit', this.language.getElementValue('winccoaParameterGetUnitHdr'), false, 'string', 'GetUnit'),
            new WccoaFuncUiSelectItem('dpGetFormat', this.language.getElementValue('winccoaParameterGetFormatHdr'), false, 'string', 'GetFormat'),
            new WccoaFuncUiSelectItem(this.GetCatStrFunctionIdent, this.language.getElementValue('winccoaParameterGetCatalogMessageHdr'), false, 'string', 'GetCatStr'),
        ], function (t) {
            return t.ident === self.parentScope.param.WinccOa.func;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.parentScope.param.WinccOa.func = after.ident;
            setDefaultSettingsAfterChangeFunction(after);
            afterSelectFunction(after);
            self.parentScope.param.Editable = self.canEdited();
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.WinccOa.querySettings;
        }, function (after, before) {
            if (after == undefined || WinccOaQuerySettings.isEqual(after, before))
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.WinccOa.requestDPValuesSettings;
        }, function (after, before) {
            if (after == undefined || WinccOaDpRequestSettings.isEqual(after, before))
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.WinccOa.catalogMessageSettings;
        }, function (after, before) {
            if (after == undefined || WinccOaCatalogMessageSettings.isEqual(after, before))
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        afterSelectFunction(this.paramWinccOaFunctions.selected);
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    WinccoaSettingsCtrl.prototype.destroy = function () {
        this.queryAlarms.destroy();
        this.paramWinccOaFunctions.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func))
                func();
        }
        this.watchFunctions = [];
    };
    WinccoaSettingsCtrl.prototype.getFormula = function () {
        var formula = '';
        var address = _.isUndefined(this.parentScope.param.WinccOa.requestDPValuesSettings)
            || _.isUndefined(this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress)
            ? ''
            : this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress;
        var connectionGuid = this.parentScope.param.WinccOa.connectionGuid;
        if (this.paramWinccOaFunctions.selected != undefined) {
            if (this.paramWinccOaFunctions.selected.alias != undefined) {
                if (this.paramWinccOaFunctions.selected.ident === 'queryEventsAsHtmlTable') {
                    formula = this.queryAlarms.getFormula();
                }
                else if (this.paramWinccOaFunctions.selected.ident === 'queryAsHtmlTable') {
                    if (this.parentScope.param.WinccOa.querySettings.query.indexOf('TIMERANGE') > -1) {
                        formula = String.Format('return {0}("{1}", "{2}", {3});', this.paramWinccOaFunctions.selected.alias, connectionGuid, this.parentScope.param.WinccOa.querySettings.query, this.parentScope.param.WinccOa.querySettings.includeHeader.toString());
                    }
                    else {
                        formula = String.Format('return {0}("{1}", "{2} TIMERANGE(\\"" + {3}.ToString("yyyy.MM.dd HH:mm:ss") + ".000\\",\\"" + {4}.ToString("yyyy.MM.dd HH:mm:ss") + ".000\\",1,0)", {5});', this.paramWinccOaFunctions.selected.alias, connectionGuid, this.parentScope.param.WinccOa.querySettings.query, this.parentScope.param.WinccOa.startTimestamp, this.parentScope.param.WinccOa.endTimestamp, this.parentScope.param.WinccOa.querySettings.includeHeader.toString());
                    }
                }
                else if (this.paramWinccOaFunctions.selected.alias === 'Get') {
                    formula = 'Get("' + connectionGuid + '", "' + address + '", ' + this.parentScope.param.WinccOa.startTimestamp + ')';
                }
                else if (this.paramWinccOaFunctions.selected.ident === 'dpBitNumber') {
                    var bitNumber = _.isUndefined(this.parentScope.param.WinccOa.requestDPValuesSettings.bitNumber)
                        ? 1
                        : this.parentScope.param.WinccOa.requestDPValuesSettings.bitNumber;
                    formula = String.Format('GetUserbit("{0}", "{1}", {2}, {3})', connectionGuid, address, this.parentScope.param.WinccOa.startTimestamp, bitNumber.toString());
                }
                else if (['GetDescription', 'GetUnit', 'GetFormat'].includes(this.paramWinccOaFunctions.selected.alias)) {
                    formula = "".concat(this.paramWinccOaFunctions.selected.alias, "(\"").concat(connectionGuid, "\", \"").concat(address, "\")");
                }
                else if (this.paramWinccOaFunctions.selected.ident === this.GetCatStrFunctionIdent) {
                    var catalog = this.parentScope.param.WinccOa.catalogMessageSettings.catalog;
                    var messageKey = this.parentScope.param.WinccOa.catalogMessageSettings.messageKey;
                    var languageIdx = this.parentScope.param.WinccOa.catalogMessageSettings.languageIdx;
                    formula = "".concat(this.paramWinccOaFunctions.selected.alias, "(\"").concat(connectionGuid, "\", \"").concat(catalog, "\", \"").concat(messageKey, "\", ").concat(languageIdx, ")");
                }
                else {
                    var func = this.paramWinccOaFunctions.selected.alias;
                    var ts1 = this.parentScope.param.WinccOa.startTimestamp;
                    var ts2 = this.parentScope.param.WinccOa.endTimestamp;
                    formula = "".concat(func, "(\"").concat(connectionGuid, "\", \"").concat(address, "\", ").concat(ts1, ", ").concat(ts2, ")");
                }
            }
            else {
                if (this.paramWinccOaFunctions.selected.ident == 'dpChange') {
                    var ts1 = this.parentScope.param.WinccOa.startTimestamp;
                    var ts2 = this.parentScope.param.WinccOa.endTimestamp;
                    formula = "return Get(\"".concat(connectionGuid, "\", \"").concat(address, "\", ").concat(ts1, ").Value - Get(\"").concat(address, "\", ").concat(ts2, ").Value;");
                }
            }
        }
        return formula;
    };
    WinccoaSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    WinccoaSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.WinccOa.canEdited();
    };
    WinccoaSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.WinccOa.canPlanned();
    };
    WinccoaSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.WinccOa.canBacklight();
    };
    WinccoaSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.WinccOa.canPredefined();
    };
    WinccoaSettingsCtrl.prototype.showBitNumber = function () {
        if (this.paramWinccOaFunctions.selected.ident === 'dpBitNumber')
            return true;
        return false;
    };
    WinccoaSettingsCtrl.prototype.showTimeStamps = function () {
        if (this.paramWinccOaFunctions.selected.ident === 'dpReportDay'
            || this.paramWinccOaFunctions.selected.ident === 'dpReportMonth'
            || this.paramWinccOaFunctions.selected.ident === 'dpReportYear'
            || this.paramWinccOaFunctions.selected.ident === this.GetCatStrFunctionIdent)
            return false;
        return true;
    };
    WinccoaSettingsCtrl.prototype.showWccoaTree = function () {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return _this.parentScope.param.WinccOa.connectionGuid; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara]; },
                tagAddress: function () { return _this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress; }
            },
        });
        modalInstance.result.then(function (tags) {
            _this.parentScope.param.WinccOa.requestDPValuesSettings.name = tags[0].name;
            _this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress = tags[0].address;
        });
    };
    WinccoaSettingsCtrl.prototype.clearTag = function () {
        this.parentScope.param.WinccOa.requestDPValuesSettings.name = '';
        this.parentScope.param.WinccOa.requestDPValuesSettings.uploadAddress = '';
    };
    WinccoaSettingsCtrl.prototype.onConnectionSelected = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    return WinccoaSettingsCtrl;
}());
