var WinccoaQueryAlarmsSettings = (function () {
    function WinccoaQueryAlarmsSettings() {
        this.fields = [0, 4];
        this.classFilter = [];
        this.tagFilter = [];
        this.directionFilter = -1;
    }
    WinccoaQueryAlarmsSettings.clone = function (obj) {
        if (_.isUndefined(obj))
            return obj;
        var clone = new WinccoaQueryAlarmsSettings();
        clone.fields = _.map(obj.fields, function (f) { return f; });
        clone.classFilter = _.map(obj.classFilter, function (f) { return f; });
        clone.tagFilter = _.map(obj.tagFilter, function (f) { return f; });
        clone.directionFilter = obj.directionFilter;
        return clone;
    };
    WinccoaQueryAlarmsSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other))
            return obj === other;
        if (_.isUndefined(obj.fields) || _.isUndefined(other.fields)) {
            if (obj.fields !== other.fields)
                return false;
        }
        else if (obj.fields.length !== other.fields.length) {
            return false;
        }
        if (_.isUndefined(obj.classFilter) || _.isUndefined(other.classFilter)) {
            if (obj.classFilter !== other.classFilter)
                return false;
        }
        else if (obj.classFilter.length !== other.classFilter.length) {
            return false;
        }
        if (_.isUndefined(obj.tagFilter) || _.isUndefined(other.tagFilter)) {
            if (obj.tagFilter !== other.tagFilter)
                return false;
        }
        else if (obj.tagFilter.length !== other.tagFilter.length) {
            return false;
        }
        return (_.every(obj.fields, function (item, index) {
            return item === other.fields[index];
        }) &&
            _.every(obj.classFilter, function (item, index) {
                return item === other.classFilter[index];
            }) &&
            _.every(obj.tagFilter, function (item, index) {
                return item === other.tagFilter[index];
            }) &&
            obj.directionFilter === other.directionFilter);
    };
    return WinccoaQueryAlarmsSettings;
}());
