var WinccOaInfluxSettings = (function () {
    function WinccOaInfluxSettings(templateHasStep) {
        this.func = 'dpGet';
        this.startTimestamp = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endTimestamp = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
    }
    WinccOaInfluxSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new WinccOaInfluxSettings();
        clone.func = obj.func;
        clone.dataPointAddress = obj.dataPointAddress;
        clone.startTimestamp = obj.startTimestamp;
        clone.endTimestamp = obj.endTimestamp;
        clone.connectionGuid = obj.connectionGuid;
        return clone;
    };
    WinccOaInfluxSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func &&
            obj.dataPointAddress === other.dataPointAddress &&
            obj.startTimestamp === other.startTimestamp &&
            obj.endTimestamp === other.endTimestamp &&
            obj.connectionGuid === other.connectionGuid);
    };
    WinccOaInfluxSettings.prototype.canEdited = function () {
        return true;
    };
    WinccOaInfluxSettings.prototype.canPlanned = function () {
        return true;
    };
    WinccOaInfluxSettings.prototype.canBacklight = function () {
        return true;
    };
    WinccOaInfluxSettings.prototype.canPredefined = function () {
        return false;
    };
    return WinccOaInfluxSettings;
}());
