var OracleSettings = (function () {
    function OracleSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    OracleSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new OracleSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.includeHeader = obj.includeHeader;
        clone.sql = obj.sql;
        return clone;
    };
    OracleSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.includeHeader === other.includeHeader &&
            obj.sql === other.sql);
    };
    OracleSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    OracleSettings.prototype.canPlanned = function () {
        return true;
    };
    OracleSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    OracleSettings.prototype.canPredefined = function () {
        return false;
    };
    return OracleSettings;
}());
