var MsSqlSettings = (function () {
    function MsSqlSettings() {
        this.func = 'table';
        this.includeHeader = true;
        this.sql = '';
    }
    MsSqlSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new MsSqlSettings();
        clone.func = obj.func;
        clone.sql = obj.sql;
        clone.includeHeader = obj.includeHeader;
        clone.connectionGuid = obj.connectionGuid;
        return clone;
    };
    MsSqlSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.func === other.func &&
            obj.sql === other.sql &&
            obj.includeHeader === other.includeHeader &&
            obj.connectionGuid === other.connectionGuid);
    };
    MsSqlSettings.prototype.canEdited = function () {
        return this.func === 'cellString' || this.func === 'cellDouble';
    };
    MsSqlSettings.prototype.canPlanned = function () {
        return true;
    };
    MsSqlSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray', 'objectArray'], this.func);
    };
    MsSqlSettings.prototype.canPredefined = function () {
        return false;
    };
    return MsSqlSettings;
}());
