var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LogFieldTypes;
(function (LogFieldTypes) {
    LogFieldTypes[LogFieldTypes["String"] = 0] = "String";
    LogFieldTypes[LogFieldTypes["Double"] = 1] = "Double";
    LogFieldTypes[LogFieldTypes["Time"] = 2] = "Time";
    LogFieldTypes[LogFieldTypes["DateTime"] = 3] = "DateTime";
    LogFieldTypes[LogFieldTypes["Dropdown"] = 4] = "Dropdown";
    LogFieldTypes[LogFieldTypes["TimeSpan"] = 5] = "TimeSpan";
})(LogFieldTypes || (LogFieldTypes = {}));
var FieldTypesUiSelect = (function (_super) {
    __extends(FieldTypesUiSelect, _super);
    function FieldTypesUiSelect(ident, name, width, defaultValue) {
        var _this = _super.call(this, ident, name) || this;
        _this.width = width;
        _this.defaultValue = defaultValue;
        return _this;
    }
    return FieldTypesUiSelect;
}(UiSelectItem));
var procent = '%';
var LogSettingsCtrl = (function () {
    function LogSettingsCtrl(parentScope, modalService, language, notificationService) {
        this.watchFunctions = [];
        this.language = language;
        this.modalService = modalService;
        this.parentScope = parentScope;
        this.notificationService = notificationService;
    }
    LogSettingsCtrl.prototype.getTotalWidth = function () {
        var width = 0;
        _.forEach(this.parentScope.param.Log.fields, function (field) {
            if (_.isNumber(field.width))
                width += field.width;
        });
        return width;
    };
    LogSettingsCtrl.prototype.onUpdatedFieldList = function () {
        var width = this.getTotalWidth();
        if (width > 100 && this.widthDimensionTypes.selected.ident === procent)
            this.updateDataFieldWidth();
        this.width = width;
        width = Math.round(width * 100) / 100;
        this.widthTable = String.Format(this.language.getElementValue('reportWidthTableWillBeHdr'), width.toString());
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    LogSettingsCtrl.prototype.updateDataFieldWidth = function () {
        var width = this.getTotalWidth();
        _.forEach(this.parentScope.param.Log.fields, function (field) {
            field.width /= width * 0.01;
            field.width = Math.round(field.width * 100) / 100;
        });
    };
    LogSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.reportParameters = [
            new UiSelectItem('', this.language.getElementValue('reportDefaultValueIsNotSelectedHdr')),
        ];
        for (var i = 0; i < this.parentScope.reportTemplate.Parameters.length; i++) {
            if (this.parentScope.reportTemplate.Parameters[i].Ident !== this.parentScope.param.Ident &&
                this.parentScope.reportTemplate.Parameters[i].ParameterType === 'LogRow[]')
                this.reportParameters.push(new UiSelectItem(this.parentScope.reportTemplate.Parameters[i].Ident, this.parentScope.reportTemplate.Parameters[i].Ident));
        }
        var reportParamets = _.find(this.reportParameters, function (type) {
            return type.ident === _this.parentScope.param.Log.initialParameter;
        });
        this.reportParameters.selected = _.isUndefined(this.parentScope.param.Log.initialParameter)
            ? this.reportParameters[0]
            : reportParamets;
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.reportParameters.selected;
        }, function (after, before) {
            if (after === before)
                return;
            _this.parentScope.param.Log.initialParameter = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.fieldTypes = [
            new FieldTypesUiSelect('string', this.language.getElementValue('reportParameterTypeStringHdr'), 72),
            new FieldTypesUiSelect('double', this.language.getElementValue('reportParameterTypeDoubleHdr'), 72),
            new FieldTypesUiSelect('time', this.language.getElementValue('reportTimeHdr'), 72),
            new FieldTypesUiSelect('timespan', this.language.getElementValue('reportParameterTypeTimeSpanHdr'), 150),
            new FieldTypesUiSelect('datetime', this.language.getElementValue('dateHdr'), 190, LogFieldDateTimeDefaultValue.None),
            new FieldTypesUiSelect('dropdown', this.language.getElementValue('reportParameterTypeDropDownHdr'), 72),
        ];
        this.fieldList = new LogFieldList(this.parentScope, this.parentScope.param, this.fieldTypes, this.modalService, this.language, this.notificationService);
        this.widthDimensionTypes = getVariantsContainer(self.parentScope, [
            new UiSelectItem('px', this.language.getElementValue('reportPixelsHdr')),
            new UiSelectItem(procent, this.language.getElementValue('reportPercentHdr')),
        ], function (t) {
            if (_.isUndefined(self.parentScope.param.Log) || _.isNull(self.parentScope.param.Log)) {
                return false;
            }
            return t.ident === self.parentScope.param.Log.widthDimension;
        }, function (after, before) {
            if (before === after) {
                return;
            }
            if (after.ident === procent)
                _this.updateDataFieldWidth();
            self.parentScope.param.Log.widthDimension = after.ident;
        });
        this.parentScope.param.Log.fields = _.map(this.parentScope.param.Log.fields, function (field) {
            return new LogFieldScope(_this.parentScope, field, _this.fieldTypes, _this.fieldList.openDropdownFieldSettingsWindow, _this.language);
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Log != undefined ? self.parentScope.param.Log.fields : undefined;
        }, function (comments) {
            if (comments === undefined)
                return;
            self.onUpdatedFieldList();
        }, true));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Log.fields;
        }, function (after, before) {
            if (after === before || !_.any(after))
                return;
            if (_.every(after, function (item) { return item.isKey; })) {
                _this.notificationService.errorMessage(_this.language.getElementValue('reportParameterLogCantSetAllFieldAsKeyMsg'));
                _this.parentScope.param.Log.fields = _.map(before, function (field) {
                    return new LogFieldScope(_this.parentScope, field, _this.fieldTypes, _this.fieldList.openDropdownFieldSettingsWindow, _this.language);
                });
            }
        }, true));
        this.onUpdatedFieldList();
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('LogRow[]');
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    LogSettingsCtrl.prototype.destroy = function () {
        this.widthDimensionTypes.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    LogSettingsCtrl.prototype.getFormula = function () {
        if (!_.isUndefined(this.parentScope.param.Log.initialParameter) &&
            _.any(this.parentScope.param.Log.initialParameter) &&
            this.parentScope.param.Log.initialParameter !== '') {
            return 'return %' + this.parentScope.param.Log.initialParameter + '%;';
        }
        return 'return new LogRow[] { };';
    };
    LogSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        if (_.isUndefined(this.parentScope))
            return false;
        if (_.isDefined(this.fieldList) && !this.fieldList.isCorrect) {
            return true;
        }
        return _.any(this.parentScope.param.Log.fields, function (f) {
            return (_.isEmpty(f.caption) ||
                (f.type == LogFieldTypes[LogFieldTypes.Double].toLowerCase() && f.defaultValue === '-'));
        });
    };
    LogSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Log.canEdited();
    };
    LogSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Log.canPlanned();
    };
    LogSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Log.canBacklight();
    };
    LogSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Log.canPredefined();
    };
    return LogSettingsCtrl;
}());
