var HttpSettingsCtrl = (function () {
    function HttpSettingsCtrl(parentScope) {
        this.parentScope = parentScope;
        this.methods = [
            new UiSelectItem('GET', 'GET'),
            new UiSelectItem('HEAD', 'HEAD'),
            new UiSelectItem('POST', 'POST'),
            new UiSelectItem('PUT', 'PUT'),
            new UiSelectItem('DELETE', 'DELETE'),
            new UiSelectItem('OPTIONS', 'OPTIONS'),
        ];
        this.connectionTypes = [8];
    }
    HttpSettingsCtrl.prototype.init = function () {
        var _this = this;
        this.parentScope.settingsCtrl.formulaCtrl.isSplittable = false;
        this.parentScope.settingsCtrl.formulaCtrl.isRounded = false;
        this.selectedMethod = _.find(this.methods, function (method) { return method.ident === _this.parentScope.param.Http.method; });
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('string');
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.addHeader = function () {
        this.parentScope.param.Http.headers.push({ key: '', value: '' });
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.removeHeader = function (header) {
        this.parentScope.param.Http.headers = _.filter(this.parentScope.param.Http.headers, function (h) { return h !== header; });
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.onConnectionSelected = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.onPathChanged = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.onMethodSelected = function (method) {
        this.parentScope.param.Http.method = method.ident;
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.onBodyChanged = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.onHeaderChanged = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    HttpSettingsCtrl.prototype.destroy = function () { };
    HttpSettingsCtrl.prototype.getFormula = function () {
        var headers = 'new KeyValuePair<string, string>[] { ';
        _.forEach(this.parentScope.param.Http.headers, function (header) {
            headers +=
                'new KeyValuePair<string, string>(' +
                    '"' +
                    header.key +
                    '"' +
                    ', ' +
                    '"' +
                    header.value +
                    '"' +
                    ')' +
                    ', ';
        });
        headers += '}';
        return ('return HttpRequestByConnection(' +
            '"' +
            this.parentScope.param.Http.connectionGuid +
            '", ' +
            '"' +
            this.parentScope.param.Http.path +
            '", ' +
            '"' +
            this.parentScope.param.Http.method +
            '", ' +
            '"' +
            this.parentScope.param.Http.body +
            '", ' +
            headers +
            ');');
    };
    HttpSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    HttpSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Http.canEdited();
    };
    HttpSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Http.canPlanned();
    };
    HttpSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Http.canBacklight();
    };
    HttpSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Http.canPredefined();
    };
    return HttpSettingsCtrl;
}());
