var SwitchoverFormImportProviderJson = (function () {
    function SwitchoverFormImportProviderJson(serverPath, getImportInfoPath, importJsonPath, isTemplateImport) {
        if (isTemplateImport === void 0) { isTemplateImport = false; }
        this.serverPath = serverPath;
        this.getImportInfoPath = getImportInfoPath;
        this.importJsonPath = importJsonPath;
        this.isTemplateImport = isTemplateImport;
        this.fileExtension = '.json';
        this.serverPath = serverPath;
        this.data = {
            importInfo: [],
            bindToTypicalOperationAndConditionsIfExists: false,
        };
    }
    SwitchoverFormImportProviderJson.prototype.getImportInfoForImport = function () {
        var importInfo = _.map(_.where(this.importOptions, function (t) { return t.isSelected; }), function (t) { return t.info; });
        var importSettings = this.isTemplateImport
            ? {
                url: this.serverPath + this.importJsonPath,
                file: this.files,
                data: {
                    importInfo: importInfo,
                    bindToTypicalOperationAndConditionsIfExists: this.data.bindToTypicalOperationAndConditionsIfExists,
                },
            }
            : {
                url: this.serverPath + this.importJsonPath,
                file: this.files,
                data: {
                    importInfo: importInfo,
                },
            };
        return importSettings;
    };
    SwitchoverFormImportProviderJson.prototype.getImportInfoForSelect = function () {
        return {
            url: this.serverPath + this.getImportInfoPath,
            file: this.files,
        };
    };
    return SwitchoverFormImportProviderJson;
}());
var SwitchoverFormImportProviderDocx = (function () {
    function SwitchoverFormImportProviderDocx(serverPath, getImportInfoPath, importDocxPath, isTemplateImport) {
        if (isTemplateImport === void 0) { isTemplateImport = false; }
        this.serverPath = serverPath;
        this.getImportInfoPath = getImportInfoPath;
        this.importDocxPath = importDocxPath;
        this.isTemplateImport = isTemplateImport;
        this.fileExtension = '.docx';
        this.serverPath = serverPath;
        this.data = {
            importInfo: [],
            bindToTypicalOperationAndConditionsIfExists: false,
            needStandardizeFont: false,
            chapterName: ''
        };
    }
    SwitchoverFormImportProviderDocx.prototype.getImportInfoForImport = function () {
        var importInfo = _.map(_.where(this.importOptions, function (t) { return t.isSelected; }), function (t) { return t.info; });
        var importSettings = this.isTemplateImport
            ? {
                url: this.serverPath + this.importDocxPath,
                file: this.files,
                data: {
                    importInfo: importInfo,
                    bindToTypicalOperationAndConditionsIfExists: this.data.bindToTypicalOperationAndConditionsIfExists,
                    needStandardizeFont: this.data.needStandardizeFont,
                    chapterName: this.data.chapterName
                },
            }
            : {
                url: this.serverPath + this.importDocxPath,
                file: this.files,
                data: {
                    importInfo: importInfo,
                },
            };
        return importSettings;
    };
    SwitchoverFormImportProviderDocx.prototype.getImportInfoForSelect = function () {
        return {
            url: this.serverPath + this.getImportInfoPath,
            file: this.files,
        };
    };
    return SwitchoverFormImportProviderDocx;
}());
