var SwitchoverFormsController = (function () {
    function SwitchoverFormsController(scope, modal, upload, switchoverFormService, switchoverFormProviderService, switchoverFormTemplateProviderService, authentication, permissionService, userPreferencesService, notificationService, language) {
        this.scope = scope;
        this.modal = modal;
        this.upload = upload;
        this.switchoverFormService = switchoverFormService;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.authentication = authentication;
        this.permissionService = permissionService;
        this.userPreferencesService = userPreferencesService;
        this.notificationService = notificationService;
        this.language = language;
        this.forms = [];
        this.formNames = [];
        this.templates = [];
        this.sort = {
            columnName: 'creationDate',
            descending: true,
        };
        this.scope.ctrl = this;
        this.permissions = this.permissionService.getAll();
        this.userPreferences = this.userPreferencesService.getPreferences();
        this.filter = this.getDefaultFilter();
        this.loadTemplates();
        this.loadFormNames();
        this.filterForms();
    }
    SwitchoverFormsController.prototype.loadTemplates = function () {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .getAllSwitchoverFormTemplatesShortInfo()
            .then(function (templates) {
            var _a;
            _this.templates = _.sortBy(templates, function (t) { return t.name; });
            if (templates.length === 0) {
                return;
            }
            _this.selectedTemplate =
                (_a = _.find(templates, function (t) { return t.id === _this.userPreferences.switchoverForm.lastSelectedTemplateId; })) !== null && _a !== void 0 ? _a : templates[0];
        })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormsController.prototype.isCreateFormButtonDisabled = function () {
        return !_.isEmpty(this.templates) && _.isDefined(this.selectedTemplate);
    };
    SwitchoverFormsController.prototype.loadFormNames = function () {
        var _this = this;
        this.switchoverFormProviderService
            .getAllNames()
            .then(function (names) { return (_this.formNames = names); })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormsController.prototype.filterForms = function () {
        var _this = this;
        var formFilter = angular.copy(this.filter);
        formFilter.startDate = Date.convertToUtc(formFilter.startDate);
        formFilter.endDate = Date.convertToUtc(formFilter.endDate);
        this.switchoverFormProviderService
            .getSwitchoverFormsInfo(formFilter)
            .then(function (forms) {
            _this.forms = forms;
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormsController.prototype.resetFilter = function () {
        this.filter = this.getDefaultFilter();
    };
    SwitchoverFormsController.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    SwitchoverFormsController.prototype.createForm = function () {
        this.switchoverFormService.create(this.selectedTemplate.id, this.selectedTemplate.name);
    };
    SwitchoverFormsController.prototype.previewForm = function () {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .getPreview(this.selectedTemplate.id)
            .then(function (formPreviewHtml) {
            _this.modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Forms/PreviewModal/PreviewSwitchoverFormModal.html',
                controller: 'previewSwitchoverFormModalCtrl',
                windowClass: 'switchover-form-preview-window',
                resolve: {
                    formPreviewHtml: function () { return formPreviewHtml; },
                },
            });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormsController.prototype.getFormStatus = function (form) {
        switch (form.status) {
            case 0:
                return this.language.getElementValue('switchoverFormsStatusOpenedHdr');
            case 2:
                return this.language.getElementValue('switchoverFormsStatusClosedHdr');
            case 1:
                return this.language.getElementValue('switchoverFormsStatusStoppedHdr');
            default:
                return '';
        }
    };
    SwitchoverFormsController.prototype.onSelectedTemplateChange = function () {
        this.userPreferences.switchoverForm.lastSelectedTemplateId = this.selectedTemplate.id;
        this.userPreferencesService.setPreferences(this.userPreferences);
    };
    SwitchoverFormsController.prototype.importSwitchoverFormTemplates = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/ImportTemplateModal/SwitchoverFormTemplateImportModal.html',
            controller: 'switchoverFormTemplateImportModalCtrl',
            backdrop: 'static',
            resolve: {
                chapters: function () { return []; },
            },
        })
            .result.then(function (uploadData) {
            _this.upload
                .upload(uploadData)
                .success(function () { return _this.loadTemplates(); })
                .error(function (errorInfo) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorTemplatesImportMsg'), errorInfo);
            });
        }, function () { });
    };
    SwitchoverFormsController.prototype.hasSwitchoverFormAdminPermission = function () {
        return this.authentication.hasPermission(this.permissions.SwitchoverFormTemplateAdmin);
    };
    SwitchoverFormsController.prototype.getDefaultFilter = function () {
        var now = new Date();
        return {
            name: null,
            serialNumber: null,
            startDate: new Date(now.getFullYear(), 0, 1),
            endDate: now,
            isOpened: true,
            isClosed: true,
            isStopped: true,
        };
    };
    SwitchoverFormsController.$inject = [
        '$scope',
        '$modal',
        '$upload',
        'switchoverFormService',
        'switchoverFormProvider',
        'switchoverFormTemplateProvider',
        'authentication',
        'permissionService',
        'userPreferencesService',
        'notificationService',
        'language',
    ];
    return SwitchoverFormsController;
}());
angular.module('kamhpp').controller('SwitchoverFormsCtrl', SwitchoverFormsController);
